/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl;

import java.util.Objects;
import org.eclipse.aether.spi.connector.checksum.ChecksumPolicy;
import org.eclipse.aether.transfer.ChecksumFailureException;
import org.eclipse.aether.transfer.TransferResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class AbstractChecksumPolicy
implements ChecksumPolicy {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final TransferResource resource;

    protected AbstractChecksumPolicy(TransferResource resource2) {
        this.resource = resource2;
    }

    @Override
    public boolean onChecksumMatch(String algorithm, ChecksumPolicy.ChecksumKind kind) {
        Objects.requireNonNull(algorithm, "algorithm cannot be null");
        return true;
    }

    @Override
    public void onChecksumMismatch(String algorithm, ChecksumPolicy.ChecksumKind kind, ChecksumFailureException exception) throws ChecksumFailureException {
        Objects.requireNonNull(algorithm, "algorithm cannot be null");
        Objects.requireNonNull(exception, "exception cannot be null");
        throw exception;
    }

    @Override
    public void onChecksumError(String algorithm, ChecksumPolicy.ChecksumKind kind, ChecksumFailureException exception) throws ChecksumFailureException {
        Objects.requireNonNull(algorithm, "algorithm cannot be null");
        Objects.requireNonNull(exception, "exception cannot be null");
        this.logger.debug("Could not validate {} checksum for {}", algorithm, this.resource.getResourceName(), exception);
    }

    @Override
    public void onNoMoreChecksums() throws ChecksumFailureException {
        throw new ChecksumFailureException("Checksum validation failed, no checksums available");
    }

    @Override
    public void onTransferRetry() {
    }
}

