/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal;

import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import org.gradle.api.Action;
import org.gradle.api.file.FileCollection;
import org.gradle.api.jvm.ModularitySpec;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.Property;
import org.gradle.process.BaseExecSpec;
import org.gradle.process.CommandLineArgumentProvider;
import org.gradle.process.ExecResult;
import org.gradle.process.JavaDebugOptions;
import org.gradle.process.JavaExecSpec;
import org.gradle.process.JavaForkOptions;
import org.gradle.process.ProcessForkOptions;
import org.gradle.process.internal.ExecHandle;
import org.gradle.process.internal.ExecHandleListener;
import org.gradle.process.internal.JavaExecAction;
import org.gradle.process.internal.JavaExecHandleBuilder;
import org.jspecify.annotations.Nullable;

public class DefaultJavaExecAction
implements JavaExecAction {
    private final JavaExecHandleBuilder javaExecHandleBuilder;
    private boolean ignoreExitValue;

    public DefaultJavaExecAction(JavaExecHandleBuilder javaExecHandleBuilder) {
        this.javaExecHandleBuilder = javaExecHandleBuilder;
    }

    @Override
    public ExecResult execute() {
        ExecHandle execHandle = this.javaExecHandleBuilder.build();
        ExecResult execResult = execHandle.start().waitForFinish();
        if (!this.ignoreExitValue) {
            execResult.assertNormalExitValue();
        }
        return execResult;
    }

    public ListProperty<String> getJvmArguments() {
        return this.javaExecHandleBuilder.getJvmArguments();
    }

    public Property<String> getMainModule() {
        return this.javaExecHandleBuilder.getMainModule();
    }

    public Property<String> getMainClass() {
        return this.javaExecHandleBuilder.getMainClass();
    }

    public List<String> getArgs() {
        return this.javaExecHandleBuilder.getArgs();
    }

    public JavaExecSpec args(Object ... args) {
        this.javaExecHandleBuilder.args(args);
        return this;
    }

    public JavaExecSpec args(Iterable<?> args) {
        this.javaExecHandleBuilder.args(args);
        return this;
    }

    public JavaExecSpec setArgs(List<String> args) {
        this.javaExecHandleBuilder.setArgs(args);
        return this;
    }

    public JavaExecSpec setArgs(Iterable<?> args) {
        this.javaExecHandleBuilder.setArgs(args);
        return this;
    }

    public List<CommandLineArgumentProvider> getArgumentProviders() {
        return this.javaExecHandleBuilder.getArgumentProviders();
    }

    public JavaExecSpec classpath(Object ... paths) {
        this.javaExecHandleBuilder.classpath(paths);
        return this;
    }

    public FileCollection getClasspath() {
        return this.javaExecHandleBuilder.getClasspath();
    }

    public JavaExecSpec setClasspath(FileCollection classpath) {
        this.javaExecHandleBuilder.setClasspath(classpath);
        return this;
    }

    public ModularitySpec getModularity() {
        return this.javaExecHandleBuilder.getModularity();
    }

    public BaseExecSpec setIgnoreExitValue(boolean ignoreExitValue) {
        this.ignoreExitValue = ignoreExitValue;
        return this;
    }

    public boolean isIgnoreExitValue() {
        return this.ignoreExitValue;
    }

    public BaseExecSpec setStandardInput(InputStream inputStream) {
        this.javaExecHandleBuilder.setStandardInput(inputStream);
        return this;
    }

    public InputStream getStandardInput() {
        return this.javaExecHandleBuilder.getStandardInput();
    }

    public BaseExecSpec setStandardOutput(OutputStream outputStream) {
        this.javaExecHandleBuilder.setStandardOutput(outputStream);
        return this;
    }

    public OutputStream getStandardOutput() {
        return this.javaExecHandleBuilder.getStandardOutput();
    }

    public BaseExecSpec setErrorOutput(OutputStream outputStream) {
        this.javaExecHandleBuilder.setErrorOutput(outputStream);
        return this;
    }

    public OutputStream getErrorOutput() {
        return this.javaExecHandleBuilder.getErrorOutput();
    }

    public List<String> getCommandLine() {
        return this.javaExecHandleBuilder.getCommandLine();
    }

    public Map<String, @Nullable Object> getSystemProperties() {
        return this.javaExecHandleBuilder.getSystemProperties();
    }

    public void setSystemProperties(Map<String, ? extends @Nullable Object> properties) {
        this.javaExecHandleBuilder.setSystemProperties(properties);
    }

    public JavaForkOptions systemProperties(Map<String, ? extends @Nullable Object> properties) {
        this.javaExecHandleBuilder.systemProperties(properties);
        return this;
    }

    public JavaForkOptions systemProperty(String name, @Nullable Object value) {
        this.javaExecHandleBuilder.systemProperty(name, value);
        return this;
    }

    public @Nullable String getDefaultCharacterEncoding() {
        return this.javaExecHandleBuilder.getDefaultCharacterEncoding();
    }

    public void setDefaultCharacterEncoding(@Nullable String defaultCharacterEncoding) {
        this.javaExecHandleBuilder.setDefaultCharacterEncoding(defaultCharacterEncoding);
    }

    public @Nullable String getMinHeapSize() {
        return this.javaExecHandleBuilder.getMinHeapSize();
    }

    public void setMinHeapSize(@Nullable String heapSize) {
        this.javaExecHandleBuilder.setMinHeapSize(heapSize);
    }

    public @Nullable String getMaxHeapSize() {
        return this.javaExecHandleBuilder.getMaxHeapSize();
    }

    public void setMaxHeapSize(@Nullable String heapSize) {
        this.javaExecHandleBuilder.setMaxHeapSize(heapSize);
    }

    public List<String> getJvmArgs() {
        return this.javaExecHandleBuilder.getJvmArgs();
    }

    public void setJvmArgs(List<String> arguments) {
        this.javaExecHandleBuilder.setJvmArgs(arguments);
    }

    public void setJvmArgs(Iterable<?> arguments) {
        this.javaExecHandleBuilder.setJvmArgs(arguments);
    }

    public JavaForkOptions jvmArgs(Iterable<?> arguments) {
        this.javaExecHandleBuilder.jvmArgs(arguments);
        return this;
    }

    public JavaForkOptions jvmArgs(Object ... arguments) {
        this.javaExecHandleBuilder.jvmArgs(arguments);
        return this;
    }

    public List<CommandLineArgumentProvider> getJvmArgumentProviders() {
        return this.javaExecHandleBuilder.getJvmArgumentProviders();
    }

    public FileCollection getBootstrapClasspath() {
        return this.javaExecHandleBuilder.getBootstrapClasspath();
    }

    public void setBootstrapClasspath(FileCollection classpath) {
        this.javaExecHandleBuilder.setBootstrapClasspath(classpath);
    }

    public JavaForkOptions bootstrapClasspath(Object ... classpath) {
        this.javaExecHandleBuilder.bootstrapClasspath(classpath);
        return this;
    }

    public boolean getEnableAssertions() {
        return this.javaExecHandleBuilder.getEnableAssertions();
    }

    public void setEnableAssertions(boolean enabled) {
        this.javaExecHandleBuilder.setEnableAssertions(enabled);
    }

    public boolean getDebug() {
        return this.javaExecHandleBuilder.getDebug();
    }

    public void setDebug(boolean enabled) {
        this.javaExecHandleBuilder.setDebug(enabled);
    }

    public JavaDebugOptions getDebugOptions() {
        return this.javaExecHandleBuilder.getDebugOptions();
    }

    public void debugOptions(Action<JavaDebugOptions> action) {
        this.javaExecHandleBuilder.debugOptions(action);
    }

    public List<String> getAllJvmArgs() {
        return this.javaExecHandleBuilder.getAllJvmArgs();
    }

    @Deprecated
    public void setAllJvmArgs(List<String> arguments) {
        throw new UnsupportedOperationException();
    }

    @Deprecated
    public void setAllJvmArgs(Iterable<?> arguments) {
        throw new UnsupportedOperationException();
    }

    public String getExecutable() {
        return this.javaExecHandleBuilder.getExecutable();
    }

    public void setExecutable(String executable) {
        this.javaExecHandleBuilder.setExecutable(executable);
    }

    public void setExecutable(Object executable) {
        this.javaExecHandleBuilder.setExecutable(executable);
    }

    public ProcessForkOptions executable(Object executable) {
        this.javaExecHandleBuilder.setExecutable(executable);
        return this;
    }

    public File getWorkingDir() {
        return this.javaExecHandleBuilder.getWorkingDir();
    }

    public void setWorkingDir(File dir) {
        this.javaExecHandleBuilder.setWorkingDir(dir);
    }

    public void setWorkingDir(Object dir) {
        this.javaExecHandleBuilder.setWorkingDir(dir);
    }

    public ProcessForkOptions workingDir(Object dir) {
        this.javaExecHandleBuilder.setWorkingDir(dir);
        return this;
    }

    public Map<String, Object> getEnvironment() {
        return this.javaExecHandleBuilder.getEnvironment();
    }

    public void setEnvironment(Map<String, ?> environmentVariables) {
        this.javaExecHandleBuilder.setEnvironment(environmentVariables);
    }

    public ProcessForkOptions environment(Map<String, ?> environmentVariables) {
        this.javaExecHandleBuilder.environment(environmentVariables);
        return this;
    }

    public ProcessForkOptions environment(String name, Object value) {
        this.javaExecHandleBuilder.environment(name, value);
        return this;
    }

    @Override
    public JavaExecAction listener(ExecHandleListener listener) {
        this.javaExecHandleBuilder.listener(listener);
        return this;
    }

    public ProcessForkOptions copyTo(ProcessForkOptions options) {
        throw new UnsupportedOperationException();
    }

    public JavaForkOptions copyTo(JavaForkOptions options) {
        throw new UnsupportedOperationException();
    }
}

