/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;

public class ISO8601DateConverter {
    private static final String DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final String SHORT_DATETIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String DATETIME_PATTERN_NO_S = "yyyy-MM-dd'T'HH:mm'Z'";
    private static final String DATETIME_PATTERN_TO_DECIMAL = "yyyy-MM-dd'T'HH:mm:ss.";

    public String format(Date date) {
        SimpleDateFormat iso8601Format = new SimpleDateFormat(DATETIME_PATTERN, Locale.US);
        iso8601Format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return iso8601Format.format(date);
    }

    public String shortFormat(Date date) {
        SimpleDateFormat iso8601Format = new SimpleDateFormat(SHORT_DATETIME_PATTERN, Locale.US);
        iso8601Format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return iso8601Format.format(date);
    }

    public Date parse(String date) throws ParseException {
        if (date == null) {
            return null;
        }
        int length = date.length();
        if (length == 17) {
            return ISO8601DateConverter.parseDateFromString(date, DATETIME_PATTERN_NO_S);
        }
        if (length == 20) {
            return ISO8601DateConverter.parseDateFromString(date, SHORT_DATETIME_PATTERN);
        }
        if (length >= 22 && length <= 28) {
            Date allExceptMilliseconds = ISO8601DateConverter.parseDateFromString(date, DATETIME_PATTERN_TO_DECIMAL);
            long timeWithSecondGranularity = allExceptMilliseconds.getTime();
            String secondDecimalString = date.substring(19, date.indexOf(90));
            Float secondDecimal = Float.valueOf(Float.parseFloat(secondDecimalString));
            int milliseconds = Math.round(secondDecimal.floatValue() * 1000.0f);
            long timeInMS = timeWithSecondGranularity + (long)milliseconds;
            Calendar calendar = Calendar.getInstance();
            calendar.setTimeInMillis(timeInMS);
            return calendar.getTime();
        }
        throw new IllegalArgumentException(String.format("Invalid Date String: %s", date));
    }

    private static Date parseDateFromString(String value, String pattern) throws ParseException {
        SimpleDateFormat iso8601Format = new SimpleDateFormat(pattern, Locale.US);
        iso8601Format.setTimeZone(TimeZone.getTimeZone("GMT"));
        return iso8601Format.parse(value);
    }
}

