/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.knn.plugin.rest;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.TreeSet;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.opensearch.action.ActionRequest;
import org.opensearch.action.ActionType;
import org.opensearch.core.action.ActionListener;
import org.opensearch.knn.plugin.transport.KNNStatsAction;
import org.opensearch.knn.plugin.transport.KNNStatsRequest;
import org.opensearch.rest.BaseRestHandler;
import org.opensearch.rest.RestHandler;
import org.opensearch.rest.RestRequest;
import org.opensearch.rest.action.RestActions;
import org.opensearch.transport.client.node.NodeClient;

public class RestKNNStatsHandler
extends BaseRestHandler {
    private static final String NAME = "knn_stats_action";
    private static final List<RestHandler.Route> STATS_ROUTES = ImmutableList.of((Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_knn/{nodeId}/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_knn/{nodeId}/stats/{stat}"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_knn/stats/"), (Object)new RestHandler.Route(RestRequest.Method.GET, "/_plugins/_knn/stats/{stat}"));

    public String getName() {
        return NAME;
    }

    public List<RestHandler.Route> routes() {
        return this.getStatsRoutes();
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) {
        KNNStatsRequest knnStatsRequest = this.getRequest(request);
        return channel -> client.execute((ActionType)KNNStatsAction.INSTANCE, (ActionRequest)knnStatsRequest, (ActionListener)new RestActions.NodesResponseRestListener(channel));
    }

    private KNNStatsRequest getRequest(RestRequest request) {
        String[] nodeIdsArr = null;
        String nodesIdsStr = request.param("nodeId");
        if (StringUtils.isNotEmpty((CharSequence)nodesIdsStr)) {
            nodeIdsArr = nodesIdsStr.split(",");
        }
        KNNStatsRequest knnStatsRequest = new KNNStatsRequest(nodeIdsArr);
        knnStatsRequest.timeout(request.param("timeout"));
        HashSet<String> statsSet = null;
        String statsStr = request.param("stat");
        if (StringUtils.isNotEmpty((CharSequence)statsStr)) {
            statsSet = new HashSet<String>(Arrays.asList(statsStr.split(",")));
        }
        if (statsSet == null) {
            knnStatsRequest.all();
        } else if (statsSet.size() == 1 && statsSet.contains("_all")) {
            knnStatsRequest.all();
        } else {
            if (statsSet.contains("_all")) {
                throw new IllegalArgumentException("Request " + request.path() + " contains _all and individual stats");
            }
            TreeSet<String> invalidStats = new TreeSet<String>();
            for (String stat : statsSet) {
                if (knnStatsRequest.addStat(stat)) continue;
                invalidStats.add(stat);
            }
            if (!invalidStats.isEmpty()) {
                throw new IllegalArgumentException(this.unrecognized(request, invalidStats, knnStatsRequest.getStatsToBeRetrieved(), "stat"));
            }
        }
        return knnStatsRequest;
    }

    private List<RestHandler.Route> getStatsRoutes() {
        return STATS_ROUTES;
    }

    @Generated
    public RestKNNStatsHandler() {
    }
}

