/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.sql.prometheus.storage.system;

import com.google.common.annotations.VisibleForTesting;
import java.util.Map;
import lombok.Generated;
import org.apache.commons.lang3.tuple.Pair;
import org.opensearch.sql.DataSourceSchemaName;
import org.opensearch.sql.data.type.ExprType;
import org.opensearch.sql.planner.DefaultImplementor;
import org.opensearch.sql.planner.logical.LogicalPlan;
import org.opensearch.sql.planner.logical.LogicalPlanNodeVisitor;
import org.opensearch.sql.planner.logical.LogicalRelation;
import org.opensearch.sql.planner.physical.PhysicalPlan;
import org.opensearch.sql.prometheus.client.PrometheusClient;
import org.opensearch.sql.prometheus.request.system.PrometheusDescribeMetricRequest;
import org.opensearch.sql.prometheus.request.system.PrometheusListMetricsRequest;
import org.opensearch.sql.prometheus.request.system.PrometheusSystemRequest;
import org.opensearch.sql.prometheus.storage.system.PrometheusSystemTableScan;
import org.opensearch.sql.prometheus.storage.system.PrometheusSystemTableSchema;
import org.opensearch.sql.storage.Table;
import org.opensearch.sql.utils.SystemIndexUtils;

public class PrometheusSystemTable
implements Table {
    private final Pair<PrometheusSystemTableSchema, PrometheusSystemRequest> systemIndexBundle;
    private final DataSourceSchemaName dataSourceSchemaName;

    public PrometheusSystemTable(PrometheusClient client, DataSourceSchemaName dataSourceSchemaName, String indexName) {
        this.dataSourceSchemaName = dataSourceSchemaName;
        this.systemIndexBundle = this.buildIndexBundle(client, indexName);
    }

    public Map<String, ExprType> getFieldTypes() {
        return ((PrometheusSystemTableSchema)((Object)this.systemIndexBundle.getLeft())).getMapping();
    }

    public PhysicalPlan implement(LogicalPlan plan) {
        return (PhysicalPlan)plan.accept((LogicalPlanNodeVisitor)new PrometheusSystemTableDefaultImplementor(), null);
    }

    private Pair<PrometheusSystemTableSchema, PrometheusSystemRequest> buildIndexBundle(PrometheusClient client, String indexName) {
        SystemIndexUtils.SystemTable systemTable = SystemIndexUtils.systemTable((String)indexName);
        if (systemTable.isSystemInfoTable()) {
            return Pair.of((Object)((Object)PrometheusSystemTableSchema.SYS_TABLE_TABLES), (Object)new PrometheusListMetricsRequest(client, this.dataSourceSchemaName));
        }
        return Pair.of((Object)((Object)PrometheusSystemTableSchema.SYS_TABLE_MAPPINGS), (Object)new PrometheusDescribeMetricRequest(client, this.dataSourceSchemaName, systemTable.getTableName()));
    }

    @VisibleForTesting
    public class PrometheusSystemTableDefaultImplementor
    extends DefaultImplementor<Object> {
        public PhysicalPlan visitRelation(LogicalRelation node, Object context) {
            return new PrometheusSystemTableScan((PrometheusSystemRequest)PrometheusSystemTable.this.systemIndexBundle.getRight());
        }

        @Generated
        public PrometheusSystemTableDefaultImplementor() {
        }
    }
}

