/*
 * Decompiled with CFR 0.152.
 */
package org.opensolaris.os.dtrace;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.opensolaris.os.dtrace.Aggregate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AggregateSpec {
    private Set<String> includedAggregationNames = new HashSet<String>();
    private Set<String> clearedAggregationNames = new HashSet<String>();

    AggregateSpec() {
    }

    public boolean isIncludeByDefault() {
        return this.includedAggregationNames == null;
    }

    public boolean isClearByDefault() {
        return this.clearedAggregationNames == null;
    }

    public void setIncludeByDefault(boolean include) {
        if (include) {
            this.includedAggregationNames = null;
        } else if (this.includedAggregationNames == null) {
            this.includedAggregationNames = new HashSet<String>();
        }
    }

    public void setClearByDefault(boolean clear) {
        if (clear) {
            this.clearedAggregationNames = null;
        } else if (this.clearedAggregationNames == null) {
            this.clearedAggregationNames = new HashSet<String>();
        }
    }

    public void addIncludedAggregationName(String name) {
        if (this.includedAggregationNames == null) {
            this.includedAggregationNames = new HashSet<String>();
        }
        this.includedAggregationNames.add(Aggregate.filterUnnamedAggregationName(name));
    }

    public void addClearedAggregationName(String name) {
        if (this.clearedAggregationNames == null) {
            this.clearedAggregationNames = new HashSet<String>();
        }
        this.clearedAggregationNames.add(Aggregate.filterUnnamedAggregationName(name));
    }

    public Set<String> getIncludedAggregationNames() {
        if (this.includedAggregationNames == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.includedAggregationNames);
    }

    public Set<String> getClearedAggregationNames() {
        if (this.clearedAggregationNames == null) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this.clearedAggregationNames);
    }

    public boolean isIncluded(String aggregationName) {
        return this.includedAggregationNames == null || this.includedAggregationNames.contains(Aggregate.filterUnnamedAggregationName(aggregationName));
    }

    public boolean isCleared(String aggregationName) {
        return this.clearedAggregationNames == null || this.clearedAggregationNames.contains(Aggregate.filterUnnamedAggregationName(aggregationName));
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(AggregateSpec.class.getName());
        buf.append("[includedAggregationNames = ");
        buf.append(Arrays.toString(this.getIncludedAggregationNames().toArray()));
        buf.append(", clearedAggregationNames = ");
        buf.append(Arrays.toString(this.getClearedAggregationNames().toArray()));
        buf.append(", includeByDefault = ");
        buf.append(this.isIncludeByDefault());
        buf.append(", clearByDefault = ");
        buf.append(this.isClearByDefault());
        buf.append(']');
        return buf.toString();
    }
}

