/*
 * Decompiled with CFR 0.152.
 */
package ork.plugins;

import cqure.repeng.ReportObject;
import cqure.repeng.ReportTree;
import java.util.Vector;
import ork.Account;
import ork.AccountList;
import ork.CommonValuesDB;
import ork.Logger;
import ork.OracleDBConnection;
import ork.PasswordList;
import ork.PluginReport;
import ork.SIDList;
import ork.ScannerConfig;
import ork.ServerResult;
import ork.UserList;
import ork.plugins.PluginIface;
import ork.plugins.SysAccountEnumerator;

public class CheckUserSuppliedPasswords
implements PluginIface {
    private CommonValuesDB m_oDB;
    private ServerResult m_oRes = null;
    private static final int STATUS_RERUN = 1;
    private static final int STATUS_SUCCESS = 0;
    private Logger m_oLogger = new Logger();
    private String m_sServer = null;
    private String m_sSID = null;
    private int m_nPort = -1;
    private ScannerConfig m_oConfig = null;
    private ReportTree m_oTree = null;

    public void setCommonValuesDB(CommonValuesDB oDB) {
        this.m_oDB = oDB;
    }

    public void setServerResult(ServerResult oRes) {
        this.m_oRes = oRes;
    }

    public void setLogger(Logger oLogger) {
        this.m_oLogger = oLogger;
    }

    public void setParameters(Object o) {
    }

    public void setConfig(ScannerConfig o) {
        this.m_oConfig = o;
    }

    public void setReportTree(ReportTree o) {
        this.m_oTree = o;
    }

    public CheckUserSuppliedPasswords(ServerResult oRes) {
        this.m_oRes = oRes;
        this.m_nPort = this.m_oRes.getPort();
        this.m_sServer = this.m_oRes.getServer();
    }

    public int checkAccounts(String sSID, UserList oU, PasswordList oP) {
        String sUID = null;
        String sPWD = null;
        AccountList oA = this.m_oRes.getAccountList();
        OracleDBConnection oOraDB = new OracleDBConnection(this.m_sServer, this.m_nPort, sSID);
        SysAccountEnumerator oSysAccEnum = null;
        Vector oUsers = null;
        if (oA != null && !oA.isAccountsEnumeratedForSID(sSID)) {
            int i = 0;
            while (i < oU.size()) {
                sUID = ((String)oU.get(i)).toUpperCase();
                oOraDB.setUser(sUID);
                int j = 0;
                while (j < oP.size()) {
                    sPWD = ((String)oP.get(j)).toUpperCase();
                    if (sPWD.equalsIgnoreCase("%username%")) {
                        sPWD = sUID;
                    }
                    oOraDB.setPassword(sPWD);
                    this.m_oLogger.debug("[-] Trying " + sUID + "/" + sPWD);
                    int nErr = oOraDB.login();
                    if (nErr == 0) {
                        this.m_oLogger.log("[-] Account " + sUID + "/" + sPWD + " found");
                        this.m_oRes.addAccount(sSID, sUID, sPWD, null, nErr);
                        oSysAccEnum = new SysAccountEnumerator(oOraDB.getConnection(), sSID, this.m_oRes, this.m_oLogger);
                        if (oSysAccEnum.enumerateSysAccounts()) {
                            oA.setAccountsEnumeratedForSID(sSID);
                            oOraDB.close();
                            return 1;
                        }
                    } else if (nErr == 28000) {
                        this.m_oLogger.log("[-] Account " + sUID + "/" + sPWD + " is locked");
                        this.m_oRes.addAccount(sSID, sUID, "", null, nErr);
                    } else if (nErr == 28009) {
                        this.m_oLogger.log("[-] Account " + sUID + "/" + sPWD + " requires connect as sysdba");
                        this.m_oRes.addAccount(sSID, sUID, sPWD, null, 0);
                    } else {
                        if (nErr == 17002) {
                            this.m_oLogger.log("[x] Got IO Exception");
                            break;
                        }
                        if (nErr != 1017) {
                            this.m_oLogger.log("[x] Error: " + nErr + " occured");
                        }
                    }
                    oOraDB.close();
                    ++j;
                }
                ++i;
            }
        } else {
            this.m_oLogger.log("[-] Checking user supplied dictionary");
            oUsers = oA.getUknownAccountsForSID(sSID);
            int i = 0;
            while (i < oUsers.size()) {
                sUID = ((Account)oUsers.get(i)).getUsername();
                oOraDB.setUser(sUID);
                int j = 0;
                while (j < oP.size()) {
                    sPWD = ((String)oP.get(j)).toUpperCase();
                    if (sPWD.equalsIgnoreCase("%username%")) {
                        sPWD = sUID;
                    }
                    oOraDB.setPassword(sPWD);
                    this.m_oLogger.debug("[-] Trying " + sUID + "/" + sPWD);
                    int nErr = oOraDB.login();
                    if (nErr == 0) {
                        this.m_oLogger.log("[-] Account " + sUID + "/" + sPWD + " found");
                        this.m_oRes.addAccount(sSID, sUID, sPWD, null, nErr);
                        break;
                    }
                    if (nErr == 28000) {
                        this.m_oLogger.log("[-] Account " + sUID + "/" + sPWD + " is locked");
                        this.m_oRes.addAccount(sSID, sUID, "", null, nErr);
                        break;
                    }
                    if (nErr == 28009) {
                        this.m_oLogger.log("[-] Account " + sUID + "/" + sPWD + " requires connect as sysdba");
                        this.m_oRes.addAccount(sSID, String.valueOf(sUID) + " AS SYSDBA", sPWD, null, 0);
                        break;
                    }
                    if (nErr == 17002) {
                        this.m_oLogger.log("[x] Sid does not exist");
                        return 0;
                    }
                    if (nErr != 1017) {
                        this.m_oLogger.log("[x] Error: " + nErr + " occured");
                    }
                    oOraDB.close();
                    ++j;
                }
                ++i;
            }
        }
        return 0;
    }

    public String padWithSpaces(int nCount) {
        String s = "";
        int i = 0;
        while (i < nCount) {
            s = String.valueOf(s) + " ";
            ++i;
        }
        return s;
    }

    public void report() {
        String sSID;
        Account oA = null;
        AccountList oAList = this.m_oRes.getAccountList();
        SIDList oSIDList = this.m_oRes.getSIDList();
        Vector oUsers = null;
        String sHeader = null;
        String sBody = "";
        String sTmp = "";
        ReportObject oRo = null;
        while ((sSID = oSIDList.getNextSID()) != null) {
            sHeader = "Accounts";
            oUsers = oAList.getAccountsForSID(sSID);
            if (oUsers == null) continue;
            int i = 0;
            while (i < oUsers.size()) {
                oA = (Account)oUsers.get(i);
                sTmp = oA.getUsername();
                oRo = this.m_oTree.findReportItem(String.valueOf(this.m_sServer) + "/" + sSID + "/Accounts/" + sTmp);
                if (oRo == null) {
                    oRo = new ReportObject(sTmp);
                    this.m_oTree.addReportItem(String.valueOf(this.m_sServer) + "/" + sSID + "/Accounts", oRo);
                }
                oRo.addProperty("Password", oA.getPassword());
                if (oA.getPassword() != null && oA.getPassword().length() > 0) {
                    sTmp = String.valueOf(sTmp) + "/" + oA.getPassword();
                }
                if (oA.getState() == 28000) {
                    sTmp = String.valueOf(sTmp) + this.padWithSpaces(50 - sTmp.length());
                    sBody = String.valueOf(sBody) + sTmp + "[locked]\n";
                    oRo.addProperty("Status", "Locked");
                } else if (oA.getState() == 0) {
                    sTmp = String.valueOf(sTmp) + this.padWithSpaces(50 - sTmp.length());
                    sBody = String.valueOf(sBody) + sTmp + "[open]\n";
                    oRo.addProperty("Status", "Open");
                    if (oA.getUsername().equalsIgnoreCase(oA.getPassword())) {
                        oRo.setSeverity(2002);
                    } else if (oRo.getSeverity() == 2000) {
                        oRo.setSeverity(2001);
                    }
                } else {
                    sBody = String.valueOf(sBody) + sTmp + "\n";
                }
                ++i;
            }
            if (sBody.length() > 0) {
                PluginReport oRep = new PluginReport();
                oRep.setHeader(sHeader);
                oRep.setSID(sSID);
                oRep.setBody(sBody);
                oRep.setHost(this.m_sServer);
                this.m_oRes.getPluginReportList().add(oRep);
            }
            sBody = "";
        }
    }

    /*
     * Unable to fully structure code
     */
    public int scan() {
        oUserList = new UserList();
        oPassList = new PasswordList();
        sUserfile = this.m_oConfig.getConfigOption("UsernameFile");
        sPassfile = this.m_oConfig.getConfigOption("DictionaryFile");
        sSID = null;
        oSIDList = (SIDList)this.m_oRes.getSIDList().clone();
        if (sUserfile == null) {
            this.m_oLogger.log("[x] Failed to get value for userfile");
            return -1;
        }
        if (sPassfile == null) {
            this.m_oLogger.log("[x] Failed to get value for dictionaryfile");
            return -1;
        }
        if (oUserList.loadFromFile(sUserfile) != 0) {
            this.m_oLogger.log("[x] Failed to load userfile (" + sUserfile + ")");
            return -1;
        }
        if (oPassList.loadFromFile(sPassfile) == 0) ** GOTO lbl25
        this.m_oLogger.log("[x] Failed to load dictionary (" + sPassfile + ")");
        return -1;
lbl-1000:
        // 1 sources

        {
            if (sSID.toLowerCase().indexOf("extproc") != -1) continue;
            this.m_oLogger.log("[-] Checking user supplied passwords against sid (" + sSID + ")");
            if (!this.m_oTree.addReportItem(String.valueOf(this.m_sServer) + "/" + sSID, new ReportObject("Accounts"))) {
                this.m_oLogger.log("[x] CheckCommonPasswords addReportItem failed");
            }
            while ((nRet = this.checkAccounts(sSID, oUserList, oPassList)) == 1) {
            }
lbl25:
            // 3 sources

            ** while ((sSID = oSIDList.getNextSID()) != null)
        }
lbl26:
        // 1 sources

        this.report();
        return 0;
    }
}

