/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.io.InputStream;
import java.io.Reader;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.Accessor;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.OracleStatement;
import oracle.sql.BFILE;
import oracle.sql.Datum;

class BfileAccessor
extends Accessor {
    static final int max_length = 530;

    BfileAccessor(OracleStatement oracleStatement, int n, short s, int n2, boolean bl) throws SQLException {
        this.init(oracleStatement, 114, 114, s, bl);
        this.initForDataAccess(n2, n, null);
    }

    BfileAccessor(OracleStatement oracleStatement, int n, boolean bl, int n2, int n3, int n4, int n5, int n6, short s) throws SQLException {
        this.init(oracleStatement, 114, 114, s, false);
        this.initForDescribe(114, n, bl, n2, n3, n4, n5, n6, s, null);
        this.initForDataAccess(0, n, null);
    }

    void initForDataAccess(int n, int n2, String string) throws SQLException {
        if (n != 0) {
            this.external_type = n;
        }
        this.t_max_length = 530;
        if (n2 > 0 && n2 < this.t_max_length) {
            this.t_max_length = n2;
        }
        this.byteLength = this.t_max_length;
    }

    Object getObject(int n) throws SQLException {
        return this.getBFILE(n);
    }

    Object getObject(int n, Map map) throws SQLException {
        return this.getBFILE(n);
    }

    Datum getOracleObject(int n) throws SQLException {
        return this.getBFILE(n);
    }

    BFILE getBFILE(int n) throws SQLException {
        BFILE bFILE = null;
        if (this.rowSpaceIndicator == null) {
            DatabaseError.throwSqlException(21);
        }
        if (this.rowSpaceIndicator[this.indicatorIndex + n] != -1) {
            int n2 = this.columnIndex + this.byteLength * n;
            short s = this.rowSpaceIndicator[this.lengthIndex + n];
            byte[] byArray = new byte[s];
            System.arraycopy(this.rowSpaceByte, n2, byArray, 0, s);
            bFILE = new BFILE(this.stmt.connection, byArray);
        }
        return bFILE;
    }

    InputStream getAsciiStream(int n) throws SQLException {
        BFILE bFILE = this.getBFILE(n);
        if (bFILE == null) {
            return null;
        }
        return bFILE.asciiStreamValue();
    }

    Reader getCharacterStream(int n) throws SQLException {
        BFILE bFILE = this.getBFILE(n);
        if (bFILE == null) {
            return null;
        }
        return bFILE.characterStreamValue();
    }

    InputStream getBinaryStream(int n) throws SQLException {
        BFILE bFILE = this.getBFILE(n);
        if (bFILE == null) {
            return null;
        }
        return bFILE.getBinaryStream();
    }
}

