/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleTimeoutThreadPerVM;

class OracleTimeoutPollingThread
extends Thread {
    protected static final String threadName = "OracleTimeoutPollingThread";
    public static final String pollIntervalProperty = "oracle.jdbc.TimeoutPollInterval";
    public static final String pollIntervalDefault = "1000";
    private OracleTimeoutThreadPerVM[] knownTimeouts;
    private int count;
    private long sleepMillis;
    private static final String _Copyright_2003_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "040121";

    public OracleTimeoutPollingThread() {
        super(threadName);
        this.setDaemon(true);
        this.setPriority(10);
        this.knownTimeouts = new OracleTimeoutThreadPerVM[2];
        this.count = 0;
        this.sleepMillis = Long.parseLong(OracleDriver.getSystemProperty(pollIntervalProperty, pollIntervalDefault));
        this.start();
    }

    public synchronized void addTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        int n = 0;
        if (this.count >= this.knownTimeouts.length) {
            OracleTimeoutThreadPerVM[] oracleTimeoutThreadPerVMArray = new OracleTimeoutThreadPerVM[this.knownTimeouts.length * 4];
            System.arraycopy(this.knownTimeouts, 0, oracleTimeoutThreadPerVMArray, 0, this.knownTimeouts.length);
            n = this.knownTimeouts.length;
            this.knownTimeouts = oracleTimeoutThreadPerVMArray;
        }
        while (n < this.knownTimeouts.length) {
            if (this.knownTimeouts[n] == null) {
                this.knownTimeouts[n] = oracleTimeoutThreadPerVM;
                ++this.count;
                break;
            }
            ++n;
        }
    }

    public synchronized void removeTimeout(OracleTimeoutThreadPerVM oracleTimeoutThreadPerVM) {
        for (int i = 0; i < this.knownTimeouts.length; ++i) {
            if (this.knownTimeouts[i] != oracleTimeoutThreadPerVM) continue;
            this.knownTimeouts[i] = null;
            --this.count;
            break;
        }
    }

    public void run() {
        while (true) {
            try {
                Thread.sleep(this.sleepMillis);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.pollOnce();
        }
    }

    private void pollOnce() {
        if (this.count > 0) {
            long l = System.currentTimeMillis();
            for (int i = 0; i < this.knownTimeouts.length; ++i) {
                try {
                    if (this.knownTimeouts[i] == null) continue;
                    this.knownTimeouts[i].interruptIfAppropriate(l);
                    continue;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
        }
    }
}

