/*
 * Decompiled with CFR 0.152.
 */
package ork;

import java.util.Hashtable;
import java.util.Vector;
import ork.Account;
import ork.AccountList;
import ork.Logger;
import ork.PluginReportList;
import ork.SIDList;

public class ServerResult {
    private String m_sServer = null;
    private int m_nPort = -1;
    private AccountList m_oAccountList = new AccountList();
    private Vector m_oProperty = new Vector();
    private Logger m_oLogger = new Logger();
    private SIDList m_oSIDList = null;
    private PluginReportList m_oPluginReportList = new PluginReportList();

    public ServerResult(String sServer, int nPort) {
        this.m_sServer = sServer;
        this.m_nPort = nPort;
    }

    public String getServer() {
        return this.m_sServer;
    }

    public int getPort() {
        return this.m_nPort;
    }

    public void setSIDList(SIDList o) {
        this.m_oSIDList = o;
    }

    public PluginReportList getPluginReportList() {
        return this.m_oPluginReportList;
    }

    public synchronized SIDList getSIDList() {
        SIDList oList = new SIDList();
        if (this.m_oSIDList == null) {
            System.err.println("[x] SIDs have not been retrieved");
            return oList;
        }
        oList = (SIDList)this.m_oSIDList.clone();
        oList.reset();
        return oList;
    }

    public synchronized void addAccount(String sSID, String sUser, String sPass, String sHash, int nState) {
        if (this.m_sServer == null) {
            System.err.println("[x] addAccount: Missing servername ...");
        }
        this.m_oAccountList.addAccountForSID(sSID, new Account(sUser, sPass, null, nState));
    }

    public AccountList getAccountList() {
        return this.m_oAccountList;
    }

    public synchronized void addProperty(String sName, String sValue) {
        Hashtable<String, String> oProp = new Hashtable<String, String>();
        oProp.put(sName, sValue);
        this.m_oProperty.add(oProp);
    }

    public void outputAsText() {
        Vector oVector = null;
        String sSID = null;
        this.m_oLogger.log("Accounts");
        this.m_oLogger.log("========");
        this.m_oLogger.log("");
        this.m_oSIDList.reset();
        while ((sSID = this.m_oSIDList.getNextSID()) != null) {
            oVector = this.m_oAccountList.getAccountsForSID(sSID);
            if (oVector == null) continue;
            this.m_oLogger.log("SID " + sSID);
            this.m_oLogger.log("===========================================");
            int i = 0;
            while (i < oVector.size()) {
                Account oAcc = (Account)oVector.get(i);
                if (oAcc.getState() != -1) {
                    this.m_oLogger.log(oAcc.getAsString());
                }
                ++i;
            }
        }
        this.m_oLogger.log(this.m_oProperty.toString());
    }
}

