/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.view.swing.features.filepreview;

import java.awt.Dimension;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.JComponent;
import org.freeplane.core.extension.IExtension;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.url.UrlManager;
import org.freeplane.view.swing.features.filepreview.ScalableComponent;
import org.freeplane.view.swing.features.filepreview.ViewerLayoutManager;
import org.freeplane.view.swing.map.NodeView;

public class ExternalResource
implements IExtension {
    private final Set<NodeView> viewers;
    private final URI uri;
    private float zoom = -1.0f;

    public ExternalResource(URI uri) {
        if (uri == null) {
            throw new NullPointerException();
        }
        this.viewers = new LinkedHashSet<NodeView>();
        this.uri = uri;
    }

    void removeViewers() {
        for (NodeView nodeView : this.viewers) {
            nodeView.removeContent(7);
        }
        this.viewers.clear();
    }

    public Set<NodeView> getViewers() {
        return this.viewers;
    }

    public URI getUri() {
        return this.uri;
    }

    public URI getAbsoluteUri(MapModel map) {
        try {
            URI absoluteUri = UrlManager.getAbsoluteUri(map, this.uri);
            return absoluteUri;
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public float getZoom() {
        return this.zoom;
    }

    public void setZoom(float r) {
        this.zoom = r;
        for (NodeView nodeView : this.viewers) {
            JComponent viewer = nodeView.getContent(7);
            ViewerLayoutManager layoutManager = (ViewerLayoutManager)viewer.getLayout();
            if (layoutManager == null) continue;
            Dimension preferredSize = layoutManager.calculatePreferredSize();
            ((ScalableComponent)((Object)viewer)).setFinalViewerSize(preferredSize);
            viewer.revalidate();
            viewer.repaint();
        }
    }

    public float setZoom(int originalWidth, int maximumWidth) {
        float zoom;
        if (originalWidth <= maximumWidth) {
            float zoomedWidth = originalWidth;
            zoom = 1.0f;
        } else {
            float zoomedWidth = maximumWidth;
            zoom = zoomedWidth / (float)originalWidth;
        }
        this.setZoom(zoom);
        return zoom;
    }
}

