/*
 * Decompiled with CFR 0.152.
 */
package com.jogamp.common.nio;

import com.jogamp.common.nio.Buffers;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;

public class CachedBufferFactory {
    public static final int DEFAULT_ALLOCATION_SIZE = 0x100000;
    private final int ALLOCATION_SIZE;
    private ByteBuffer currentBuffer;

    private CachedBufferFactory() {
        this(0x100000, 0x100000);
    }

    private CachedBufferFactory(int n, int n2) {
        this.currentBuffer = Buffers.newDirectByteBuffer(n);
        this.ALLOCATION_SIZE = n2;
    }

    public static CachedBufferFactory create() {
        return new CachedBufferFactory();
    }

    public static CachedBufferFactory create(int n) {
        return new CachedBufferFactory(n, 0x100000);
    }

    public static CachedBufferFactory create(int n, boolean bl) {
        return new CachedBufferFactory(n, bl ? -1 : 0x100000);
    }

    public static CachedBufferFactory create(int n, int n2) {
        return new CachedBufferFactory(n, n2);
    }

    public static CachedBufferFactory createSynchronized() {
        return new SynchronizedCachedBufferFactory();
    }

    public static CachedBufferFactory createSynchronized(int n) {
        return new SynchronizedCachedBufferFactory(n, 0x100000);
    }

    public static CachedBufferFactory createSynchronized(int n, boolean bl) {
        return new SynchronizedCachedBufferFactory(n, bl ? -1 : 0x100000);
    }

    public static CachedBufferFactory createSynchronized(int n, int n2) {
        return new CachedBufferFactory(n, n2);
    }

    public boolean isFixed() {
        return this.ALLOCATION_SIZE == -1;
    }

    public int getAllocationSize() {
        return this.ALLOCATION_SIZE;
    }

    private void checkIfFixed() {
        if (this.ALLOCATION_SIZE == 0) {
            throw new RuntimeException("fixed size buffer factory ran out ouf bounds.");
        }
    }

    public void destroy() {
        if (null != this.currentBuffer) {
            this.currentBuffer.clear();
            this.currentBuffer = null;
        }
    }

    public ByteBuffer newDirectByteBuffer(int n) {
        if (n > this.currentBuffer.capacity()) {
            this.checkIfFixed();
            return Buffers.newDirectByteBuffer(n);
        }
        if (n > this.currentBuffer.remaining()) {
            this.checkIfFixed();
            this.currentBuffer = Buffers.newDirectByteBuffer(this.ALLOCATION_SIZE);
        }
        this.currentBuffer.limit(this.currentBuffer.position() + n);
        ByteBuffer byteBuffer = this.currentBuffer.slice().order(this.currentBuffer.order());
        this.currentBuffer.position(this.currentBuffer.limit());
        this.currentBuffer.limit(this.currentBuffer.capacity());
        return byteBuffer;
    }

    public ByteBuffer newDirectByteBuffer(byte[] byArray, int n, int n2) {
        return (ByteBuffer)this.newDirectByteBuffer(n2).put(byArray, n, n2).rewind();
    }

    public ByteBuffer newDirectByteBuffer(byte[] byArray, int n) {
        return this.newDirectByteBuffer(byArray, n, byArray.length - n);
    }

    public ByteBuffer newDirectByteBuffer(byte[] byArray) {
        return this.newDirectByteBuffer(byArray, 0);
    }

    public DoubleBuffer newDirectDoubleBuffer(int n) {
        return this.newDirectByteBuffer(n * 8).asDoubleBuffer();
    }

    public DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n, int n2) {
        return (DoubleBuffer)this.newDirectDoubleBuffer(n2).put(dArray, n, n2).rewind();
    }

    public DoubleBuffer newDirectDoubleBuffer(double[] dArray, int n) {
        return this.newDirectDoubleBuffer(dArray, n, dArray.length - n);
    }

    public DoubleBuffer newDirectDoubleBuffer(double[] dArray) {
        return this.newDirectDoubleBuffer(dArray, 0);
    }

    public FloatBuffer newDirectFloatBuffer(int n) {
        return this.newDirectByteBuffer(n * 4).asFloatBuffer();
    }

    public FloatBuffer newDirectFloatBuffer(float[] fArray, int n, int n2) {
        return (FloatBuffer)this.newDirectFloatBuffer(n2).put(fArray, n, n2).rewind();
    }

    public FloatBuffer newDirectFloatBuffer(float[] fArray, int n) {
        return this.newDirectFloatBuffer(fArray, n, fArray.length - n);
    }

    public FloatBuffer newDirectFloatBuffer(float[] fArray) {
        return this.newDirectFloatBuffer(fArray, 0);
    }

    public IntBuffer newDirectIntBuffer(int n) {
        return this.newDirectByteBuffer(n * 4).asIntBuffer();
    }

    public IntBuffer newDirectIntBuffer(int[] nArray, int n, int n2) {
        return (IntBuffer)this.newDirectIntBuffer(n2).put(nArray, n, n2).rewind();
    }

    public IntBuffer newDirectIntBuffer(int[] nArray, int n) {
        return this.newDirectIntBuffer(nArray, n, nArray.length - n);
    }

    public IntBuffer newDirectIntBuffer(int[] nArray) {
        return this.newDirectIntBuffer(nArray, 0);
    }

    public LongBuffer newDirectLongBuffer(int n) {
        return this.newDirectByteBuffer(n * 8).asLongBuffer();
    }

    public LongBuffer newDirectLongBuffer(long[] lArray, int n, int n2) {
        return (LongBuffer)this.newDirectLongBuffer(n2).put(lArray, n, n2).rewind();
    }

    public LongBuffer newDirectLongBuffer(long[] lArray, int n) {
        return this.newDirectLongBuffer(lArray, n, lArray.length - n);
    }

    public LongBuffer newDirectLongBuffer(long[] lArray) {
        return this.newDirectLongBuffer(lArray, 0);
    }

    public ShortBuffer newDirectShortBuffer(int n) {
        return this.newDirectByteBuffer(n * 2).asShortBuffer();
    }

    public ShortBuffer newDirectShortBuffer(short[] sArray, int n, int n2) {
        return (ShortBuffer)this.newDirectShortBuffer(n2).put(sArray, n, n2).rewind();
    }

    public ShortBuffer newDirectShortBuffer(short[] sArray, int n) {
        return this.newDirectShortBuffer(sArray, n, sArray.length - n);
    }

    public ShortBuffer newDirectShortBuffer(short[] sArray) {
        return this.newDirectShortBuffer(sArray, 0);
    }

    public CharBuffer newDirectCharBuffer(int n) {
        return this.newDirectByteBuffer(n * 2).asCharBuffer();
    }

    public CharBuffer newDirectCharBuffer(char[] cArray, int n, int n2) {
        return (CharBuffer)this.newDirectCharBuffer(n2).put(cArray, n, n2).rewind();
    }

    public CharBuffer newDirectCharBuffer(char[] cArray, int n) {
        return this.newDirectCharBuffer(cArray, n, cArray.length - n);
    }

    public CharBuffer newDirectCharBuffer(char[] cArray) {
        return this.newDirectCharBuffer(cArray, 0);
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        CachedBufferFactory cachedBufferFactory = (CachedBufferFactory)object;
        if (this.ALLOCATION_SIZE != cachedBufferFactory.ALLOCATION_SIZE) {
            return false;
        }
        return this.currentBuffer == cachedBufferFactory.currentBuffer || this.currentBuffer != null && this.currentBuffer.equals(cachedBufferFactory.currentBuffer);
    }

    public String toString() {
        return this.getClass().getName() + "[static:" + this.isFixed() + " alloc size:" + this.getAllocationSize() + "]";
    }

    private static class SynchronizedCachedBufferFactory
    extends CachedBufferFactory {
        private SynchronizedCachedBufferFactory() {
        }

        private SynchronizedCachedBufferFactory(int n, int n2) {
            super(n, n2);
        }

        @Override
        public synchronized ByteBuffer newDirectByteBuffer(int n) {
            return super.newDirectByteBuffer(n);
        }
    }
}

