/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Objects;
import java.util.Optional;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.osm.DataSet;
import org.openstreetmap.josm.data.osm.INode;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.gui.mappaint.MapPaintStyles;
import org.openstreetmap.josm.gui.mappaint.Range;
import org.openstreetmap.josm.gui.mappaint.StyleElementList;
import org.openstreetmap.josm.gui.mappaint.styleelement.MapImage;
import org.openstreetmap.josm.gui.mappaint.styleelement.NodeElement;
import org.openstreetmap.josm.gui.mappaint.styleelement.StyleElement;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPreset;
import org.openstreetmap.josm.gui.tagging.presets.TaggingPresets;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.ImageResource;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Pair;
import org.openstreetmap.josm.tools.Utils;

public final class OsmPrimitiveImageProvider {
    private OsmPrimitiveImageProvider() {
    }

    public static ImageResource getResource(OsmPrimitive primitive, Collection<Options> options) {
        Object icon;
        if (primitive.isTagged() && (icon = OsmPrimitiveImageProvider.getResourceFromMapPaintStyles(primitive, options)) != null) {
            return icon;
        }
        if (primitive.isTagged() && (!options.contains((Object)Options.NO_WAY_PRESETS) || OsmPrimitiveType.WAY != primitive.getType()) && ((Optional)(icon = TaggingPresets.getMatchingPresets(primitive).stream().sorted(Comparator.comparing(p -> p.iconName != null && p.iconName.contains("multipolygon") || Utils.isEmpty(p.types) ? Integer.MAX_VALUE : p.types.size())).map(TaggingPreset::getImageResource).filter(Objects::nonNull).findFirst())).isPresent()) {
            return (ImageResource)((Optional)icon).get();
        }
        return options.contains((Object)Options.NO_DEFAULT) ? null : new ImageProvider("data", primitive.getDisplayType().getAPIName()).getResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ImageResource getResourceFromMapPaintStyles(OsmPrimitive primitive, Collection<Options> options) {
        Pair<StyleElementList, Range> nodeStyles;
        DataSet ds = primitive.getDataSet();
        if (ds != null) {
            ds.getReadLock().lock();
        }
        try {
            nodeStyles = MapPaintStyles.getStyles().generateStyles(primitive, 100.0, false);
        }
        finally {
            if (ds != null) {
                ds.getReadLock().unlock();
            }
        }
        for (StyleElement style : (StyleElementList)nodeStyles.a) {
            if (!(style instanceof NodeElement)) continue;
            NodeElement nodeStyle = (NodeElement)style;
            MapImage icon = nodeStyle.mapImage;
            if (icon == null || icon.getImageResource() == null || icon.name != null && options.contains((Object)Options.NO_DEPRECATED) && icon.name.contains("deprecated")) continue;
            return icon.getImageResource();
        }
        return null;
    }

    public static Optional<ImageResource> getResource(String key, String value, OsmPrimitiveType primitiveType) {
        OsmPrimitive virtual = primitiveType.newInstance(0L, false);
        if (virtual instanceof INode) {
            ((INode)((Object)virtual)).setCoor(LatLon.ZERO);
        }
        virtual.put(key, value);
        try {
            ImageResource padded = OsmPrimitiveImageProvider.getResource(virtual, EnumSet.of(Options.NO_DEFAULT, Options.NO_DEPRECATED));
            return Optional.ofNullable(padded);
        }
        catch (Exception e) {
            Logging.warn("Failed to find icon for {0} {1}={2}", new Object[]{virtual.getType(), key, value});
            Logging.warn(e);
            return Optional.empty();
        }
    }

    public static enum Options {
        NO_DEPRECATED,
        NO_DEFAULT,
        NO_PRESETS,
        NO_WAY_PRESETS;

        static final Collection<Options> DEFAULT;

        static {
            DEFAULT = Collections.singleton(NO_WAY_PRESETS);
        }
    }
}

