/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.metamodel.mapping.Bindable;
import org.hibernate.sql.ast.tree.select.SelectStatement;
import org.hibernate.sql.exec.internal.JdbcParameterBindingsImpl;
import org.hibernate.sql.exec.spi.ExecutionContext;
import org.hibernate.sql.exec.spi.JdbcOperationQuerySelect;
import org.hibernate.sql.exec.spi.JdbcParameterBindings;
import org.hibernate.sql.exec.spi.JdbcParametersList;
import org.hibernate.sql.results.internal.RowTransformerStandardImpl;
import org.hibernate.sql.results.spi.ManagedResultConsumer;

public class MultiKeyLoadChunker<K> {
    private final int chunkSize;
    private final int keyColumnCount;
    private final Bindable bindable;
    private final JdbcParametersList jdbcParameters;
    private final SelectStatement sqlAst;
    private final JdbcOperationQuerySelect jdbcSelect;

    public MultiKeyLoadChunker(int chunkSize, int keyColumnCount, Bindable bindable, JdbcParametersList jdbcParameters, SelectStatement sqlAst, JdbcOperationQuerySelect jdbcSelect) {
        this.chunkSize = chunkSize;
        this.keyColumnCount = keyColumnCount;
        this.bindable = bindable;
        this.jdbcParameters = jdbcParameters;
        this.sqlAst = sqlAst;
        this.jdbcSelect = jdbcSelect;
    }

    public void processChunks(K[] keys, int nonNullElementCount, SqlExecutionContextCreator sqlExecutionContextCreator, KeyCollector<K> keyCollector, ChunkStartListener startListener, ChunkBoundaryListener boundaryListener, SharedSessionContractImplementor session) {
        int start = 0;
        for (int numberOfKeysLeft = nonNullElementCount; numberOfKeysLeft > 0; numberOfKeysLeft -= this.chunkSize) {
            this.processChunk(keys, start, sqlExecutionContextCreator, keyCollector, startListener, boundaryListener, session);
            start += this.chunkSize;
        }
    }

    private void processChunk(K[] keys, int startIndex, SqlExecutionContextCreator sqlExecutionContextCreator, KeyCollector<K> keyCollector, ChunkStartListener startListener, ChunkBoundaryListener boundaryListener, SharedSessionContractImplementor session) {
        startListener.chunkStartNotification(startIndex);
        int parameterCount = this.chunkSize * this.keyColumnCount;
        JdbcParameterBindingsImpl jdbcParameterBindings = new JdbcParameterBindingsImpl(parameterCount);
        int nonNullCounter = 0;
        int bindCount = 0;
        for (int i = 0; i < this.chunkSize; ++i) {
            int keyPosition = i + startIndex;
            Object value = keyPosition >= keys.length ? null : (Object)keys[keyPosition];
            keyCollector.collect(value, i, keyPosition);
            if (value != null) {
                ++nonNullCounter;
            }
            bindCount += jdbcParameterBindings.registerParametersForEachJdbcValue(value, bindCount, this.bindable, this.jdbcParameters, session);
        }
        assert (bindCount == this.jdbcParameters.size());
        if (nonNullCounter == 0) {
            return;
        }
        session.getFactory().getJdbcServices().getJdbcSelectExecutor().executeQuery(this.jdbcSelect, (JdbcParameterBindings)jdbcParameterBindings, sqlExecutionContextCreator.createContext(jdbcParameterBindings, session), RowTransformerStandardImpl.instance(), null, nonNullCounter, ManagedResultConsumer.INSTANCE);
        boundaryListener.chunkBoundaryNotification(startIndex, nonNullCounter);
    }

    @FunctionalInterface
    static interface SqlExecutionContextCreator {
        public ExecutionContext createContext(JdbcParameterBindings var1, SharedSessionContractImplementor var2);
    }

    @FunctionalInterface
    static interface KeyCollector<K> {
        public void collect(K var1, int var2, int var3);
    }

    @FunctionalInterface
    static interface ChunkStartListener {
        public void chunkStartNotification(int var1);
    }

    @FunctionalInterface
    static interface ChunkBoundaryListener {
        public void chunkBoundaryNotification(int var1, int var2);
    }
}

