/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline;

import com.microsoft.windowsazure.core.utils.AccessConditionHeader;
import com.microsoft.windowsazure.core.utils.AccessConditionHeaderType;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class PipelineHelpers {
    private PipelineHelpers() {
    }

    private static String createErrorMessage(ClientResponse clientResponse) {
        clientResponse.bufferEntity();
        String errorMessage = clientResponse.toString();
        if (clientResponse.hasEntity()) {
            errorMessage = errorMessage + " " + (String)clientResponse.getEntity(String.class);
        }
        return errorMessage;
    }

    public static void throwIfNotSuccess(ClientResponse clientResponse) {
        int statusCode = clientResponse.getStatus();
        if (statusCode < 200 || statusCode >= 300) {
            String errorMessage = PipelineHelpers.createErrorMessage(clientResponse);
            throw new UniformInterfaceException(errorMessage, clientResponse);
        }
    }

    public static void throwIfError(ClientResponse clientResponse) {
        if (clientResponse.getStatus() >= 400) {
            String errorMessage = PipelineHelpers.createErrorMessage(clientResponse);
            throw new UniformInterfaceException(errorMessage, clientResponse);
        }
    }

    public static WebResource addOptionalQueryParam(WebResource webResource, String key, Object value) {
        if (value != null) {
            webResource = webResource.queryParam(key, value.toString());
        }
        return webResource;
    }

    public static WebResource addOptionalQueryParam(WebResource webResource, String key, int value, int defaultValue) {
        if (value != defaultValue) {
            webResource = webResource.queryParam(key, Integer.toString(value));
        }
        return webResource;
    }

    public static WebResource.Builder addOptionalHeader(WebResource.Builder builder, String name, Object value) {
        if (value != null) {
            builder = (WebResource.Builder)builder.header(name, value);
        }
        return builder;
    }

    public static WebResource.Builder addOptionalMetadataHeader(WebResource.Builder builder, Map<String, String> metadata) {
        for (Map.Entry<String, String> entry : metadata.entrySet()) {
            builder = (WebResource.Builder)builder.header("x-ms-meta-" + entry.getKey(), (Object)entry.getValue());
        }
        return builder;
    }

    public static WebResource.Builder addOptionalRangeHeader(WebResource.Builder builder, Long rangeStart, Long rangeEnd) {
        if (rangeStart != null) {
            String range = rangeStart.toString() + "-";
            if (rangeEnd != null) {
                range = range + rangeEnd.toString();
            }
            builder = PipelineHelpers.addOptionalHeader(builder, "Range", "bytes=" + range);
        }
        return builder;
    }

    public static WebResource.Builder addOptionalAccessConditionHeader(WebResource.Builder builder, AccessConditionHeader accessCondition) {
        if (accessCondition != null && accessCondition.getHeader() != AccessConditionHeaderType.NONE) {
            builder = PipelineHelpers.addOptionalHeader(builder, accessCondition.getHeader().toString(), accessCondition.getValue());
        }
        return builder;
    }

    public static WebResource.Builder addOptionalSourceAccessConditionHeader(WebResource.Builder builder, AccessConditionHeader accessCondition) {
        if (accessCondition != null && accessCondition.getHeader() != AccessConditionHeaderType.NONE) {
            String headerName;
            switch (accessCondition.getHeader()) {
                case IF_MATCH: {
                    headerName = "x-ms-source-if-match";
                    break;
                }
                case IF_UNMODIFIED_SINCE: {
                    headerName = "x-ms-source-if-unmodified-since";
                    break;
                }
                case IF_MODIFIED_SINCE: {
                    headerName = "x-ms-source-if-modified-since";
                    break;
                }
                case IF_NONE_MATCH: {
                    headerName = "x-ms-source-if-none-match";
                    break;
                }
                default: {
                    headerName = "";
                }
            }
            builder = PipelineHelpers.addOptionalHeader(builder, headerName, accessCondition.getValue());
        }
        return builder;
    }

    public static HashMap<String, String> getMetadataFromHeaders(ClientResponse response) {
        HashMap<String, String> metadata = new HashMap<String, String>();
        for (Map.Entry entry : response.getHeaders().entrySet()) {
            if (!((String)entry.getKey()).startsWith("x-ms-meta-")) continue;
            String name = ((String)entry.getKey()).substring("x-ms-meta-".length());
            String value = (String)((List)entry.getValue()).get(0);
            metadata.put(name, value);
        }
        return metadata;
    }
}

