/*
 * Decompiled with CFR 0.152.
 */
package io.jsonwebtoken.impl.lang;

import io.jsonwebtoken.impl.lang.Converter;
import io.jsonwebtoken.lang.Assert;

public class EncodedObjectConverter<T>
implements Converter<T, Object> {
    private final Class<T> type;
    private final Converter<T, ? super CharSequence> converter;

    public EncodedObjectConverter(Class<T> type, Converter<T, ? super CharSequence> converter) {
        this.type = (Class)Assert.notNull(type, (String)"Value type cannot be null.");
        this.converter = (Converter)Assert.notNull(converter, (String)"Value converter cannot be null.");
    }

    @Override
    public Object applyTo(T t) {
        Assert.notNull(t, (String)"Value argument cannot be null.");
        return this.converter.applyTo(t);
    }

    @Override
    public T applyFrom(Object value) {
        Assert.notNull((Object)value, (String)"Value argument cannot be null.");
        if (this.type.isInstance(value)) {
            return this.type.cast(value);
        }
        if (value instanceof CharSequence) {
            return this.converter.applyFrom((CharSequence)value);
        }
        String msg = "Values must be either String or " + this.type.getName() + " instances. Value type found: " + value.getClass().getName() + ".";
        throw new IllegalArgumentException(msg);
    }
}

