# Security Policy

## Report a Vulnerability

If you have information about a security issue or vulnerability with an **Intel branded product or technology**, please send an e-mail to [secure@intel.com](mailto:secure@intel.com). Encrypt sensitive information using our [PGP public key](https://www.intel.com/content/www/us/en/security-center/pgp-public-key.html).

Please provide as much information as possible, including:

- The products and versions affected
- Detailed description of the vulnerability
- Information on known exploits

A member of the Intel Product Security Team will review your e-mail and contact you to collaborate on resolving the issue. For more information on how Intel works to resolve security issues, see:

- [Vulnerability handling guidelines](https://www.intel.com/content/www/us/en/security-center/vulnerability-handling-guidelines.html)

For issues related to Intel's external web presence (Intel.com and related subdomains), please contact [Intel's External Security Research team](mailto:external.security.research@intel.com).

## Intel's Bug Bounty Program

Intel Corporation believes that working with skilled security researchers across the globe is a crucial part of identifying and mitigating security vulnerabilities in Intel products.

Like other major technology companies, Intel incentivizes security researchers to report security vulnerabilities in Intel products to us to enable a coordinated response. To encourage closer collaboration with the security research community on these kinds of issues, Intel created its Bug Bounty Program.

If you believe you've found a security vulnerability in an Intel product or technology, we encourage you to notify us through our program and work with us to mitigate and to coordinate disclosure of the vulnerability.

[Read full details.](https://www.intel.com/content/www/us/en/security-center/bug-bounty-program.html)

## Need product support?

The [secure@intel.com](mailto:secure@intel.com) e-mail address should only be used for reporting security issues.

If you...

- Have questions about the security features of an Intel product
- Require technical support
- Want product updates or patches

Please visit [Support & Downloads](https://www.intel.com/content/www/us/en/support.html).
