; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefix=CHECK-P10-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr10 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefix=CHECK-P10-BE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr9 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P9
; RUN: llc -verify-machineinstrs -mtriple=powerpc64le-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P8,CHECK-P8-LE
; RUN: llc -verify-machineinstrs -mtriple=powerpc64-unknown-linux-gnu \
; RUN:   -mcpu=pwr8 -ppc-asm-full-reg-names -ppc-vsr-nums-as-vr \
; RUN:   < %s | FileCheck %s --check-prefixes=CHECK,CHECK-P8,CHECK-P8-BE

@GlobLd1 = dso_local local_unnamed_addr global [20 x i8] zeroinitializer, align 1
@GlobSt1 = dso_local local_unnamed_addr global [20 x i8] zeroinitializer, align 1
@GlobLd2 = dso_local local_unnamed_addr global [20 x i8] zeroinitializer, align 1
@GlobSt2 = dso_local local_unnamed_addr global [20 x i8] zeroinitializer, align 1
@GlobLd3 = dso_local local_unnamed_addr global [20 x i16] zeroinitializer, align 2
@GlobSt3 = dso_local local_unnamed_addr global [20 x i16] zeroinitializer, align 2
@GlobLd4 = dso_local local_unnamed_addr global [20 x i16] zeroinitializer, align 2
@GlobSt4 = dso_local local_unnamed_addr global [20 x i16] zeroinitializer, align 2
@GlobLd5 = dso_local local_unnamed_addr global [20 x i32] zeroinitializer, align 4
@GlobSt5 = dso_local local_unnamed_addr global [20 x i32] zeroinitializer, align 4
@GlobLd6 = dso_local local_unnamed_addr global [20 x i32] zeroinitializer, align 4
@GlobSt6 = dso_local local_unnamed_addr global [20 x i32] zeroinitializer, align 4
@GlobLd7 = dso_local local_unnamed_addr global [20 x i64] zeroinitializer, align 8
@GlobSt7 = dso_local local_unnamed_addr global [20 x i64] zeroinitializer, align 8
@GlobLd8 = dso_local local_unnamed_addr global [20 x i64] zeroinitializer, align 8
@GlobSt8 = dso_local local_unnamed_addr global [20 x i64] zeroinitializer, align 8
@GlobLd9 = dso_local local_unnamed_addr global [20 x float] zeroinitializer, align 4
@GlobSt9 = dso_local local_unnamed_addr global [20 x float] zeroinitializer, align 4
@GlobLd10 = dso_local local_unnamed_addr global [20 x double] zeroinitializer, align 8
@GlobSt10 = dso_local local_unnamed_addr global [20 x double] zeroinitializer, align 8
@GlobLd11 = dso_local local_unnamed_addr global [20 x <16 x i8>] zeroinitializer, align 16
@GlobSt11 = dso_local local_unnamed_addr global [20 x <16 x i8>] zeroinitializer, align 16
@GlobLd12 = dso_local local_unnamed_addr global [20 x <16 x i8>] zeroinitializer, align 16
@GlobSt12 = dso_local local_unnamed_addr global [20 x <16 x i8>] zeroinitializer, align 16

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob1PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob1PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, GlobLd1@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstb r3, GlobSt1@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob1PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd1@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt1@toc@ha
; CHECK-P10-BE-NEXT:    lbz r3, GlobLd1@toc@l(r3)
; CHECK-P10-BE-NEXT:    stb r3, GlobSt1@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob1PtrPlus0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd1@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt1@toc@ha
; CHECK-NEXT:    lbz r3, GlobLd1@toc@l(r3)
; CHECK-NEXT:    stb r3, GlobSt1@toc@l(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobLd1, i64 0, i64 0), align 1
  store i8 %0, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobSt1, i64 0, i64 0), align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob1PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob1PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, GlobLd1@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstb r3, GlobSt1@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob1PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd1@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt1@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd1@toc@l
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobSt1@toc@l
; CHECK-P10-BE-NEXT:    lbz r3, 3(r3)
; CHECK-P10-BE-NEXT:    stb r3, 3(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob1PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd1@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt1@toc@ha
; CHECK-NEXT:    addi r3, r3, GlobLd1@toc@l
; CHECK-NEXT:    addi r4, r4, GlobSt1@toc@l
; CHECK-NEXT:    lbz r3, 3(r3)
; CHECK-NEXT:    stb r3, 3(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobLd1, i64 0, i64 3), align 1
  store i8 %0, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobSt1, i64 0, i64 3), align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob1PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob1PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, GlobLd1@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstb r3, GlobSt1@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob1PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd1@toc@ha+4
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt1@toc@ha+4
; CHECK-P10-BE-NEXT:    lbz r3, GlobLd1@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    stb r3, GlobSt1@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob1PtrPlus4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd1@toc@ha+4
; CHECK-NEXT:    addis r4, r2, GlobSt1@toc@ha+4
; CHECK-NEXT:    lbz r3, GlobLd1@toc@l+4(r3)
; CHECK-NEXT:    stb r3, GlobSt1@toc@l+4(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobLd1, i64 0, i64 4), align 1
  store i8 %0, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobSt1, i64 0, i64 4), align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob1PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob1PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, GlobLd1@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstb r3, GlobSt1@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob1PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd1@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt1@toc@ha+16
; CHECK-P10-BE-NEXT:    lbz r3, GlobLd1@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    stb r3, GlobSt1@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob1PtrPlus16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd1@toc@ha+16
; CHECK-NEXT:    addis r4, r2, GlobSt1@toc@ha+16
; CHECK-NEXT:    lbz r3, GlobLd1@toc@l+16(r3)
; CHECK-NEXT:    stb r3, GlobSt1@toc@l+16(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobLd1, i64 0, i64 16), align 1
  store i8 %0, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobSt1, i64 0, i64 16), align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob1PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob1PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd1@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt1@PCREL, 1
; CHECK-P10-LE-NEXT:    lbzx r4, r4, r3
; CHECK-P10-LE-NEXT:    stbx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob1PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd1@toc@ha
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt1@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd1@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt1@toc@l
; CHECK-P10-BE-NEXT:    lbzx r4, r4, r3
; CHECK-P10-BE-NEXT:    stbx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob1PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd1@toc@ha
; CHECK-NEXT:    addis r5, r2, GlobSt1@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd1@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt1@toc@l
; CHECK-NEXT:    lbzx r4, r4, r3
; CHECK-NEXT:    stbx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x i8], [20 x i8]* @GlobLd1, i64 0, i64 %Idx
  %0 = load i8, i8* %arrayidx, align 1
  %arrayidx1 = getelementptr inbounds [20 x i8], [20 x i8]* @GlobSt1, i64 0, i64 %Idx
  store i8 %0, i8* %arrayidx1, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob2PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob2PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, GlobLd2@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstb r3, GlobSt2@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob2PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd2@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt2@toc@ha
; CHECK-P10-BE-NEXT:    lbz r3, GlobLd2@toc@l(r3)
; CHECK-P10-BE-NEXT:    stb r3, GlobSt2@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob2PtrPlus0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd2@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt2@toc@ha
; CHECK-NEXT:    lbz r3, GlobLd2@toc@l(r3)
; CHECK-NEXT:    stb r3, GlobSt2@toc@l(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobLd2, i64 0, i64 0), align 1
  store i8 %0, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobSt2, i64 0, i64 0), align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob2PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob2PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, GlobLd2@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstb r3, GlobSt2@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob2PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd2@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt2@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd2@toc@l
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobSt2@toc@l
; CHECK-P10-BE-NEXT:    lbz r3, 3(r3)
; CHECK-P10-BE-NEXT:    stb r3, 3(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob2PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd2@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt2@toc@ha
; CHECK-NEXT:    addi r3, r3, GlobLd2@toc@l
; CHECK-NEXT:    addi r4, r4, GlobSt2@toc@l
; CHECK-NEXT:    lbz r3, 3(r3)
; CHECK-NEXT:    stb r3, 3(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobLd2, i64 0, i64 3), align 1
  store i8 %0, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobSt2, i64 0, i64 3), align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob2PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob2PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, GlobLd2@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstb r3, GlobSt2@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob2PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd2@toc@ha+4
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt2@toc@ha+4
; CHECK-P10-BE-NEXT:    lbz r3, GlobLd2@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    stb r3, GlobSt2@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob2PtrPlus4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd2@toc@ha+4
; CHECK-NEXT:    addis r4, r2, GlobSt2@toc@ha+4
; CHECK-NEXT:    lbz r3, GlobLd2@toc@l+4(r3)
; CHECK-NEXT:    stb r3, GlobSt2@toc@l+4(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobLd2, i64 0, i64 4), align 1
  store i8 %0, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobSt2, i64 0, i64 4), align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob2PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob2PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plbz r3, GlobLd2@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstb r3, GlobSt2@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob2PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd2@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt2@toc@ha+16
; CHECK-P10-BE-NEXT:    lbz r3, GlobLd2@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    stb r3, GlobSt2@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob2PtrPlus16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd2@toc@ha+16
; CHECK-NEXT:    addis r4, r2, GlobSt2@toc@ha+16
; CHECK-NEXT:    lbz r3, GlobLd2@toc@l+16(r3)
; CHECK-NEXT:    stb r3, GlobSt2@toc@l+16(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i8, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobLd2, i64 0, i64 16), align 1
  store i8 %0, i8* getelementptr inbounds ([20 x i8], [20 x i8]* @GlobSt2, i64 0, i64 16), align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob2PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob2PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd2@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt2@PCREL, 1
; CHECK-P10-LE-NEXT:    lbzx r4, r4, r3
; CHECK-P10-LE-NEXT:    stbx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob2PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd2@toc@ha
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt2@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd2@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt2@toc@l
; CHECK-P10-BE-NEXT:    lbzx r4, r4, r3
; CHECK-P10-BE-NEXT:    stbx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob2PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd2@toc@ha
; CHECK-NEXT:    addis r5, r2, GlobSt2@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd2@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt2@toc@l
; CHECK-NEXT:    lbzx r4, r4, r3
; CHECK-NEXT:    stbx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x i8], [20 x i8]* @GlobLd2, i64 0, i64 %Idx
  %0 = load i8, i8* %arrayidx, align 1
  %arrayidx1 = getelementptr inbounds [20 x i8], [20 x i8]* @GlobSt2, i64 0, i64 %Idx
  store i8 %0, i8* %arrayidx1, align 1
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob3PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob3PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plhz r3, GlobLd3@PCREL(0), 1
; CHECK-P10-LE-NEXT:    psth r3, GlobSt3@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob3PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd3@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt3@toc@ha
; CHECK-P10-BE-NEXT:    lhz r3, GlobLd3@toc@l(r3)
; CHECK-P10-BE-NEXT:    sth r3, GlobSt3@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob3PtrPlus0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd3@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt3@toc@ha
; CHECK-NEXT:    lhz r3, GlobLd3@toc@l(r3)
; CHECK-NEXT:    sth r3, GlobSt3@toc@l(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobLd3, i64 0, i64 0), align 2
  store i16 %0, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobSt3, i64 0, i64 0), align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob3PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob3PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plhz r3, GlobLd3@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    psth r3, GlobSt3@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob3PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd3@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt3@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd3@toc@l
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobSt3@toc@l
; CHECK-P10-BE-NEXT:    lhz r3, 3(r3)
; CHECK-P10-BE-NEXT:    sth r3, 3(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob3PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd3@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt3@toc@ha
; CHECK-NEXT:    addi r3, r3, GlobLd3@toc@l
; CHECK-NEXT:    addi r4, r4, GlobSt3@toc@l
; CHECK-NEXT:    lhz r3, 3(r3)
; CHECK-NEXT:    sth r3, 3(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, i16* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i16]* @GlobLd3 to i8*), i64 3) to i16*), align 2
  store i16 %0, i16* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i16]* @GlobSt3 to i8*), i64 3) to i16*), align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob3PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob3PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plhz r3, GlobLd3@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    psth r3, GlobSt3@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob3PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd3@toc@ha+4
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt3@toc@ha+4
; CHECK-P10-BE-NEXT:    lhz r3, GlobLd3@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    sth r3, GlobSt3@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob3PtrPlus4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd3@toc@ha+4
; CHECK-NEXT:    addis r4, r2, GlobSt3@toc@ha+4
; CHECK-NEXT:    lhz r3, GlobLd3@toc@l+4(r3)
; CHECK-NEXT:    sth r3, GlobSt3@toc@l+4(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobLd3, i64 0, i64 2), align 2
  store i16 %0, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobSt3, i64 0, i64 2), align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob3PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob3PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plhz r3, GlobLd3@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    psth r3, GlobSt3@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob3PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd3@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt3@toc@ha+16
; CHECK-P10-BE-NEXT:    lhz r3, GlobLd3@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    sth r3, GlobSt3@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob3PtrPlus16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd3@toc@ha+16
; CHECK-NEXT:    addis r4, r2, GlobSt3@toc@ha+16
; CHECK-NEXT:    lhz r3, GlobLd3@toc@l+16(r3)
; CHECK-NEXT:    sth r3, GlobSt3@toc@l+16(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobLd3, i64 0, i64 8), align 2
  store i16 %0, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobSt3, i64 0, i64 8), align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob3PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob3PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 1
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd3@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt3@PCREL, 1
; CHECK-P10-LE-NEXT:    lhzx r4, r4, r3
; CHECK-P10-LE-NEXT:    sthx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob3PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd3@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 1
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt3@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd3@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt3@toc@l
; CHECK-P10-BE-NEXT:    lhzx r4, r4, r3
; CHECK-P10-BE-NEXT:    sthx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob3PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd3@toc@ha
; CHECK-NEXT:    sldi r3, r3, 1
; CHECK-NEXT:    addis r5, r2, GlobSt3@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd3@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt3@toc@l
; CHECK-NEXT:    lhzx r4, r4, r3
; CHECK-NEXT:    sthx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x i16], [20 x i16]* @GlobLd3, i64 0, i64 %Idx
  %0 = load i16, i16* %arrayidx, align 2
  %arrayidx1 = getelementptr inbounds [20 x i16], [20 x i16]* @GlobSt3, i64 0, i64 %Idx
  store i16 %0, i16* %arrayidx1, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob4PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob4PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plhz r3, GlobLd4@PCREL(0), 1
; CHECK-P10-LE-NEXT:    psth r3, GlobSt4@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob4PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd4@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt4@toc@ha
; CHECK-P10-BE-NEXT:    lhz r3, GlobLd4@toc@l(r3)
; CHECK-P10-BE-NEXT:    sth r3, GlobSt4@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob4PtrPlus0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd4@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt4@toc@ha
; CHECK-NEXT:    lhz r3, GlobLd4@toc@l(r3)
; CHECK-NEXT:    sth r3, GlobSt4@toc@l(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobLd4, i64 0, i64 0), align 2
  store i16 %0, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobSt4, i64 0, i64 0), align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob4PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob4PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plhz r3, GlobLd4@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    psth r3, GlobSt4@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob4PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd4@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt4@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd4@toc@l
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobSt4@toc@l
; CHECK-P10-BE-NEXT:    lhz r3, 3(r3)
; CHECK-P10-BE-NEXT:    sth r3, 3(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob4PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd4@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt4@toc@ha
; CHECK-NEXT:    addi r3, r3, GlobLd4@toc@l
; CHECK-NEXT:    addi r4, r4, GlobSt4@toc@l
; CHECK-NEXT:    lhz r3, 3(r3)
; CHECK-NEXT:    sth r3, 3(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, i16* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i16]* @GlobLd4 to i8*), i64 3) to i16*), align 2
  store i16 %0, i16* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i16]* @GlobSt4 to i8*), i64 3) to i16*), align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob4PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob4PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plhz r3, GlobLd4@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    psth r3, GlobSt4@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob4PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd4@toc@ha+4
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt4@toc@ha+4
; CHECK-P10-BE-NEXT:    lhz r3, GlobLd4@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    sth r3, GlobSt4@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob4PtrPlus4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd4@toc@ha+4
; CHECK-NEXT:    addis r4, r2, GlobSt4@toc@ha+4
; CHECK-NEXT:    lhz r3, GlobLd4@toc@l+4(r3)
; CHECK-NEXT:    sth r3, GlobSt4@toc@l+4(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobLd4, i64 0, i64 2), align 2
  store i16 %0, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobSt4, i64 0, i64 2), align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob4PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob4PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plhz r3, GlobLd4@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    psth r3, GlobSt4@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob4PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd4@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt4@toc@ha+16
; CHECK-P10-BE-NEXT:    lhz r3, GlobLd4@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    sth r3, GlobSt4@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob4PtrPlus16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd4@toc@ha+16
; CHECK-NEXT:    addis r4, r2, GlobSt4@toc@ha+16
; CHECK-NEXT:    lhz r3, GlobLd4@toc@l+16(r3)
; CHECK-NEXT:    sth r3, GlobSt4@toc@l+16(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i16, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobLd4, i64 0, i64 8), align 2
  store i16 %0, i16* getelementptr inbounds ([20 x i16], [20 x i16]* @GlobSt4, i64 0, i64 8), align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob4PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob4PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 1
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd4@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt4@PCREL, 1
; CHECK-P10-LE-NEXT:    lhzx r4, r4, r3
; CHECK-P10-LE-NEXT:    sthx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob4PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd4@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 1
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt4@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd4@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt4@toc@l
; CHECK-P10-BE-NEXT:    lhzx r4, r4, r3
; CHECK-P10-BE-NEXT:    sthx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob4PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd4@toc@ha
; CHECK-NEXT:    sldi r3, r3, 1
; CHECK-NEXT:    addis r5, r2, GlobSt4@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd4@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt4@toc@l
; CHECK-NEXT:    lhzx r4, r4, r3
; CHECK-NEXT:    sthx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x i16], [20 x i16]* @GlobLd4, i64 0, i64 %Idx
  %0 = load i16, i16* %arrayidx, align 2
  %arrayidx1 = getelementptr inbounds [20 x i16], [20 x i16]* @GlobSt4, i64 0, i64 %Idx
  store i16 %0, i16* %arrayidx1, align 2
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob5PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob5PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd5@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt5@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob5PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd5@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt5@toc@ha
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd5@toc@l(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt5@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob5PtrPlus0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd5@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt5@toc@ha
; CHECK-NEXT:    lwz r3, GlobLd5@toc@l(r3)
; CHECK-NEXT:    stw r3, GlobSt5@toc@l(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobLd5, i64 0, i64 0), align 4
  store i32 %0, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobSt5, i64 0, i64 0), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob5PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob5PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd5@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt5@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob5PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd5@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt5@toc@ha
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd5@toc@l+3(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt5@toc@l+3(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob5PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd5@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt5@toc@ha
; CHECK-NEXT:    lwz r3, GlobLd5@toc@l+3(r3)
; CHECK-NEXT:    stw r3, GlobSt5@toc@l+3(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i32]* @GlobLd5 to i8*), i64 3) to i32*), align 4
  store i32 %0, i32* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i32]* @GlobSt5 to i8*), i64 3) to i32*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob5PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob5PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd5@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt5@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob5PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd5@toc@ha+4
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt5@toc@ha+4
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd5@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt5@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob5PtrPlus4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd5@toc@ha+4
; CHECK-NEXT:    addis r4, r2, GlobSt5@toc@ha+4
; CHECK-NEXT:    lwz r3, GlobLd5@toc@l+4(r3)
; CHECK-NEXT:    stw r3, GlobSt5@toc@l+4(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobLd5, i64 0, i64 1), align 4
  store i32 %0, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobSt5, i64 0, i64 1), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob5PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob5PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd5@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt5@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob5PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd5@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt5@toc@ha+16
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd5@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt5@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob5PtrPlus16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd5@toc@ha+16
; CHECK-NEXT:    addis r4, r2, GlobSt5@toc@ha+16
; CHECK-NEXT:    lwz r3, GlobLd5@toc@l+16(r3)
; CHECK-NEXT:    stw r3, GlobSt5@toc@l+16(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobLd5, i64 0, i64 4), align 4
  store i32 %0, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobSt5, i64 0, i64 4), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob5PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob5PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 2
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd5@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt5@PCREL, 1
; CHECK-P10-LE-NEXT:    lwzx r4, r4, r3
; CHECK-P10-LE-NEXT:    stwx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob5PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd5@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 2
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt5@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd5@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt5@toc@l
; CHECK-P10-BE-NEXT:    lwzx r4, r4, r3
; CHECK-P10-BE-NEXT:    stwx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob5PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd5@toc@ha
; CHECK-NEXT:    sldi r3, r3, 2
; CHECK-NEXT:    addis r5, r2, GlobSt5@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd5@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt5@toc@l
; CHECK-NEXT:    lwzx r4, r4, r3
; CHECK-NEXT:    stwx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x i32], [20 x i32]* @GlobLd5, i64 0, i64 %Idx
  %0 = load i32, i32* %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds [20 x i32], [20 x i32]* @GlobSt5, i64 0, i64 %Idx
  store i32 %0, i32* %arrayidx1, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob6PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob6PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd6@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt6@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob6PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd6@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt6@toc@ha
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd6@toc@l(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt6@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob6PtrPlus0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd6@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt6@toc@ha
; CHECK-NEXT:    lwz r3, GlobLd6@toc@l(r3)
; CHECK-NEXT:    stw r3, GlobSt6@toc@l(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobLd6, i64 0, i64 0), align 4
  store i32 %0, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobSt6, i64 0, i64 0), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob6PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob6PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd6@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt6@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob6PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd6@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt6@toc@ha
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd6@toc@l+3(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt6@toc@l+3(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob6PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd6@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt6@toc@ha
; CHECK-NEXT:    lwz r3, GlobLd6@toc@l+3(r3)
; CHECK-NEXT:    stw r3, GlobSt6@toc@l+3(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i32]* @GlobLd6 to i8*), i64 3) to i32*), align 4
  store i32 %0, i32* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i32]* @GlobSt6 to i8*), i64 3) to i32*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob6PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob6PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd6@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt6@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob6PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd6@toc@ha+4
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt6@toc@ha+4
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd6@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt6@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob6PtrPlus4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd6@toc@ha+4
; CHECK-NEXT:    addis r4, r2, GlobSt6@toc@ha+4
; CHECK-NEXT:    lwz r3, GlobLd6@toc@l+4(r3)
; CHECK-NEXT:    stw r3, GlobSt6@toc@l+4(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobLd6, i64 0, i64 1), align 4
  store i32 %0, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobSt6, i64 0, i64 1), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob6PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob6PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd6@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt6@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob6PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd6@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt6@toc@ha+16
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd6@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt6@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob6PtrPlus16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd6@toc@ha+16
; CHECK-NEXT:    addis r4, r2, GlobSt6@toc@ha+16
; CHECK-NEXT:    lwz r3, GlobLd6@toc@l+16(r3)
; CHECK-NEXT:    stw r3, GlobSt6@toc@l+16(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load i32, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobLd6, i64 0, i64 4), align 4
  store i32 %0, i32* getelementptr inbounds ([20 x i32], [20 x i32]* @GlobSt6, i64 0, i64 4), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob6PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob6PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 2
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd6@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt6@PCREL, 1
; CHECK-P10-LE-NEXT:    lwzx r4, r4, r3
; CHECK-P10-LE-NEXT:    stwx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob6PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd6@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 2
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt6@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd6@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt6@toc@l
; CHECK-P10-BE-NEXT:    lwzx r4, r4, r3
; CHECK-P10-BE-NEXT:    stwx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob6PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd6@toc@ha
; CHECK-NEXT:    sldi r3, r3, 2
; CHECK-NEXT:    addis r5, r2, GlobSt6@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd6@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt6@toc@l
; CHECK-NEXT:    lwzx r4, r4, r3
; CHECK-NEXT:    stwx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x i32], [20 x i32]* @GlobLd6, i64 0, i64 %Idx
  %0 = load i32, i32* %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds [20 x i32], [20 x i32]* @GlobSt6, i64 0, i64 %Idx
  store i32 %0, i32* %arrayidx1, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob7PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob7PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd7@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt7@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob7PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd7@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt7@toc@ha
; CHECK-P10-BE-NEXT:    ld r3, GlobLd7@toc@l(r3)
; CHECK-P10-BE-NEXT:    std r3, GlobSt7@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob7PtrPlus0:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd7@toc@ha
; CHECK-P9-NEXT:    addis r4, r2, GlobSt7@toc@ha
; CHECK-P9-NEXT:    ld r3, GlobLd7@toc@l(r3)
; CHECK-P9-NEXT:    std r3, GlobSt7@toc@l(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: testGlob7PtrPlus0:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, GlobLd7@toc@ha
; CHECK-P8-NEXT:    ld r3, GlobLd7@toc@l(r3)
; CHECK-P8-NEXT:    addis r4, r2, GlobSt7@toc@ha
; CHECK-P8-NEXT:    std r3, GlobSt7@toc@l(r4)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i64, i64* getelementptr inbounds ([20 x i64], [20 x i64]* @GlobLd7, i64 0, i64 0), align 8
  store i64 %0, i64* getelementptr inbounds ([20 x i64], [20 x i64]* @GlobSt7, i64 0, i64 0), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob7PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob7PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd7@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt7@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob7PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd7@toc@ha
; CHECK-P10-BE-NEXT:    li r4, 3
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt7@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd7@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt7@toc@l
; CHECK-P10-BE-NEXT:    ldx r3, r3, r4
; CHECK-P10-BE-NEXT:    stdx r3, r5, r4
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob7PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd7@toc@ha
; CHECK-NEXT:    li r4, 3
; CHECK-NEXT:    addis r5, r2, GlobSt7@toc@ha
; CHECK-NEXT:    addi r3, r3, GlobLd7@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt7@toc@l
; CHECK-NEXT:    ldx r3, r3, r4
; CHECK-NEXT:    stdx r3, r5, r4
; CHECK-NEXT:    blr
entry:
  %0 = load i64, i64* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i64]* @GlobLd7 to i8*), i64 3) to i64*), align 8
  store i64 %0, i64* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i64]* @GlobSt7 to i8*), i64 3) to i64*), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob7PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob7PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd7@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt7@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob7PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd7@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt7@toc@ha
; CHECK-P10-BE-NEXT:    ld r3, GlobLd7@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    std r3, GlobSt7@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob7PtrPlus4:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd7@toc@ha
; CHECK-P9-NEXT:    addis r4, r2, GlobSt7@toc@ha
; CHECK-P9-NEXT:    ld r3, GlobLd7@toc@l+4(r3)
; CHECK-P9-NEXT:    std r3, GlobSt7@toc@l+4(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: testGlob7PtrPlus4:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, GlobLd7@toc@ha
; CHECK-P8-NEXT:    ld r3, GlobLd7@toc@l+4(r3)
; CHECK-P8-NEXT:    addis r4, r2, GlobSt7@toc@ha
; CHECK-P8-NEXT:    std r3, GlobSt7@toc@l+4(r4)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i64, i64* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i64]* @GlobLd7 to i8*), i64 4) to i64*), align 8
  store i64 %0, i64* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i64]* @GlobSt7 to i8*), i64 4) to i64*), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob7PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob7PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd7@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt7@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob7PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd7@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt7@toc@ha+16
; CHECK-P10-BE-NEXT:    ld r3, GlobLd7@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    std r3, GlobSt7@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob7PtrPlus16:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd7@toc@ha+16
; CHECK-P9-NEXT:    addis r4, r2, GlobSt7@toc@ha+16
; CHECK-P9-NEXT:    ld r3, GlobLd7@toc@l+16(r3)
; CHECK-P9-NEXT:    std r3, GlobSt7@toc@l+16(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: testGlob7PtrPlus16:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, GlobLd7@toc@ha+16
; CHECK-P8-NEXT:    ld r3, GlobLd7@toc@l+16(r3)
; CHECK-P8-NEXT:    addis r4, r2, GlobSt7@toc@ha+16
; CHECK-P8-NEXT:    std r3, GlobSt7@toc@l+16(r4)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i64, i64* getelementptr inbounds ([20 x i64], [20 x i64]* @GlobLd7, i64 0, i64 2), align 8
  store i64 %0, i64* getelementptr inbounds ([20 x i64], [20 x i64]* @GlobSt7, i64 0, i64 2), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob7PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob7PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 3
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd7@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt7@PCREL, 1
; CHECK-P10-LE-NEXT:    ldx r4, r4, r3
; CHECK-P10-LE-NEXT:    stdx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob7PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd7@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 3
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt7@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd7@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt7@toc@l
; CHECK-P10-BE-NEXT:    ldx r4, r4, r3
; CHECK-P10-BE-NEXT:    stdx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob7PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd7@toc@ha
; CHECK-NEXT:    sldi r3, r3, 3
; CHECK-NEXT:    addis r5, r2, GlobSt7@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd7@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt7@toc@l
; CHECK-NEXT:    ldx r4, r4, r3
; CHECK-NEXT:    stdx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x i64], [20 x i64]* @GlobLd7, i64 0, i64 %Idx
  %0 = load i64, i64* %arrayidx, align 8
  %arrayidx1 = getelementptr inbounds [20 x i64], [20 x i64]* @GlobSt7, i64 0, i64 %Idx
  store i64 %0, i64* %arrayidx1, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob8PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob8PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd8@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt8@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob8PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd8@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt8@toc@ha
; CHECK-P10-BE-NEXT:    ld r3, GlobLd8@toc@l(r3)
; CHECK-P10-BE-NEXT:    std r3, GlobSt8@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob8PtrPlus0:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd8@toc@ha
; CHECK-P9-NEXT:    addis r4, r2, GlobSt8@toc@ha
; CHECK-P9-NEXT:    ld r3, GlobLd8@toc@l(r3)
; CHECK-P9-NEXT:    std r3, GlobSt8@toc@l(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: testGlob8PtrPlus0:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, GlobLd8@toc@ha
; CHECK-P8-NEXT:    ld r3, GlobLd8@toc@l(r3)
; CHECK-P8-NEXT:    addis r4, r2, GlobSt8@toc@ha
; CHECK-P8-NEXT:    std r3, GlobSt8@toc@l(r4)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i64, i64* getelementptr inbounds ([20 x i64], [20 x i64]* @GlobLd8, i64 0, i64 0), align 8
  store i64 %0, i64* getelementptr inbounds ([20 x i64], [20 x i64]* @GlobSt8, i64 0, i64 0), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob8PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob8PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd8@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt8@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob8PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd8@toc@ha
; CHECK-P10-BE-NEXT:    li r4, 3
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt8@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd8@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt8@toc@l
; CHECK-P10-BE-NEXT:    ldx r3, r3, r4
; CHECK-P10-BE-NEXT:    stdx r3, r5, r4
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob8PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd8@toc@ha
; CHECK-NEXT:    li r4, 3
; CHECK-NEXT:    addis r5, r2, GlobSt8@toc@ha
; CHECK-NEXT:    addi r3, r3, GlobLd8@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt8@toc@l
; CHECK-NEXT:    ldx r3, r3, r4
; CHECK-NEXT:    stdx r3, r5, r4
; CHECK-NEXT:    blr
entry:
  %0 = load i64, i64* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i64]* @GlobLd8 to i8*), i64 3) to i64*), align 8
  store i64 %0, i64* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i64]* @GlobSt8 to i8*), i64 3) to i64*), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob8PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob8PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd8@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt8@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob8PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd8@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt8@toc@ha
; CHECK-P10-BE-NEXT:    ld r3, GlobLd8@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    std r3, GlobSt8@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob8PtrPlus4:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd8@toc@ha
; CHECK-P9-NEXT:    addis r4, r2, GlobSt8@toc@ha
; CHECK-P9-NEXT:    ld r3, GlobLd8@toc@l+4(r3)
; CHECK-P9-NEXT:    std r3, GlobSt8@toc@l+4(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: testGlob8PtrPlus4:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, GlobLd8@toc@ha
; CHECK-P8-NEXT:    ld r3, GlobLd8@toc@l+4(r3)
; CHECK-P8-NEXT:    addis r4, r2, GlobSt8@toc@ha
; CHECK-P8-NEXT:    std r3, GlobSt8@toc@l+4(r4)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i64, i64* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i64]* @GlobLd8 to i8*), i64 4) to i64*), align 8
  store i64 %0, i64* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x i64]* @GlobSt8 to i8*), i64 4) to i64*), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob8PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob8PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd8@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt8@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob8PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd8@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt8@toc@ha+16
; CHECK-P10-BE-NEXT:    ld r3, GlobLd8@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    std r3, GlobSt8@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob8PtrPlus16:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd8@toc@ha+16
; CHECK-P9-NEXT:    addis r4, r2, GlobSt8@toc@ha+16
; CHECK-P9-NEXT:    ld r3, GlobLd8@toc@l+16(r3)
; CHECK-P9-NEXT:    std r3, GlobSt8@toc@l+16(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: testGlob8PtrPlus16:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, GlobLd8@toc@ha+16
; CHECK-P8-NEXT:    ld r3, GlobLd8@toc@l+16(r3)
; CHECK-P8-NEXT:    addis r4, r2, GlobSt8@toc@ha+16
; CHECK-P8-NEXT:    std r3, GlobSt8@toc@l+16(r4)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load i64, i64* getelementptr inbounds ([20 x i64], [20 x i64]* @GlobLd8, i64 0, i64 2), align 8
  store i64 %0, i64* getelementptr inbounds ([20 x i64], [20 x i64]* @GlobSt8, i64 0, i64 2), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob8PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob8PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 3
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd8@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt8@PCREL, 1
; CHECK-P10-LE-NEXT:    ldx r4, r4, r3
; CHECK-P10-LE-NEXT:    stdx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob8PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd8@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 3
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt8@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd8@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt8@toc@l
; CHECK-P10-BE-NEXT:    ldx r4, r4, r3
; CHECK-P10-BE-NEXT:    stdx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob8PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd8@toc@ha
; CHECK-NEXT:    sldi r3, r3, 3
; CHECK-NEXT:    addis r5, r2, GlobSt8@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd8@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt8@toc@l
; CHECK-NEXT:    ldx r4, r4, r3
; CHECK-NEXT:    stdx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x i64], [20 x i64]* @GlobLd8, i64 0, i64 %Idx
  %0 = load i64, i64* %arrayidx, align 8
  %arrayidx1 = getelementptr inbounds [20 x i64], [20 x i64]* @GlobSt8, i64 0, i64 %Idx
  store i64 %0, i64* %arrayidx1, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob9PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob9PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd9@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt9@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob9PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd9@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt9@toc@ha
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd9@toc@l(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt9@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob9PtrPlus0:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd9@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt9@toc@ha
; CHECK-NEXT:    lwz r3, GlobLd9@toc@l(r3)
; CHECK-NEXT:    stw r3, GlobSt9@toc@l(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load float, float* getelementptr inbounds ([20 x float], [20 x float]* @GlobLd9, i64 0, i64 0), align 4
  store float %0, float* getelementptr inbounds ([20 x float], [20 x float]* @GlobSt9, i64 0, i64 0), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob9PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob9PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd9@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt9@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob9PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd9@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt9@toc@ha
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd9@toc@l+3(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt9@toc@l+3(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob9PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd9@toc@ha
; CHECK-NEXT:    addis r4, r2, GlobSt9@toc@ha
; CHECK-NEXT:    lwz r3, GlobLd9@toc@l+3(r3)
; CHECK-NEXT:    stw r3, GlobSt9@toc@l+3(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load float, float* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x float]* @GlobLd9 to i8*), i64 3) to float*), align 4
  store float %0, float* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x float]* @GlobSt9 to i8*), i64 3) to float*), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob9PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob9PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd9@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt9@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob9PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd9@toc@ha+4
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt9@toc@ha+4
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd9@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt9@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob9PtrPlus4:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd9@toc@ha+4
; CHECK-NEXT:    addis r4, r2, GlobSt9@toc@ha+4
; CHECK-NEXT:    lwz r3, GlobLd9@toc@l+4(r3)
; CHECK-NEXT:    stw r3, GlobSt9@toc@l+4(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load float, float* getelementptr inbounds ([20 x float], [20 x float]* @GlobLd9, i64 0, i64 1), align 4
  store float %0, float* getelementptr inbounds ([20 x float], [20 x float]* @GlobSt9, i64 0, i64 1), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob9PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob9PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plwz r3, GlobLd9@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstw r3, GlobSt9@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob9PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd9@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt9@toc@ha+16
; CHECK-P10-BE-NEXT:    lwz r3, GlobLd9@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    stw r3, GlobSt9@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob9PtrPlus16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd9@toc@ha+16
; CHECK-NEXT:    addis r4, r2, GlobSt9@toc@ha+16
; CHECK-NEXT:    lwz r3, GlobLd9@toc@l+16(r3)
; CHECK-NEXT:    stw r3, GlobSt9@toc@l+16(r4)
; CHECK-NEXT:    blr
entry:
  %0 = load float, float* getelementptr inbounds ([20 x float], [20 x float]* @GlobLd9, i64 0, i64 4), align 4
  store float %0, float* getelementptr inbounds ([20 x float], [20 x float]* @GlobSt9, i64 0, i64 4), align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob9PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob9PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 2
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd9@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt9@PCREL, 1
; CHECK-P10-LE-NEXT:    lwzx r4, r4, r3
; CHECK-P10-LE-NEXT:    stwx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob9PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd9@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 2
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt9@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd9@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt9@toc@l
; CHECK-P10-BE-NEXT:    lwzx r4, r4, r3
; CHECK-P10-BE-NEXT:    stwx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob9PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd9@toc@ha
; CHECK-NEXT:    sldi r3, r3, 2
; CHECK-NEXT:    addis r5, r2, GlobSt9@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd9@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt9@toc@l
; CHECK-NEXT:    lwzx r4, r4, r3
; CHECK-NEXT:    stwx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x float], [20 x float]* @GlobLd9, i64 0, i64 %Idx
  %0 = load float, float* %arrayidx, align 4
  %arrayidx1 = getelementptr inbounds [20 x float], [20 x float]* @GlobSt9, i64 0, i64 %Idx
  store float %0, float* %arrayidx1, align 4
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob10PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob10PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd10@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt10@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob10PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd10@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt10@toc@ha
; CHECK-P10-BE-NEXT:    ld r3, GlobLd10@toc@l(r3)
; CHECK-P10-BE-NEXT:    std r3, GlobSt10@toc@l(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob10PtrPlus0:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd10@toc@ha
; CHECK-P9-NEXT:    addis r4, r2, GlobSt10@toc@ha
; CHECK-P9-NEXT:    ld r3, GlobLd10@toc@l(r3)
; CHECK-P9-NEXT:    std r3, GlobSt10@toc@l(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: testGlob10PtrPlus0:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, GlobLd10@toc@ha
; CHECK-P8-NEXT:    ld r3, GlobLd10@toc@l(r3)
; CHECK-P8-NEXT:    addis r4, r2, GlobSt10@toc@ha
; CHECK-P8-NEXT:    std r3, GlobSt10@toc@l(r4)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load double, double* getelementptr inbounds ([20 x double], [20 x double]* @GlobLd10, i64 0, i64 0), align 8
  store double %0, double* getelementptr inbounds ([20 x double], [20 x double]* @GlobSt10, i64 0, i64 0), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob10PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob10PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd10@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt10@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob10PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd10@toc@ha
; CHECK-P10-BE-NEXT:    li r4, 3
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt10@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd10@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt10@toc@l
; CHECK-P10-BE-NEXT:    ldx r3, r3, r4
; CHECK-P10-BE-NEXT:    stdx r3, r5, r4
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob10PtrPlus3:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r3, r2, GlobLd10@toc@ha
; CHECK-NEXT:    li r4, 3
; CHECK-NEXT:    addis r5, r2, GlobSt10@toc@ha
; CHECK-NEXT:    addi r3, r3, GlobLd10@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt10@toc@l
; CHECK-NEXT:    ldx r3, r3, r4
; CHECK-NEXT:    stdx r3, r5, r4
; CHECK-NEXT:    blr
entry:
  %0 = load double, double* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x double]* @GlobLd10 to i8*), i64 3) to double*), align 8
  store double %0, double* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x double]* @GlobSt10 to i8*), i64 3) to double*), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob10PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob10PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd10@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt10@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob10PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd10@toc@ha
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt10@toc@ha
; CHECK-P10-BE-NEXT:    ld r3, GlobLd10@toc@l+4(r3)
; CHECK-P10-BE-NEXT:    std r3, GlobSt10@toc@l+4(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob10PtrPlus4:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd10@toc@ha
; CHECK-P9-NEXT:    addis r4, r2, GlobSt10@toc@ha
; CHECK-P9-NEXT:    ld r3, GlobLd10@toc@l+4(r3)
; CHECK-P9-NEXT:    std r3, GlobSt10@toc@l+4(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: testGlob10PtrPlus4:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, GlobLd10@toc@ha
; CHECK-P8-NEXT:    ld r3, GlobLd10@toc@l+4(r3)
; CHECK-P8-NEXT:    addis r4, r2, GlobSt10@toc@ha
; CHECK-P8-NEXT:    std r3, GlobSt10@toc@l+4(r4)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load double, double* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x double]* @GlobLd10 to i8*), i64 4) to double*), align 8
  store double %0, double* bitcast (i8* getelementptr inbounds (i8, i8* bitcast ([20 x double]* @GlobSt10 to i8*), i64 4) to double*), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob10PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob10PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    pld r3, GlobLd10@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstd r3, GlobSt10@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob10PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd10@toc@ha+16
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt10@toc@ha+16
; CHECK-P10-BE-NEXT:    ld r3, GlobLd10@toc@l+16(r3)
; CHECK-P10-BE-NEXT:    std r3, GlobSt10@toc@l+16(r4)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob10PtrPlus16:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd10@toc@ha+16
; CHECK-P9-NEXT:    addis r4, r2, GlobSt10@toc@ha+16
; CHECK-P9-NEXT:    ld r3, GlobLd10@toc@l+16(r3)
; CHECK-P9-NEXT:    std r3, GlobSt10@toc@l+16(r4)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LABEL: testGlob10PtrPlus16:
; CHECK-P8:       # %bb.0: # %entry
; CHECK-P8-NEXT:    addis r3, r2, GlobLd10@toc@ha+16
; CHECK-P8-NEXT:    ld r3, GlobLd10@toc@l+16(r3)
; CHECK-P8-NEXT:    addis r4, r2, GlobSt10@toc@ha+16
; CHECK-P8-NEXT:    std r3, GlobSt10@toc@l+16(r4)
; CHECK-P8-NEXT:    blr
entry:
  %0 = load double, double* getelementptr inbounds ([20 x double], [20 x double]* @GlobLd10, i64 0, i64 2), align 8
  store double %0, double* getelementptr inbounds ([20 x double], [20 x double]* @GlobSt10, i64 0, i64 2), align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob10PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob10PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 3
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd10@PCREL, 1
; CHECK-P10-LE-NEXT:    paddi r5, 0, GlobSt10@PCREL, 1
; CHECK-P10-LE-NEXT:    ldx r4, r4, r3
; CHECK-P10-LE-NEXT:    stdx r4, r5, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob10PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd10@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 3
; CHECK-P10-BE-NEXT:    addis r5, r2, GlobSt10@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd10@toc@l
; CHECK-P10-BE-NEXT:    addi r5, r5, GlobSt10@toc@l
; CHECK-P10-BE-NEXT:    ldx r4, r4, r3
; CHECK-P10-BE-NEXT:    stdx r4, r5, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-LABEL: testGlob10PtrPlusVar:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    addis r4, r2, GlobLd10@toc@ha
; CHECK-NEXT:    sldi r3, r3, 3
; CHECK-NEXT:    addis r5, r2, GlobSt10@toc@ha
; CHECK-NEXT:    addi r4, r4, GlobLd10@toc@l
; CHECK-NEXT:    addi r5, r5, GlobSt10@toc@l
; CHECK-NEXT:    ldx r4, r4, r3
; CHECK-NEXT:    stdx r4, r5, r3
; CHECK-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x double], [20 x double]* @GlobLd10, i64 0, i64 %Idx
  %0 = load double, double* %arrayidx, align 8
  %arrayidx1 = getelementptr inbounds [20 x double], [20 x double]* @GlobSt10, i64 0, i64 %Idx
  store double %0, double* %arrayidx1, align 8
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob11PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob11PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd11@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt11@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob11PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P10-BE-NEXT:    lxv vs0, 0(r3)
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P10-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob11PtrPlus0:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P9-NEXT:    lxv vs0, 0(r3)
; CHECK-P9-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob11PtrPlus0:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob11PtrPlus0:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, 0, r3
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* getelementptr inbounds ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd11, i64 0, i64 0), align 16
  store <16 x i8> %0, <16 x i8>* getelementptr inbounds ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt11, i64 0, i64 0), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob11PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob11PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd11@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt11@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob11PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P10-BE-NEXT:    li r4, 3
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob11PtrPlus3:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P9-NEXT:    li r4, 3
; CHECK-P9-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P9-NEXT:    lxvx vs0, r3, r4
; CHECK-P9-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P9-NEXT:    stxvx vs0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob11PtrPlus3:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P8-LE-NEXT:    li r4, 3
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob11PtrPlus3:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P8-BE-NEXT:    li r4, 3
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* bitcast (i8* getelementptr ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd11, i64 0, i64 0, i64 3) to <16 x i8>*), align 16
  store <16 x i8> %0, <16 x i8>* bitcast (i8* getelementptr ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt11, i64 0, i64 0, i64 3) to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob11PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob11PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd11@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt11@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob11PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P10-BE-NEXT:    li r4, 4
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob11PtrPlus4:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P9-NEXT:    li r4, 4
; CHECK-P9-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P9-NEXT:    lxvx vs0, r3, r4
; CHECK-P9-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P9-NEXT:    stxvx vs0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob11PtrPlus4:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P8-LE-NEXT:    li r4, 4
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob11PtrPlus4:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P8-BE-NEXT:    li r4, 4
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* bitcast (i8* getelementptr ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd11, i64 0, i64 0, i64 4) to <16 x i8>*), align 16
  store <16 x i8> %0, <16 x i8>* bitcast (i8* getelementptr ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt11, i64 0, i64 0, i64 4) to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob11PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob11PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd11@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt11@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob11PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P10-BE-NEXT:    lxv vs0, 16(r3)
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P10-BE-NEXT:    stxv vs0, 16(r3)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob11PtrPlus16:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P9-NEXT:    lxv vs0, 16(r3)
; CHECK-P9-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P9-NEXT:    stxv vs0, 16(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob11PtrPlus16:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P8-LE-NEXT:    li r4, 16
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob11PtrPlus16:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobLd11@toc@ha
; CHECK-P8-BE-NEXT:    li r4, 16
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobLd11@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobSt11@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobSt11@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* bitcast (i8* getelementptr inbounds ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd11, i64 0, i64 1, i64 0) to <16 x i8>*), align 16
  store <16 x i8> %0, <16 x i8>* bitcast (i8* getelementptr inbounds ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt11, i64 0, i64 1, i64 0) to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob11PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob11PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 4
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd11@PCREL, 1
; CHECK-P10-LE-NEXT:    lxvx vs0, r4, r3
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobSt11@PCREL, 1
; CHECK-P10-LE-NEXT:    stxvx vs0, r4, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob11PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd11@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 4
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd11@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, r4, r3
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt11@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobSt11@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, r4, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob11PtrPlusVar:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r4, r2, GlobLd11@toc@ha
; CHECK-P9-NEXT:    sldi r3, r3, 4
; CHECK-P9-NEXT:    addi r4, r4, GlobLd11@toc@l
; CHECK-P9-NEXT:    lxvx vs0, r4, r3
; CHECK-P9-NEXT:    addis r4, r2, GlobSt11@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, GlobSt11@toc@l
; CHECK-P9-NEXT:    stxvx vs0, r4, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob11PtrPlusVar:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r4, r2, GlobLd11@toc@ha
; CHECK-P8-LE-NEXT:    sldi r3, r3, 4
; CHECK-P8-LE-NEXT:    addi r4, r4, GlobLd11@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, r4, r3
; CHECK-P8-LE-NEXT:    addis r4, r2, GlobSt11@toc@ha
; CHECK-P8-LE-NEXT:    addi r4, r4, GlobSt11@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, r4, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob11PtrPlusVar:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r4, r2, GlobLd11@toc@ha
; CHECK-P8-BE-NEXT:    sldi r3, r3, 4
; CHECK-P8-BE-NEXT:    addi r4, r4, GlobLd11@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, r4, r3
; CHECK-P8-BE-NEXT:    addis r4, r2, GlobSt11@toc@ha
; CHECK-P8-BE-NEXT:    addi r4, r4, GlobSt11@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, r4, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd11, i64 0, i64 %Idx
  %0 = load <16 x i8>, <16 x i8>* %arrayidx, align 16
  %arrayidx1 = getelementptr inbounds [20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt11, i64 0, i64 %Idx
  store <16 x i8> %0, <16 x i8>* %arrayidx1, align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob12PtrPlus0() {
; CHECK-P10-LE-LABEL: testGlob12PtrPlus0:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd12@PCREL(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt12@PCREL(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob12PtrPlus0:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P10-BE-NEXT:    lxv vs0, 0(r3)
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P10-BE-NEXT:    stxv vs0, 0(r3)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob12PtrPlus0:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P9-NEXT:    lxv vs0, 0(r3)
; CHECK-P9-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P9-NEXT:    stxv vs0, 0(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob12PtrPlus0:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, 0, r3
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, 0, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob12PtrPlus0:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, 0, r3
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, 0, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* getelementptr inbounds ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd12, i64 0, i64 0), align 16
  store <16 x i8> %0, <16 x i8>* getelementptr inbounds ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt12, i64 0, i64 0), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob12PtrPlus3() {
; CHECK-P10-LE-LABEL: testGlob12PtrPlus3:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd12@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt12@PCREL+3(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob12PtrPlus3:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P10-BE-NEXT:    li r4, 3
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob12PtrPlus3:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P9-NEXT:    li r4, 3
; CHECK-P9-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P9-NEXT:    lxvx vs0, r3, r4
; CHECK-P9-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P9-NEXT:    stxvx vs0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob12PtrPlus3:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P8-LE-NEXT:    li r4, 3
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob12PtrPlus3:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P8-BE-NEXT:    li r4, 3
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* bitcast (i8* getelementptr ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd12, i64 0, i64 0, i64 3) to <16 x i8>*), align 16
  store <16 x i8> %0, <16 x i8>* bitcast (i8* getelementptr ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt12, i64 0, i64 0, i64 3) to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob12PtrPlus4() {
; CHECK-P10-LE-LABEL: testGlob12PtrPlus4:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd12@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt12@PCREL+4(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob12PtrPlus4:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P10-BE-NEXT:    li r4, 4
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, r3, r4
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob12PtrPlus4:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P9-NEXT:    li r4, 4
; CHECK-P9-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P9-NEXT:    lxvx vs0, r3, r4
; CHECK-P9-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P9-NEXT:    stxvx vs0, r3, r4
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob12PtrPlus4:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P8-LE-NEXT:    li r4, 4
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob12PtrPlus4:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P8-BE-NEXT:    li r4, 4
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* bitcast (i8* getelementptr ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd12, i64 0, i64 0, i64 4) to <16 x i8>*), align 16
  store <16 x i8> %0, <16 x i8>* bitcast (i8* getelementptr ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt12, i64 0, i64 0, i64 4) to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob12PtrPlus16() {
; CHECK-P10-LE-LABEL: testGlob12PtrPlus16:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    plxv vs0, GlobLd12@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    pstxv vs0, GlobSt12@PCREL+16(0), 1
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob12PtrPlus16:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P10-BE-NEXT:    lxv vs0, 16(r3)
; CHECK-P10-BE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P10-BE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P10-BE-NEXT:    stxv vs0, 16(r3)
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob12PtrPlus16:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P9-NEXT:    lxv vs0, 16(r3)
; CHECK-P9-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P9-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P9-NEXT:    stxv vs0, 16(r3)
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob12PtrPlus16:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P8-LE-NEXT:    li r4, 16
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, r3, r4
; CHECK-P8-LE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P8-LE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, r3, r4
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob12PtrPlus16:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobLd12@toc@ha
; CHECK-P8-BE-NEXT:    li r4, 16
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobLd12@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    addis r3, r2, GlobSt12@toc@ha
; CHECK-P8-BE-NEXT:    addi r3, r3, GlobSt12@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, r3, r4
; CHECK-P8-BE-NEXT:    blr
entry:
  %0 = load <16 x i8>, <16 x i8>* bitcast (i8* getelementptr inbounds ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd12, i64 0, i64 1, i64 0) to <16 x i8>*), align 16
  store <16 x i8> %0, <16 x i8>* bitcast (i8* getelementptr inbounds ([20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt12, i64 0, i64 1, i64 0) to <16 x i8>*), align 16
  ret void
}

; Function Attrs: nofree norecurse nounwind uwtable willreturn
define dso_local void @testGlob12PtrPlusVar(i64 %Idx) {
; CHECK-P10-LE-LABEL: testGlob12PtrPlusVar:
; CHECK-P10-LE:       # %bb.0: # %entry
; CHECK-P10-LE-NEXT:    sldi r3, r3, 4
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobLd12@PCREL, 1
; CHECK-P10-LE-NEXT:    lxvx vs0, r4, r3
; CHECK-P10-LE-NEXT:    paddi r4, 0, GlobSt12@PCREL, 1
; CHECK-P10-LE-NEXT:    stxvx vs0, r4, r3
; CHECK-P10-LE-NEXT:    blr
;
; CHECK-P10-BE-LABEL: testGlob12PtrPlusVar:
; CHECK-P10-BE:       # %bb.0: # %entry
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobLd12@toc@ha
; CHECK-P10-BE-NEXT:    sldi r3, r3, 4
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobLd12@toc@l
; CHECK-P10-BE-NEXT:    lxvx vs0, r4, r3
; CHECK-P10-BE-NEXT:    addis r4, r2, GlobSt12@toc@ha
; CHECK-P10-BE-NEXT:    addi r4, r4, GlobSt12@toc@l
; CHECK-P10-BE-NEXT:    stxvx vs0, r4, r3
; CHECK-P10-BE-NEXT:    blr
;
; CHECK-P9-LABEL: testGlob12PtrPlusVar:
; CHECK-P9:       # %bb.0: # %entry
; CHECK-P9-NEXT:    addis r4, r2, GlobLd12@toc@ha
; CHECK-P9-NEXT:    sldi r3, r3, 4
; CHECK-P9-NEXT:    addi r4, r4, GlobLd12@toc@l
; CHECK-P9-NEXT:    lxvx vs0, r4, r3
; CHECK-P9-NEXT:    addis r4, r2, GlobSt12@toc@ha
; CHECK-P9-NEXT:    addi r4, r4, GlobSt12@toc@l
; CHECK-P9-NEXT:    stxvx vs0, r4, r3
; CHECK-P9-NEXT:    blr
;
; CHECK-P8-LE-LABEL: testGlob12PtrPlusVar:
; CHECK-P8-LE:       # %bb.0: # %entry
; CHECK-P8-LE-NEXT:    addis r4, r2, GlobLd12@toc@ha
; CHECK-P8-LE-NEXT:    sldi r3, r3, 4
; CHECK-P8-LE-NEXT:    addi r4, r4, GlobLd12@toc@l
; CHECK-P8-LE-NEXT:    lvx v2, r4, r3
; CHECK-P8-LE-NEXT:    addis r4, r2, GlobSt12@toc@ha
; CHECK-P8-LE-NEXT:    addi r4, r4, GlobSt12@toc@l
; CHECK-P8-LE-NEXT:    stvx v2, r4, r3
; CHECK-P8-LE-NEXT:    blr
;
; CHECK-P8-BE-LABEL: testGlob12PtrPlusVar:
; CHECK-P8-BE:       # %bb.0: # %entry
; CHECK-P8-BE-NEXT:    addis r4, r2, GlobLd12@toc@ha
; CHECK-P8-BE-NEXT:    sldi r3, r3, 4
; CHECK-P8-BE-NEXT:    addi r4, r4, GlobLd12@toc@l
; CHECK-P8-BE-NEXT:    lxvw4x vs0, r4, r3
; CHECK-P8-BE-NEXT:    addis r4, r2, GlobSt12@toc@ha
; CHECK-P8-BE-NEXT:    addi r4, r4, GlobSt12@toc@l
; CHECK-P8-BE-NEXT:    stxvw4x vs0, r4, r3
; CHECK-P8-BE-NEXT:    blr
entry:
  %arrayidx = getelementptr inbounds [20 x <16 x i8>], [20 x <16 x i8>]* @GlobLd12, i64 0, i64 %Idx
  %0 = load <16 x i8>, <16 x i8>* %arrayidx, align 16
  %arrayidx1 = getelementptr inbounds [20 x <16 x i8>], [20 x <16 x i8>]* @GlobSt12, i64 0, i64 %Idx
  store <16 x i8> %0, <16 x i8>* %arrayidx1, align 16
  ret void
}
