/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.odfdom.type;

import java.util.regex.Pattern;
import org.odftoolkit.odfdom.type.OdfDataType;

public class Points
implements OdfDataType {
    private String mPoints;
    private static final Pattern pointsPattern = Pattern.compile("^-?[0-9]+,-?[0-9]+([ ]+-?[0-9]+,-?[0-9]+)*$");

    public Points(String points) throws IllegalArgumentException {
        if (!Points.isValid(points)) {
            throw new IllegalArgumentException("parameter is invalid for datatype Points");
        }
        this.mPoints = points;
    }

    public String toString() {
        return this.mPoints;
    }

    public static Points valueOf(String stringValue) throws IllegalArgumentException {
        return new Points(stringValue);
    }

    public static boolean isValid(String stringValue) {
        return stringValue != null && pointsPattern.matcher(stringValue).matches();
    }
}

