#!/usr/bin/perl
#
# Format XHTML generated by groff -Thtml (via tidy) for websites
#
# Usage: groff -Thtml -P-l something.man | tidy -asxml ... | perl fix-groff-xhtml.pl OUTPUT-FILE
#
# (C) Copyright 2003-2014 Dave Beckett
#

use strict;
use File::Basename;

my $progname=basename $0;

my $raptor_title="Raptor RDF Parser Toolkit";
my $redland_title="Redland RDF Application Framework";
my $rasqal_title="Rasqal RDF Query Library";

die "USAGE: $progname OUTPUT-FILE\n" if @ARGV < 1;

my $doc_title;

my($file)=@ARGV;

open(OUT, ">$file") or die "$progname: Cannot create $file - $!\n";
open(IN, "-");
while(<IN>) {

  s%<title>libraptor</title>%<title>$raptor_title - Raptor API</title>%;
  s%<h1 align="center">libraptor</h1>%<h1>$raptor_title - Raptor API</h1>%;

  s%<title>rapper</title>%<title>$raptor_title - Raptor RDF parser utility</title>%;
  s%<h1 align="center">rapper</h1>%<h1>$raptor_title - Raptor RDF parser utility</h1>%;

  s%<title>rdfproc</title>%<title>$redland_title - Redland RDF processor utility</title>%;
  s%<h1 align="center">rdfproc</h1>%<h1>$redland_title - Redland RDF processor utility</h1>%;

  s%<title>librasqal</title>%<title>$rasqal_title - Rasqal API</title>%;
  s%<h1 align="center">librasqal</h1>%<h1>$rasqal_title - Rasqal API</h1>%;

  s%<title>roqet</title>%<title>$rasqal_title - Rasqal RDF parser utility</title>%;
  s%<h1 align="center">roqet</h1>%<h1>$rasqal_title - Rasqal RDF parser utility</h1>%;

  next if /^<link|meta/i;

  s%^<body[^>]*>%<body>%;

  # This is not xhtml
  s% cols="\d+" % %;

  s%(name|id)="([^"]+)"%my($at,$val)=($1,$2); $val =~ s/ /_/g; qq{$at="$val"};%eg;

  s%(Dave Beckett|Institute for Learning and Research Technology .ILRT.|University of Bristol) (?:- |)(http://[^<]+)%<a href="$2">$1</a>%;

  my $year=1900+(localtime)[5];
  print OUT <<"EOT" if m%^</body>%;

<p>Copyright 2002-$year <a href="http://www.dajobe.org/">Dave Beckett</a><br />2002-2005 <a href="http://www.bristol.ac.uk/">University of Bristol</a></p>

EOT
  print OUT;
}
close(IN);
close(OUT);
