/*
 * Decompiled with CFR 0.152.
 */
package org.chromium.devtools.jsdoc.checks;

import com.google.javascript.rhino.head.ast.AstNode;
import com.google.javascript.rhino.head.ast.Comment;
import com.google.javascript.rhino.head.ast.FunctionNode;
import java.util.regex.Pattern;
import org.chromium.devtools.jsdoc.ValidatorContext;
import org.chromium.devtools.jsdoc.checks.AstUtil;
import org.chromium.devtools.jsdoc.checks.ContextTrackingState;

abstract class ContextTrackingChecker {
    private ContextTrackingState state;

    ContextTrackingChecker() {
    }

    abstract void enterNode(AstNode var1);

    abstract void leaveNode(AstNode var1);

    void setState(ContextTrackingState contextTrackingState) {
        this.state = contextTrackingState;
    }

    protected ContextTrackingState getState() {
        return this.state;
    }

    protected ValidatorContext getContext() {
        return this.state.getContext();
    }

    protected boolean hasAnnotationTag(FunctionNode functionNode, String string) {
        Comment comment = AstUtil.getJsDocNode(functionNode);
        return comment != null && Pattern.matches("(?s).*@" + string + "\\b.*", this.getContext().getNodeText(comment));
    }

    protected void reportErrorAtNodeStart(AstNode astNode, String string) {
        this.getContext().reportErrorInNode(astNode, 0, string);
    }
}

