/* Exit from GNU tar.

   Copyright 2009, 2013-2014, 2016 Free Software Foundation, Inc.

   This file is part of GNU tar.

   GNU tar is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 3 of the License, or
   (at your option) any later version.

   GNU tar is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <http://www.gnu.org/licenses/>.  */

#include <system.h>
#include "common.h"

void (*fatal_exit_hook) (void);

void
fatal_exit (void)
{
  if (fatal_exit_hook)
    fatal_exit_hook ();
  error (TAREXIT_FAILURE, 0, _("Error is not recoverable: exiting now"));
  abort ();
}

void
xalloc_die (void)
{
  error (0, 0, "%s", _("memory exhausted"));
  fatal_exit ();
}
