/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf;

import htsjdk.samtools.metrics.MetricBase;
import htsjdk.variant.variantcontext.VariantContext;
import java.util.Map;
import picard.vcf.GenotypeConcordanceCounts;
import picard.vcf.GenotypeConcordanceScheme;
import picard.vcf.GenotypeConcordanceStates;

public class GenotypeConcordanceContingencyMetrics
extends MetricBase {
    public VariantContext.Type VARIANT_TYPE;
    public String TRUTH_SAMPLE;
    public String CALL_SAMPLE;
    public int TP_COUNT;
    public int TN_COUNT;
    public int FP_COUNT;
    public int FN_COUNT;
    public int EMPTY_COUNT;

    public GenotypeConcordanceContingencyMetrics() {
    }

    GenotypeConcordanceContingencyMetrics(VariantContext.Type variantType, GenotypeConcordanceCounts concordanceCounts, String truthSample, String callSample) {
        this.VARIANT_TYPE = variantType;
        this.TRUTH_SAMPLE = truthSample;
        this.CALL_SAMPLE = callSample;
        GenotypeConcordanceScheme scheme = new GenotypeConcordanceScheme();
        concordanceCounts.validateCountsAgainstScheme(scheme);
        Map<GenotypeConcordanceStates.ContingencyState, Integer> counts = concordanceCounts.getContingencyStateCounts(scheme);
        this.TP_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.TP);
        this.TN_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.TN);
        this.FP_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.FP);
        this.FN_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.FN);
        this.EMPTY_COUNT = counts.get((Object)GenotypeConcordanceStates.ContingencyState.EMPTY);
    }
}

