/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.gatk.utils.locusiterator;

import com.google.java.contract.Ensures;
import com.google.java.contract.Requires;
import htsjdk.samtools.SAMRecord;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.broadinstitute.gatk.engine.downsampling.Downsampler;
import org.broadinstitute.gatk.engine.downsampling.PassThroughDownsampler;
import org.broadinstitute.gatk.engine.downsampling.ReservoirDownsampler;
import org.broadinstitute.gatk.utils.locusiterator.LIBSDownsamplingInfo;

class SamplePartitioner<T extends SAMRecord> {
    private final Map<String, Downsampler<T>> readsBySample;
    boolean doneSubmittingReads = false;

    @Ensures(value={"readsBySample != null", "readsBySample.size() == new HashSet(samples).size()"})
    public SamplePartitioner(LIBSDownsamplingInfo LIBSDownsamplingInfo2, List<String> samples) {
        if (LIBSDownsamplingInfo2 == null) {
            throw new IllegalArgumentException("LIBSDownsamplingInfo cannot be null");
        }
        if (samples == null) {
            throw new IllegalArgumentException("samples must be a non-null list");
        }
        this.readsBySample = new LinkedHashMap<String, Downsampler<T>>(samples.size());
        for (String sample : samples) {
            this.readsBySample.put(sample, this.createDownsampler(LIBSDownsamplingInfo2));
        }
    }

    @Requires(value={"LIBSDownsamplingInfo != null"})
    @Ensures(value={"result != null"})
    private Downsampler<T> createDownsampler(LIBSDownsamplingInfo LIBSDownsamplingInfo2) {
        return LIBSDownsamplingInfo2.isPerformDownsampling() ? new ReservoirDownsampler(LIBSDownsamplingInfo2.getToCoverage(), true) : new PassThroughDownsampler();
    }

    @Requires(value={"read != null"})
    @Ensures(value={"doneSubmittingReads == false"})
    public void submitRead(T read) {
        String sampleName = read.getReadGroup() != null ? read.getReadGroup().getSample() : null;
        Downsampler<T> downsampler = this.readsBySample.get(sampleName);
        if (downsampler == null) {
            throw new IllegalStateException("Offered read with sample name " + sampleName + " to SamplePartitioner " + "but this sample wasn't provided as one of possible samples at construction");
        }
        downsampler.submit(read);
        this.doneSubmittingReads = false;
    }

    @Ensures(value={"doneSubmittingReads == true"})
    public void doneSubmittingReads() {
        for (Downsampler<T> downsampler : this.readsBySample.values()) {
            downsampler.signalEndOfInput();
        }
        this.doneSubmittingReads = true;
    }

    @Ensures(value={"result != null"})
    public Collection<T> getReadsForSample(String sampleName) {
        if (!this.doneSubmittingReads) {
            throw new IllegalStateException("getReadsForSample called before doneSubmittingReads was called");
        }
        Downsampler<T> downsampler = this.readsBySample.get(sampleName);
        if (downsampler == null) {
            throw new NoSuchElementException("Sample name not found");
        }
        return downsampler.consumeFinalizedItems();
    }

    @Ensures(value={"doneSubmittingReads == false"})
    public void reset() {
        for (Downsampler<T> downsampler : this.readsBySample.values()) {
            downsampler.clearItems();
            downsampler.resetStats();
        }
        this.doneSubmittingReads = false;
    }
}

