/*###############################################################################
# Linux Management Providers (LMP), BIOS provider package
# Copyright (C) 2010 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by <Author(s)>, <Affiliation>, <Year>
###############################################################################*/

#ifndef CMPIOPENDRIM_BIOSSERVICE_H_
#define CMPIOPENDRIM_BIOSSERVICE_H_

#include "OpenDRIM_BIOSService.h"

CMPIObjectPath* BIOS_OpenDRIM_BIOSService_toCMPIObjectPath(const CMPIBroker* broker, const OpenDRIM_BIOSService& instance);

CMPIInstance* BIOS_OpenDRIM_BIOSService_toCMPIInstance(const CMPIBroker* broker, const OpenDRIM_BIOSService& instance);

void BIOS_OpenDRIM_BIOSService_toCPP(const CMPIBroker* broker, const CMPIObjectPath* ref, OpenDRIM_BIOSService& instance);

void BIOS_OpenDRIM_BIOSService_toCPP(const CMPIBroker* broker, const CMPIInstance* ci, OpenDRIM_BIOSService& instance);

void BIOS_OpenDRIM_BIOSService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BIOSService_RequestStateChange_In& args);

void BIOS_OpenDRIM_BIOSService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BIOSService_RequestStateChange_Out& args);

void BIOS_OpenDRIM_BIOSService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BIOSService_SetBIOSAttribute_In& args);

void BIOS_OpenDRIM_BIOSService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BIOSService_SetBIOSAttribute_Out& args);

void BIOS_OpenDRIM_BIOSService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BIOSService_SetBIOSAttributeEmbeddedInstance_In& args);

void BIOS_OpenDRIM_BIOSService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BIOSService_SetBIOSAttributeEmbeddedInstance_Out& args);

void BIOS_OpenDRIM_BIOSService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BIOSService_ReadRawBIOSData_In& args);

void BIOS_OpenDRIM_BIOSService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BIOSService_ReadRawBIOSData_Out& args);

void BIOS_OpenDRIM_BIOSService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BIOSService_WriteRawBIOSData_In& args);

void BIOS_OpenDRIM_BIOSService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BIOSService_WriteRawBIOSData_Out& args);

void BIOS_OpenDRIM_BIOSService_toCPP(const CMPIBroker* broker, const CMPIArgs* in, OpenDRIM_BIOSService_SetBIOSAttributes_In& args);

void BIOS_OpenDRIM_BIOSService_toCMPIArg(const CMPIBroker* broker, CMPIArgs* out, const OpenDRIM_BIOSService_SetBIOSAttributes_Out& args);


#endif /*CMPIOPENDRIM_BIOSSERVICE_H_*/
