/*###############################################################################
# Linux Management Providers (LMP), IP provider package
# Copyright (C) 2007 Ilsoo Byun <widepis@etri.re.kr ,widepis@empal.com>
#
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
#
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#include "IP_Common.h"

int CF_getGatewayByInterface(vector<string>& gateway,vector<string>& interface,string& errorMessage)
{
	vector<string> lines;

	CF_assert(CF_runCommandToLines("route -n | grep UG",lines,0,errorMessage));


	gateway.clear();
	interface.clear();

	for(unsigned int i=0;i<lines.size();i++)
	{
		vector<string> elements;

		CF_splitTextBySpace(elements,lines[i]);

		if(elements.size()==8)
		{
			gateway.push_back(elements[1]);
			interface.push_back(elements[7]);
		}
	}

	return OK;
}

int CF_getIfEnabledState(const string& ifName, unsigned int& enabledState ,string& errorMessage)
{
	string value;
	string stderr;
	CF_assert( CF_runCommand("/sbin/ifconfig " + ifName, value, stderr, errorMessage));

	if(value.find("UP")!=string::npos)
	{
		if(value.find("RUNNING")!=string::npos)
			enabledState=ES_ENABLE;
		else
			enabledState=ES_ENABLED_OFFLINE;
	}
	else
		enabledState=ES_DISABLE;

	return OK;
}

int CF_getSubNetMask(const string& ethName, string& mask, string& errorMessage)
{
	string value;
	CF_assert( CF_runCommandFL("ifconfig "+ethName+" | awk '/HWaddr/{} /inet addr/{print $4}'", value, errorMessage) );
	mask = CF_trimText(value);
	if ( CF_startsWithNoCase(mask, "Mask:") )
		mask = mask.substr(5);
	return OK;
}

int CF_getDefaultGateway(const string& ethName, string& gateway, string& errorMessage)
{
	string std_out;
	string std_err;
	
	CF_assert(CF_runCommand("route -n | grep UG  | grep "+ethName+" | awk '{print $2}'", std_out, std_err, errorMessage));
	
	if(std_out!="")
	{
		gateway=std_out.substr(0, std_out.size()-1);
		return OK;
	}

	ifstream ifs;
	string device_path;
	string line;

	if (!CF_isExist(DEVICE_BASE_PATH))
	{
		device_path = DEBIAN_DEVICE_FILE;
		ifs.open(device_path.c_str(), ifstream::in);
  	
  	if(!ifs)
  	{
			errorMessage = "Cannot open file: "+device_path;
  		return FAILED;
		}
		
		while (getline(ifs, line))
		{
			vector<string> tokens;
			
			CF_splitText(tokens,line," ");
			
			if(tokens.size()>1 && tokens[1]==ethName && tokens[0]=="iface")
			{
				while(line!="")
				{
					getline(ifs, line);
					line=CF_trimText(line);
					CF_splitText(tokens,line," ");
					
					if(tokens[0]=="gateway")
					{
						gateway=tokens[1];
						ifs.close();
						return OK;
					}
				}
			}
							
		}
		ifs.close();
	}
	else
	{
		device_path = DEVICE_BASE_PATH+"ifcfg-"+ethName;
  	ifs.open(device_path.c_str(), ifstream::in);
  	
  	if(!ifs)
  	{
  		errorMessage = "Cannot open file: "+device_path;
  		return OK;
  	}
  	
  	while (getline(ifs, line))
  	{
  		int idx = line.find_first_of('=');
  		string name = CF_trimText(line.substr(0, idx));
  		string value = CF_trimText(line.substr(idx+1));

  		if (name == "GATEWAY")
  		{
  			gateway=value;
  			ifs.close();
  			return OK;
  		}
  		
  	}
  	ifs.close();
	}
	
	gateway="0.0.0.0";
	
	return OK;
}
