/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_RECORDLOGCONFORMSTOPROFILEACCESS_H_
#define OPENDRIM_RECORDLOGCONFORMSTOPROFILEACCESS_H_

#include "OpenDRIM_RecordLogPackage_Common.h"

#include "OpenDRIM_RecordLogConformsToProfile.h"
#include "assocOpenDRIM_RecordLogConformsToProfile.h"

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_load(const CMPIBroker* broker, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_unload(string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_retrieve(const CMPIBroker* broker, const CMPIContext* ctx, vector<OpenDRIM_RecordLogConformsToProfile>& instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_getInstance(const CMPIBroker* broker, const CMPIContext* ctx, OpenDRIM_RecordLogConformsToProfile& instance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_setInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogConformsToProfile& newInstance, const OpenDRIM_RecordLogConformsToProfile& oldInstance, const char** properties, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_createInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogConformsToProfile& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_deleteInstance(const CMPIBroker* broker, const CMPIContext* ctx, const OpenDRIM_RecordLogConformsToProfile& instance, string& errorMessage);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_associatorConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const char** properties, vector<Instance>& ManagedElement_associatedInstances, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_associatorManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const char** properties, vector<Instance>& ConformantStandard_associatedInstances, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_referenceConformantStandardToManagedElement(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ConformantStandard_instance, const vector<Instance>& ManagedElement_instances, vector<OpenDRIM_RecordLogConformsToProfile>& OpenDRIM_RecordLogConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_referenceManagedElementToConformantStandard(const CMPIBroker* broker, const CMPIContext* ctx, const Instance& ManagedElement_instance, const vector<Instance>& ConformantStandard_instances, vector<OpenDRIM_RecordLogConformsToProfile>& OpenDRIM_RecordLogConformsToProfile_instances, const char** properties, string& errorMessage, const string& discriminant);

int OpenDRIM_RecordLogPackage_OpenDRIM_RecordLogConformsToProfile_populate(OpenDRIM_RecordLogConformsToProfile& instance, string& errorMessage);

#endif /*OPENDRIM_RECORDLOGCONFORMSTOPROFILEACCESS_H_*/
