#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2022 Antoine Le Gonidec <vv221@dotslashplay.it>
# SPDX-FileCopyrightText: © 2022 Mopi
set -o errexit

###
# Shantae and the Pirate's Curse
# build native packages from the original installers
# send your bug reports to contact@dotslashplay.it
###

script_version=20220626.1

# Set game-specific variables

GAME_ID='shantae-and-the-pirates-curse'
GAME_NAME='Shantae and the Pirateʼs Curse'

ARCHIVE_BASE_0='setup_shantae_and_the_pirates_curse_1.04g_(18994).exe'
ARCHIVE_BASE_0_MD5='66e16f3a97328c2ba08c19a64d88c16c'
ARCHIVE_BASE_0_TYPE='innosetup'
ARCHIVE_BASE_0_SIZE='470000'
ARCHIVE_BASE_0_VERSION='1.04g-gog18994'
ARCHIVE_BASE_0_URL='https://www.gog.com/game/shantae_and_the_pirates_curse'

CONTENT_PATH_DEFAULT='app'
ARCHIVE_GAME_BIN_FILES='
shantae?and?the?pirate?s?curse.exe'
ARCHIVE_GAME_DATA_FILES='
shantaecurse.data'

APP_MAIN_TYPE='wine'
APP_MAIN_EXE="shantae and the pirate's curse.exe"
APP_MAIN_ICON="shantae and the pirate's curse.exe"

PACKAGES_LIST='PKG_BIN PKG_DATA'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

PKG_BIN_ARCH='32'
PKG_BIN_DEPS="$PKG_DATA_ID wine"

# Use persistent storage for user data

CONFIG_FILES='./options.txt'
DATA_FILES='./*.save'

# Load common functions

target_version='2.16'

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
. "$PLAYIT_LIB2"

# Extract game data

extract_data_from "$SOURCE_ARCHIVE"
prepare_package_layout

# Delete temporary files

rm --recursive "${PLAYIT_WORKDIR}/gamedata"

# Include game icons

PKG='PKG_BIN'
icons_get_from_package 'APP_MAIN'
icons_move_to 'PKG_DATA'

# Write launchers

PKG='PKG_BIN'
launchers_write 'APP_MAIN'

# Build package

write_metadata
build_pkg

# Clean up

rm --recursive "$PLAYIT_WORKDIR"

# Print instructions

print_instructions

exit 0
