!{\src2tex{textfont=tt}}
!!****f* ABINIT/prtrhomxmn
!! NAME
!! prtrhomxmn
!!
!! FUNCTION
!! If option==1, compute the maximum and minimum of the density (and spin-polarization
!! if nspden==2), and print it.
!! If option==2, also compute and print the second maximum or minimum
!!
!! COPYRIGHT
!! Copyright (C) 1998-2007 ABINIT group (DCA, XG, GMR)
!! This file is distributed under the terms of the
!! GNU General Public License, see ~abinit/COPYING
!! or http://www.gnu.org/copyleft/gpl.txt .
!!
!! INPUTS
!!  iout=unit for output file
!!  mpi_enreg=informations about MPI parallelization
!!  nfft=(effective) number of FFT grid points (for this processor)
!!  ngfft(18)=contain all needed information about 3D FFT, see ~abinit/doc/input_variables/vargs.htm#ngfft
!!  nspden=number of spin-density components
!!  option, see above
!!  rhor(nspden,nfft)=electron density (electrons/bohr^3)
!!
!! OUTPUT
!!
!! SIDE EFFECTS
!!
!! NOTES
!!  The tolerance tol12 aims at giving a machine-independent ordering.
!!  (this trick is used in bonds.f, listkk.f, prtrhomxmn.f and rsiaf9.f)
!!
!! PARENTS
!!      clnup1,mkrho,vtorho
!!
!! CHILDREN
!!      leave_new,wrtout,xcomm_init,xmaster_init_fft,xmax_mpi,xmin_mpi
!!
!! SOURCE

#if defined HAVE_CONFIG_H
#include "config.h"
#endif

subroutine prtrhomxmn(iout,mpi_enreg,nfft,ngfft,nspden,option,rhor)

 use defs_basis
 use defs_datatypes

!This section has been created automatically by the script Abilint (TD). Do not modify these by hand.
#ifdef HAVE_FORTRAN_INTERFACES
 use interfaces_01manage_mpi
 use interfaces_lib01hidempi
#else
 use defs_xfuncmpi
#endif
!End of the abilint section

 implicit none

!Arguments ------------------------------------
!scalars
 integer,intent(in) :: iout,nfft,nspden,option
 type(MPI_type),intent(inout) :: mpi_enreg
!arrays
 integer,intent(in) :: ngfft(18)
 real(dp),intent(in) :: rhor(nfft,nspden)

!Local variables-------------------------------
!scalars
 integer :: i1,i2,i3,ierr,ifft,imn1,imn2,imx1,imx2,ispden,master,n1,n2,n3
 integer :: old_paral_level,resulti,spaceComm
 real(dp) :: resultr,rhomn,rhomn1,rhomn2,rhomx,rhomx1,rhomx2,zeta,zetmn1,zetmn2
 real(dp) :: zetmx1,zetmx2
 character(len=500) :: message

! *************************************************************************

!DEBUG
!write(6,*) ' rhommxmn : enter '
!write(6,*) ' nspden, rhor(1,1), rhor(1,2) ',nspden,rhor(1,1), rhor(1,2)
!ENDDEBUG
 if(option/=1 .and. option/=2)then
  write(message, '(a,a,a,a,i8,a)' ) ch10,&
&  ' prtrhomxmn : BUG -',ch10,&
&  '  Option must be 1 or 2, while it is',option,'.'
  call wrtout(6,message,'COLL')
  call leave_new('COLL')
 end if

!XG030920 : MPIWF
!One has to determine the maximum and minimum (etc...) values
!over all space, and then output it, as well as to identify
!the point at which it occurs ...
!This will require a bit of data exchange, and correct indirect indexing ...

 n1=ngfft(1) ; n2=ngfft(2) ; n3=ngfft(3)

!Find maximum and minimum total electron density and locations
!also keep the second maximal or minimal value
 rhomx1=rhor(1,1) ; imx1=1
 rhomn1=rhor(1,1) ; imn1=1
 if (rhor(2,1)+tol12>rhomx1) then
  rhomx2=rhomx1 ; imx2=imx1
  rhomx1=rhor(2,1) ; imx1=2
 else
  rhomx2=rhor(2,1) ; imx2=2
 end if
 if (rhor(2,1)+tol12<rhomn1) then
  rhomn2=rhomn1 ; imn2=imn1
  rhomn1=rhor(2,1) ; imn1=2
 else
  rhomn2=rhor(2,1) ; imn2=2
 end if
 do ifft=3,nfft
  if (rhor(ifft,1)+tol12>rhomx2) then
   if (rhor(ifft,1)+tol12>rhomx1) then
    rhomx2=rhomx1 ; imx2=imx1
    rhomx1=rhor(ifft,1) ; imx1=ifft
   else
    rhomx2=rhor(ifft,1) ; imx2=ifft
   end if
  end if
  if (rhor(ifft,1)+tol12<rhomn2) then
   if (rhor(ifft,1)+tol12<rhomn1) then
    rhomn2=rhomn1 ; imn2=imn1
    rhomn1=rhor(ifft,1) ; imn1=ifft
   else
    rhomn2=rhor(ifft,1) ; imn2=ifft
   end if
  end if
 end do

 if (mpi_enreg%paral_fft == 1) then
    old_paral_level=mpi_enreg%paral_level
    mpi_enreg%paral_level=3
    call xcomm_init(mpi_enreg,spaceComm)
    if(mpi_enreg%mode_para=='b') spaceComm=mpi_enreg%comm_fft
    call xmax_mpi(rhomx1,resultr,spaceComm,ierr)
    rhomx1=resultr
    call xmax_mpi(imx1,resulti,spaceComm,ierr)
    imx1=resulti
    call xmin_mpi(rhomn1,resultr,spaceComm,ierr)
    rhomn1=resultr
    call xmin_mpi(imn1,resulti,spaceComm,ierr)
    imn1=resulti
    call xmax_mpi(rhomx2,resultr,spaceComm,ierr)
    rhomx2=resultr
    call xmax_mpi(imx2,resulti,spaceComm,ierr)
    imx2=resulti
    call xmin_mpi(rhomn2,resultr,spaceComm,ierr)
    rhomn2=resultr
    call xmin_mpi(imn2,resulti,spaceComm,ierr)
    imn2=resulti
    mpi_enreg%paral_level=old_paral_level
 end if
 call xmaster_init_fft(mpi_enreg,master)

 if (mpi_enreg%me==master) then
!Print minimal electronic density
 i3=(imn1-1)/n1/n2
 i2=(imn1-1-i3*n1*n2)/n1
 i1=imn1-1-i3*n1*n2-i2*n1
 write(message, '(a,a,1p,e12.4,a,0p,3f8.4)' ) ch10,&
&  ',Min el dens=',rhomn1,&
&  ' el/bohr^3 at reduced coord.',dble(i1)/dble(n1)+tol12,&
&  dble(i2)/dble(n2)+tol12,dble(i3)/dble(n3)+tol12
 call wrtout(iout,message,'COLL')

!Print second minimal electronic density
 if(option==2)then
  i3=(imn2-1)/n1/n2
  i2=(imn2-1-i3*n1*n2)/n1
  i1=imn2-1-i3*n1*n2-i2*n1
  write(message, '(a,1p,e12.4,a,0p,3f8.4)' ) &
&  ',   next min=',rhomn2,&
&  ' el/bohr^3 at reduced coord.',dble(i1)/dble(n1)+tol12,&
&  dble(i2)/dble(n2)+tol12,dble(i3)/dble(n3)+tol12
  call wrtout(iout,message,'COLL')
 end if

!Print maximal electronic density
 i3=(imx1-1)/n1/n2
 i2=(imx1-1-i3*n1*n2)/n1
 i1=imx1-1-i3*n1*n2-i2*n1
 write(message, '(a,1p,e12.4,a,0p,3f8.4)' )&
&  ',Max el dens=',rhomx1,&
&  ' el/bohr^3 at reduced coord.',dble(i1)/dble(n1)+tol12,&
&  dble(i2)/dble(n2)+tol12,dble(i3)/dble(n3)+tol12
 call wrtout(iout,message,'COLL')

!Print second maximal electronic density
 if(option==2)then
  i3=(imx2-1)/n1/n2
  i2=(imx2-1-i3*n1*n2)/n1
  i1=imx2-1-i3*n1*n2-i2*n1
  write(message, '(a,1p,e12.4,a,0p,3f8.4)' )&
&  ',   next max=',rhomx2,&
&  ' el/bohr^3 at reduced coord.',dble(i1)/dble(n1)+tol12,&
&  dble(i2)/dble(n2)+tol12,dble(i3)/dble(n3)+tol12
  call wrtout(iout,message,'COLL')
 end if
 end if

!If spin-polarized, compute min and max spin polarization
 if (nspden>=2) then
  if(nspden==2) then
   zeta=two*rhor(1,2)/rhor(1,1)-one
  else if(nspden==4) then
   zeta=sqrt(rhor(1,2)**2+rhor(1,3)**2+rhor(1,4)**2)/rhor(1,1)
  end if
  zetmx1=zeta ; imx1=1
  zetmn1=zeta ; imn1=1
  if(nspden==2) then
   zeta=two*rhor(2,2)/rhor(2,1)-one
  else if(nspden==4) then
   zeta=sqrt(rhor(2,2)**2+rhor(2,3)**2+rhor(2,4)**2)/rhor(2,1)
  end if
  if (zeta+tol12>zetmx1) then
   zetmx2=zetmx1 ; imx2=imx1
   zetmx1=zeta   ; imx1=2
  else
   zetmx2=zeta ; imx2=2
  end if
  if (zeta+tol12<zetmn1) then
   zetmn2=zetmn1 ; imn2=imn1
   zetmn1=zeta ; imn1=2
  else
   zetmn2=zeta ; imn2=2
  end if
  do ifft=3,nfft
   if(nspden==2) then
    zeta=two*rhor(ifft,2)/rhor(ifft,1)-one
   else if(nspden==4) then
    zeta=sqrt(rhor(ifft,2)**2+rhor(ifft,3)**2+rhor(ifft,4)**2)/rhor(ifft,1)
   end if
   if (zeta+tol12>zetmx2) then
    if (zeta+tol12>zetmx1) then
     zetmx2=zetmx1 ; imx2=imx1
     zetmx1=zeta ; imx1=ifft
    else
     zetmx2=zeta ; imx2=ifft
    end if
   end if
   if (zeta+tol12<zetmn2) then
    if (zeta+tol12<zetmn1) then
     zetmn2=zetmn1 ; imn2=imn1
     zetmn1=zeta ; imn1=ifft
    else
     zetmn2=zeta ; imn2=ifft
    end if
   end if
  end do

 if (mpi_enreg%paral_fft == 1) then
    old_paral_level=mpi_enreg%paral_level
    mpi_enreg%paral_level=3
    call xcomm_init(mpi_enreg,spaceComm)
    if(mpi_enreg%mode_para=='b') spaceComm=mpi_enreg%comm_fft
    call xmax_mpi(zetmx1,resultr,spaceComm,ierr)
    zetmx1=resultr
    call xmax_mpi(imx1,resulti,spaceComm,ierr)
    imx1=resulti
    call xmin_mpi(zetmn1,resultr,spaceComm,ierr)
    zetmn1=resultr
    call xmin_mpi(imn1,resulti,spaceComm,ierr)
    imn1=resulti
    call xmax_mpi(zetmx2,resultr,spaceComm,ierr)
    zetmx2=resultr
    call xmax_mpi(imx2,resulti,spaceComm,ierr)
    imx2=resulti
    call xmin_mpi(zetmn2,resultr,spaceComm,ierr)
    zetmn2=resultr
    call xmin_mpi(imn2,resulti,spaceComm,ierr)
    imn2=resulti
    mpi_enreg%paral_level=old_paral_level
 end if

  if (mpi_enreg%me==master) then
!Print minimal spin-polarization
  i3=(imn1-1)/n1/n2
  i2=(imn1-1-i3*n1*n2)/n1
  i1=imn1-1-i3*n1*n2-i2*n1
  write(message, '(a,a,1p,e12.4,a,0p,3f8.4)' ) ch10,&
&   ',Min spin pol zeta=',zetmn1,&
&   ' at reduced coord.',dble(i1)/dble(n1)+tol12,&
&    dble(i2)/dble(n2)+tol12,dble(i3)/dble(n3)+tol12
  call wrtout(iout,message,'COLL')

!Print second minimal spin-polarization
  if(option==2)then
   i3=(imn2-1)/n1/n2
   i2=(imn2-1-i3*n1*n2)/n1
   i1=imn2-1-i3*n1*n2-i2*n1
   write(message, '(a,1p,e12.4,a,0p,3f8.4)' )&
&   ',         next min=',zetmn2,&
&   ' at reduced coord.',dble(i1)/dble(n1)+tol12,&
&    dble(i2)/dble(n2)+tol12,dble(i3)/dble(n3)+tol12
   call wrtout(iout,message,'COLL')
  end if

!Print maximal spin-polarization
  i3=(imx1-1)/n1/n2
  i2=(imx1-1-i3*n1*n2)/n1
  i1=imx1-1-i3*n1*n2-i2*n1
  write(message, '(a,1p,e12.4,a,0p,3f8.4)' )&
&   ',Max spin pol zeta=',zetmx1,&
&   ' at reduced coord.',dble(i1)/dble(n1)+tol12,&
&    dble(i2)/dble(n2)+tol12,dble(i3)/dble(n3)+tol12
  call wrtout(iout,message,'COLL')

!Print second maximal spin-polarization
  if(option==2)then
   i3=(imx2-1)/n1/n2
   i2=(imx2-1-i3*n1*n2)/n1
   i1=imx2-1-i3*n1*n2-i2*n1
   write(message, '(a,1p,e12.4,a,0p,3f8.4)' )&
&   ',         next max=',zetmx2,&
&   ' at reduced coord.',dble(i1)/dble(n1)+tol12,&
&    dble(i2)/dble(n2)+tol12,dble(i3)/dble(n3)+tol12
   call wrtout(iout,message,'COLL')
  end if
 end if
!End condition on spin-polarization
 end if

!DEBUG
!rewind(45)
!write(45,*) n1/3,n2/3,n3/3
!do ifft=1,nfft
! i3=(ifft-1)/n1/n2
! i2=(ifft-1-i3*n1*n2)/n1
! i1=ifft-1-i3*n1*n2-i2*n1
! if(mod(i1,3)==0 .and. mod(i2,3)==0 .and. mod(i3,3)==0) then
!   write(45,'(3f8.4)')rhor(ifft,2),rhor(ifft,3),rhor(ifft,4)
!   write(45,'(f8.4)')sqrt(rhor(ifft,2)**2+rhor(ifft,3)**2+&
!&                     rhor(ifft,4)**2)
!   write(46,'(f8.4)')rhor(ifft,1)
!  write(45,'(3f8.4)')rhor(ifft,2),rhor(ifft,3),rhor(ifft,4)
! end if
!end do
!ENDDEBUG

end subroutine prtrhomxmn
!!***
