------------------------------------------------------------------------------
--                                                                          --
--                            GNATPP COMPONENTS                             --
--                                                                          --
--                     G N A T P P . U T I L I T I E S                      --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 15267 $
--                                                                          --
--                   Copyright (C) 2001-2002, ACT Europe                    --
--                                                                          --
-- GNATPP is free software; you can redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNATPP is  distributed in the  hope that it will  be  useful, but --
-- WITHOUT ANY WARRANTY; without even the implied warranty of  MERCHANTABI- --
-- LITY or  FITNESS  FOR A  PARTICULAR  PURPOSE. See the GNU General Public --
-- License  for more details. You  should  have  received a copy of the GNU --
-- General Public License  distributed with GNAT; see file COPYING. If not, --
-- write  to  the Free  Software  Foundation,  59 Temple Place - Suite 330, --
-- Boston,                                                                  --
--                                                                          --
-- GNATPP is maintained by ACT Europe (http://www.act-europe.fr).           --
--                                                                          --
------------------------------------------------------------------------------

--  This package defines various non-ASIS utility programs.

with Asis;           use Asis;

with GNATPP.Common;  use GNATPP.Common;
with GNATPP.Options; use GNATPP.Options;

package GNATPP.Utilities is

   function Capitalize
     (Name   : Element;
      Casing : PP_Casing)
      return   Program_Text;
   --  This function returns the casing for the Name to be printed out into
   --  the output source. Note, that for the situation when we have to get
   --  As_Declared casing for a reference, we have to pass as the actual for
   --  the Name parameter the corresponding defining name.
   --
   --  This function usually works with simple names. It can also work with
   --  expanded defining names, but it can be the case only when we have to
   --  prnint the unit name after the last 'end', and this unit is a child
   --  unit.
   --
   --  This function uses the dictionary settings to deal with casing
   --  exceptions.

   function Capitalize_Image
     (Name   : Program_Text;
      Casing : PP_Casing)
      return   Program_Text;
   --  This function is similar to the previous one, but it accepts the string
   --  image of the name to capitalize. Is used for operation signs.
   --  ???
   --  Note, that using this function for the parent unit name image in case
   --  of a subunit is a temporary solution which can not work in some cases!
   --  We definitely need a proper solution here!!!!!

   function KW_Length (KW : Keyword_Kinds) return Natural;
   --  Computes the length needed for the argument keyword

end GNATPP.Utilities;
