// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/MemPool.h"
#include <stdlib.h>
#include <assert.h>
#include <iostream>
#include <set>
using namespace std;

namespace Puma {


MemPool::MemPool (unsigned long blocksize) {
  block   = (Link*)0;
  size    = 0L;
  used    = 0L;
  defsize = blocksize;
  grow (defsize);
}


MemPool::~MemPool () {
  //cerr << "last == count: " << lastcount << endl;          
  //cerr << "recycled: " << recyclecount << "( " << recyclesize << " bytes )"<< endl;
  //free ();
}


unsigned long MemPool::align (unsigned long size) {
  return (size + alignment - 1L) & ~(alignment - 1L);
}


void MemPool::grow (unsigned long blocksize) {
  Link *head = block;

  used  = align ((unsigned long)sizeof (Link));
  size  = blocksize + used;
  block = (Link*)/*Heap*/::malloc (size);
  block->next = head;
  //cout << "New Page at " << block << endl;
}


void *MemPool::alloc (unsigned long objectsize) {
  void *objectptr;

  objectsize = align (objectsize);

  if (used + objectsize > size)
    grow (objectsize > defsize ? objectsize : defsize);

  objectptr = (void*)((char*)block + used);
  used += objectsize;

  return objectptr; 
}


void MemPool::dealloc (void *) {
}


void MemPool::free () {
  Link *curr = block;
  Link *next;

  while (curr) {
    next = curr->next;
    /*Heap*/::free (curr);
    curr = next;
  }
}


} // namespace Puma
