BEGIN;

CREATE TABLE NDMPJobEnvironment (
    JobId integer NOT NULL,
    FileIndex INTEGER UNSIGNED NOT NULL,
    EnvName TEXT NOT NULL,
    EnvValue TEXT NOT NULL,
    CONSTRAINT NDMPJobEnvironment_pkey PRIMARY KEY (JobId, FileIndex, EnvName)
);

CREATE TABLE DeviceStats (
   SampleTime DATETIME NOT NULL,
   ReadTime BIGINT UNSIGNED DEFAULT 0,
   WriteTime BIGINT UNSIGNED DEFAULT 0,
   ReadBytes BIGINT UNSIGNED DEFAULT 0,
   WriteBytes BIGINT UNSIGNED DEFAULT 0,
   Spool INTEGER UNSIGNED DEFAULT 0,
   Waiting INTEGER DEFAULT 0,
   Writers INTEGER DEFAULT 0,
   MediaId INTEGER UNSIGNED REFERENCES Media DEFAULT 0,
   VolCatBytes BIGINT UNSIGNED DEFAULT 0,
   VolCatFiles BIGINT UNSIGNED DEFAULT 0,
   VolCatBlocks BIGINT UNSIGNED DEFAULT 0
);

CREATE TABLE JobStats (
   SampleTime DATETIME NOT NULL,
   JobId INTEGER UNSIGNED REFERENCES Job NOT NULL,
   JobFiles INTEGER UNSIGNED DEFAULT 0,
   JobBytes BIGINT UNSIGNED DEFAULT 0
);

ALTER TABLE Media ADD COLUMN MinBlockSize INTEGER UNSIGNED DEFAULT 0;
ALTER TABLE Media ADD COLUMN MaxBlockSize INTEGER UNSIGNED DEFAULT 0;

ALTER TABLE Pool ADD COLUMN MinBlockSize INTEGER UNSIGNED DEFAULT 0;
ALTER TABLE Pool ADD COLUMN MaxBlockSize INTEGER UNSIGNED DEFAULT 0;

UPDATE Version SET VersionId = 2002;
COMMIT;
