package hid

import (
	"sort"
)

type KeyMap map[string]Command

var BaseMap = KeyMap{
	"":            Command{},
	"CTRL":        Command{Mode: 1},
	"SHIFT":       Command{Mode: 2},
	"ALT":         Command{Mode: 4},
	"GUI":         Command{Mode: 8},
	"ENTER":       Command{HID: 40},
	"ESCAPE":      Command{HID: 41},
	"DELETE":      Command{HID: 42},
	"TAB":         Command{HID: 43},
	"SPACE":       Command{HID: 44},
	"CAPSLOCK":    Command{HID: 57},
	"F1":          Command{HID: 58},
	"F2":          Command{HID: 59},
	"F3":          Command{HID: 60},
	"F4":          Command{HID: 61},
	"F5":          Command{HID: 62},
	"F6":          Command{HID: 63},
	"F7":          Command{HID: 64},
	"F8":          Command{HID: 65},
	"F9":          Command{HID: 66},
	"F10":         Command{HID: 67},
	"F11":         Command{HID: 68},
	"F12":         Command{HID: 69},
	"PRINTSCREEN": Command{HID: 70},
	"SCROLLLOCK":  Command{HID: 71},
	"PAUSE":       Command{HID: 72},
	"INSERT":      Command{HID: 73},
	"HOME":        Command{HID: 74},
	"PAGEUP":      Command{HID: 75},
	"DEL":         Command{HID: 76},
	"END":         Command{HID: 77},
	"PAGEDOWN":    Command{HID: 78},
	"RIGHT":       Command{HID: 79},
	"LEFT":        Command{HID: 80},
	"DOWN":        Command{HID: 81},
	"UP":          Command{HID: 82},
	"MENU":        Command{HID: 101},
}

var KeyMaps = map[string]KeyMap{
	"BE": {
		" ":         Command{HID: 44},
		"$":         Command{HID: 48},
		"(":         Command{HID: 34},
		",":         Command{HID: 16},
		"0":         Command{HID: 39, Mode: 2},
		"4":         Command{HID: 33, Mode: 2},
		"8":         Command{HID: 37, Mode: 2},
		"<":         Command{HID: 100},
		"@":         Command{HID: 31, Mode: 64},
		"€":         Command{HID: 8, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"§":         Command{HID: 35},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 100, Mode: 64},
		"`":         Command{HID: 49, Mode: 64},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"£":         Command{HID: 49, Mode: 2},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 30, Mode: 64},
		"BACKSPACE": Command{HID: 42},
		"#":         Command{HID: 32, Mode: 64},
		"'":         Command{HID: 33},
		"+":         Command{HID: 56, Mode: 2},
		"/":         Command{HID: 55, Mode: 2},
		"3":         Command{HID: 32, Mode: 2},
		"7":         Command{HID: 36, Mode: 2},
		";":         Command{HID: 54},
		"?":         Command{HID: 16, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"³":         Command{HID: 53, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"è":         Command{HID: 36},
		"W":         Command{HID: 29, Mode: 2},
		"[":         Command{HID: 48, Mode: 64},
		"_":         Command{HID: 46, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 29},
		"{":         Command{HID: 38, Mode: 64},
		"à":         Command{HID: 39},
		"é":         Command{HID: 31},
		"\"":        Command{HID: 32},
		"&":         Command{HID: 30},
		"*":         Command{HID: 48, Mode: 2},
		"ç":         Command{HID: 38},
		".":         Command{HID: 54, Mode: 2},
		"ù":         Command{HID: 52},
		"2":         Command{HID: 31, Mode: 2},
		"6":         Command{HID: 35, Mode: 2},
		":":         Command{HID: 55},
		">":         Command{HID: 100, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 26, Mode: 2},
		"^":         Command{HID: 35, Mode: 64},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"n":         Command{HID: 17},
		"µ":         Command{HID: 49},
		"r":         Command{HID: 21},
		"°":         Command{HID: 45, Mode: 2},
		"²":         Command{HID: 53},
		"v":         Command{HID: 25},
		"z":         Command{HID: 26},
		"~":         Command{HID: 56, Mode: 64},
		"!":         Command{HID: 37},
		"%":         Command{HID: 52, Mode: 2},
		")":         Command{HID: 45},
		"-":         Command{HID: 46},
		"1":         Command{HID: 30, Mode: 2},
		"5":         Command{HID: 34, Mode: 2},
		"9":         Command{HID: 38, Mode: 2},
		"=":         Command{HID: 56},
		"A":         Command{HID: 20, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 51, Mode: 2},
		"Q":         Command{HID: 4, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 47, Mode: 64},
		"a":         Command{HID: 20},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 51},
		"q":         Command{HID: 4},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 39, Mode: 64},
	},
	"FR": {
		" ":         Command{HID: 44},
		"$":         Command{HID: 48},
		"(":         Command{HID: 34},
		",":         Command{HID: 16},
		"0":         Command{HID: 39, Mode: 2},
		"4":         Command{HID: 33, Mode: 2},
		"8":         Command{HID: 37, Mode: 2},
		"<":         Command{HID: 100},
		"@":         Command{HID: 39, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 37, Mode: 64},
		"`":         Command{HID: 36, Mode: 64},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 35, Mode: 64},
		"BACKSPACE": Command{HID: 42},
		"#":         Command{HID: 32, Mode: 64},
		"'":         Command{HID: 33},
		"+":         Command{HID: 46, Mode: 2},
		"/":         Command{HID: 55, Mode: 2},
		"3":         Command{HID: 32, Mode: 2},
		"7":         Command{HID: 36, Mode: 2},
		";":         Command{HID: 54},
		"?":         Command{HID: 16, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 29, Mode: 2},
		"[":         Command{HID: 34, Mode: 64},
		"_":         Command{HID: 37},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 29},
		"{":         Command{HID: 33, Mode: 64},
		"\"":        Command{HID: 32},
		"&":         Command{HID: 30},
		"*":         Command{HID: 49},
		".":         Command{HID: 54, Mode: 2},
		"2":         Command{HID: 31, Mode: 2},
		"6":         Command{HID: 35, Mode: 2},
		":":         Command{HID: 55},
		">":         Command{HID: 100, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 26, Mode: 2},
		"^":         Command{HID: 38, Mode: 64},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"n":         Command{HID: 17},
		"r":         Command{HID: 21},
		"v":         Command{HID: 25},
		"z":         Command{HID: 26},
		"~":         Command{HID: 31, Mode: 64},
		"!":         Command{HID: 56},
		"%":         Command{HID: 52, Mode: 2},
		")":         Command{HID: 45},
		"-":         Command{HID: 35},
		"1":         Command{HID: 30, Mode: 2},
		"5":         Command{HID: 34, Mode: 2},
		"9":         Command{HID: 38, Mode: 2},
		"=":         Command{HID: 46},
		"A":         Command{HID: 20, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 51, Mode: 2},
		"Q":         Command{HID: 4, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 45, Mode: 64},
		"a":         Command{HID: 20},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 51},
		"q":         Command{HID: 4},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 46, Mode: 64},
	},
	"CH": {
		" ":         Command{HID: 44},
		"$":         Command{HID: 49},
		"(":         Command{HID: 37, Mode: 2},
		",":         Command{HID: 54},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 100},
		"@":         Command{HID: 31, Mode: 64},
		"€":         Command{HID: 8, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"§":         Command{HID: 53},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 100, Mode: 64},
		"`":         Command{HID: 46, Mode: 2},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 36, Mode: 64},
		"BACKSPACE": Command{HID: 42},
		"#":         Command{HID: 32, Mode: 64},
		"'":         Command{HID: 45},
		"+":         Command{HID: 30, Mode: 2},
		"/":         Command{HID: 36, Mode: 2},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 54, Mode: 2},
		"?":         Command{HID: 45, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 47, Mode: 64},
		"_":         Command{HID: 56, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 53, Mode: 64},
		"Ä":         Command{HID: 52, Mode: 2},
		"ß":         Command{HID: 45},
		"Ü":         Command{HID: 47, Mode: 2},
		"ä":         Command{HID: 52},
		"Ö":         Command{HID: 51, Mode: 2},
		"\"":        Command{HID: 31, Mode: 2},
		"&":         Command{HID: 35, Mode: 2},
		"*":         Command{HID: 32, Mode: 2},
		".":         Command{HID: 55},
		"2":         Command{HID: 31},
		"6":         Command{HID: 35},
		":":         Command{HID: 55, Mode: 2},
		"ö":         Command{HID: 51},
		">":         Command{HID: 100, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 28, Mode: 2},
		"^":         Command{HID: 46},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"n":         Command{HID: 17},
		"r":         Command{HID: 21},
		"°":         Command{HID: 53, Mode: 2},
		"v":         Command{HID: 25},
		"z":         Command{HID: 28},
		"~":         Command{HID: 46, Mode: 64},
		"ü":         Command{HID: 47},
		"!":         Command{HID: 48, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 38, Mode: 2},
		"-":         Command{HID: 56},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 39, Mode: 2},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 29, Mode: 2},
		"]":         Command{HID: 48, Mode: 64},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 29},
		"}":         Command{HID: 49, Mode: 64},
	},
	"DK": {
		"ð":         Command{HID: 7, Mode: 64},
		" ":         Command{HID: 44},
		"$":         Command{HID: 33, Mode: 64},
		"(":         Command{HID: 37, Mode: 2},
		",":         Command{HID: 54},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 100},
		"@":         Command{HID: 31, Mode: 64},
		"€":         Command{HID: 8, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"§":         Command{HID: 53, Mode: 2},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 100, Mode: 64},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"£":         Command{HID: 32, Mode: 64},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 46, Mode: 64},
		"BACKSPACE": Command{HID: 42},
		"«":         Command{HID: 33},
		"#":         Command{HID: 32, Mode: 2},
		"'":         Command{HID: 49},
		"+":         Command{HID: 45},
		"/":         Command{HID: 36, Mode: 2},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 54, Mode: 2},
		"?":         Command{HID: 45, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 37, Mode: 64},
		"_":         Command{HID: 56, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 36, Mode: 64},
		"Æ":         Command{HID: 51, Mode: 2},
		"Å":         Command{HID: 47, Mode: 2},
		"Ø":         Command{HID: 52, Mode: 2},
		"ß":         Command{HID: 22, Mode: 64},
		"ø":         Command{HID: 52},
		"\"":        Command{HID: 31, Mode: 2},
		"&":         Command{HID: 35, Mode: 2},
		"*":         Command{HID: 49, Mode: 2},
		"æ":         Command{HID: 51},
		"å":         Command{HID: 47},
		".":         Command{HID: 55},
		"2":         Command{HID: 31},
		"þ":         Command{HID: 23, Mode: 64},
		"6":         Command{HID: 35},
		":":         Command{HID: 55, Mode: 2},
		">":         Command{HID: 100, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 29, Mode: 2},
		"¤":         Command{HID: 33, Mode: 2},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"¨":         Command{},
		"n":         Command{HID: 17},
		"´":         Command{},
		"µ":         Command{HID: 16, Mode: 64},
		"r":         Command{HID: 21},
		"v":         Command{HID: 25},
		"½":         Command{HID: 53},
		"z":         Command{HID: 29},
		"~":         Command{HID: 48, Mode: 64},
		"!":         Command{HID: 30, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 38, Mode: 2},
		"-":         Command{HID: 56},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 39, Mode: 2},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 38, Mode: 64},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 39, Mode: 64},
	},
	"PT": {
		" ":         Command{HID: 44},
		"$":         Command{HID: 33, Mode: 2},
		"(":         Command{HID: 37, Mode: 2},
		",":         Command{HID: 54},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 100},
		"@":         Command{HID: 31, Mode: 64},
		"€":         Command{HID: 8, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"§":         Command{HID: 33, Mode: 64},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 53},
		"`":         Command{HID: 48, Mode: 2},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"£":         Command{HID: 32, Mode: 64},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 53, Mode: 2},
		"BACKSPACE": Command{HID: 42},
		"«":         Command{HID: 46},
		"#":         Command{HID: 32, Mode: 2},
		"'":         Command{HID: 45},
		"+":         Command{HID: 47},
		"/":         Command{HID: 36, Mode: 2},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 54, Mode: 2},
		"?":         Command{HID: 45, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 37, Mode: 64},
		"_":         Command{HID: 56, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 36, Mode: 64},
		"»":         Command{HID: 46, Mode: 2},
		"Ç":         Command{HID: 51, Mode: 2},
		"\"":        Command{HID: 31, Mode: 2},
		"&":         Command{HID: 35, Mode: 2},
		"*":         Command{HID: 47, Mode: 2},
		"ç":         Command{HID: 51},
		".":         Command{HID: 55},
		"2":         Command{HID: 31},
		"6":         Command{HID: 35},
		":":         Command{HID: 55, Mode: 2},
		">":         Command{HID: 100, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 29, Mode: 2},
		"^":         Command{HID: 50, Mode: 2},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"ª":         Command{HID: 52, Mode: 2},
		"n":         Command{HID: 17},
		"r":         Command{HID: 21},
		"v":         Command{HID: 25},
		"z":         Command{HID: 29},
		"º":         Command{HID: 52},
		"~":         Command{HID: 50},
		"!":         Command{HID: 30, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 38, Mode: 2},
		"-":         Command{HID: 56},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 39, Mode: 2},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 38, Mode: 64},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 39, Mode: 64},
	},
	"NO": {
		"ð":         Command{HID: 7, Mode: 64},
		" ":         Command{HID: 44},
		"$":         Command{HID: 33, Mode: 64},
		"(":         Command{HID: 37, Mode: 2},
		",":         Command{HID: 54},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 100},
		"@":         Command{HID: 31, Mode: 64},
		"€":         Command{HID: 8, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"§":         Command{HID: 53, Mode: 2},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 46},
		"`":         Command{HID: 46, Mode: 2},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"£":         Command{HID: 32, Mode: 64},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 53},
		"BACKSPACE": Command{HID: 42},
		"«":         Command{HID: 33},
		"#":         Command{HID: 32, Mode: 2},
		"'":         Command{HID: 49},
		"+":         Command{HID: 45},
		"/":         Command{HID: 36, Mode: 2},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 54, Mode: 2},
		"?":         Command{HID: 45, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 37, Mode: 64},
		"_":         Command{HID: 56, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 36, Mode: 64},
		"Æ":         Command{HID: 52, Mode: 2},
		"Å":         Command{HID: 47, Mode: 2},
		"Ø":         Command{HID: 51, Mode: 2},
		"ß":         Command{HID: 22, Mode: 64},
		"ø":         Command{HID: 51},
		"\"":        Command{HID: 31, Mode: 2},
		"&":         Command{HID: 35, Mode: 2},
		"*":         Command{HID: 49, Mode: 2},
		"æ":         Command{HID: 52},
		"å":         Command{HID: 47},
		".":         Command{HID: 55},
		"2":         Command{HID: 31},
		"þ":         Command{HID: 23, Mode: 64},
		"6":         Command{HID: 35},
		":":         Command{HID: 55, Mode: 2},
		">":         Command{HID: 100, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 29, Mode: 2},
		"^":         Command{HID: 48, Mode: 2},
		"¤":         Command{HID: 33, Mode: 2},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"n":         Command{HID: 17},
		"µ":         Command{HID: 16, Mode: 64},
		"r":         Command{HID: 21},
		"v":         Command{HID: 25},
		"½":         Command{HID: 53},
		"z":         Command{HID: 29},
		"~":         Command{HID: 48, Mode: 64},
		"!":         Command{HID: 30, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 38, Mode: 2},
		"-":         Command{HID: 56},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 39, Mode: 2},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 38, Mode: 64},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 39, Mode: 64},
	},
	"HR": {
		"-":  Command{HID: 56},
		" ":  Command{HID: 44},
		"$":  Command{HID: 33, Mode: 2},
		"(":  Command{HID: 37, Mode: 2},
		",":  Command{HID: 54},
		"0":  Command{HID: 39},
		"4":  Command{HID: 33},
		"8":  Command{HID: 37},
		"<":  Command{HID: 100},
		"@":  Command{HID: 25, Mode: 64},
		"€":  Command{HID: 8, Mode: 64},
		"D":  Command{HID: 7, Mode: 2},
		"H":  Command{HID: 11, Mode: 2},
		"L":  Command{HID: 15, Mode: 2},
		"P":  Command{HID: 19, Mode: 2},
		"§":  Command{HID: 16, Mode: 64},
		"T":  Command{HID: 23, Mode: 2},
		"X":  Command{HID: 27, Mode: 2},
		"\\": Command{HID: 20, Mode: 64},
		"`":  Command{HID: 36, Mode: 64},
		"d":  Command{HID: 7},
		"h":  Command{HID: 11},
		"l":  Command{HID: 15},
		"p":  Command{HID: 19},
		"t":  Command{HID: 23},
		"x":  Command{HID: 27},
		"|":  Command{HID: 26, Mode: 64},
		"#":  Command{HID: 32, Mode: 2},
		"'":  Command{HID: 45},
		"+":  Command{HID: 46},
		"/":  Command{HID: 36, Mode: 2},
		"I":  Command{HID: 12, Mode: 2},
		"3":  Command{HID: 32},
		"7":  Command{HID: 36},
		";":  Command{HID: 54, Mode: 2},
		"?":  Command{HID: 45, Mode: 2},
		"C":  Command{HID: 6, Mode: 2},
		"G":  Command{HID: 10, Mode: 2},
		"K":  Command{HID: 14, Mode: 2},
		"O":  Command{HID: 18, Mode: 2},
		"S":  Command{HID: 22, Mode: 2},
		"W":  Command{HID: 26, Mode: 2},
		"[":  Command{HID: 9, Mode: 64},
		"_":  Command{HID: 56, Mode: 2},
		"c":  Command{HID: 6},
		"g":  Command{HID: 10},
		"k":  Command{HID: 14},
		"o":  Command{HID: 18},
		"s":  Command{HID: 22},
		"w":  Command{HID: 26},
		"{":  Command{HID: 5, Mode: 64},
		"ß":  Command{HID: 52, Mode: 64},
		"×":  Command{HID: 48, Mode: 64},
		"\"": Command{HID: 31, Mode: 2},
		"ˇ":  Command{HID: 31, Mode: 64},
		"&":  Command{HID: 35, Mode: 2},
		"*":  Command{HID: 46, Mode: 2},
		".":  Command{HID: 55},
		"2":  Command{HID: 31},
		"6":  Command{HID: 35},
		"˛":  Command{HID: 35, Mode: 64},
		"˙":  Command{HID: 37, Mode: 64},
		":":  Command{HID: 55, Mode: 2},
		"÷":  Command{HID: 47, Mode: 64},
		"˝":  Command{HID: 39, Mode: 64},
		">":  Command{HID: 100, Mode: 2},
		"B":  Command{HID: 5, Mode: 2},
		"F":  Command{HID: 9, Mode: 2},
		"J":  Command{HID: 13, Mode: 2},
		"N":  Command{HID: 17, Mode: 2},
		"R":  Command{HID: 21, Mode: 2},
		"V":  Command{HID: 25, Mode: 2},
		"Z":  Command{HID: 28, Mode: 2},
		"^":  Command{HID: 32, Mode: 64},
		"¤":  Command{HID: 49, Mode: 64},
		"b":  Command{HID: 5},
		"f":  Command{HID: 9},
		"j":  Command{HID: 13},
		"¨":  Command{HID: 45, Mode: 64},
		"n":  Command{HID: 17},
		"´":  Command{HID: 38, Mode: 64},
		"r":  Command{HID: 21},
		"°":  Command{HID: 34, Mode: 64},
		"v":  Command{HID: 25},
		"z":  Command{HID: 28},
		"¸":  Command{HID: 46, Mode: 64},
		"~":  Command{HID: 30, Mode: 64},
		"Ł":  Command{HID: 15, Mode: 64},
		"ł":  Command{HID: 14, Mode: 64},
		"!":  Command{HID: 30, Mode: 2},
		"%":  Command{HID: 34, Mode: 2},
		")":  Command{HID: 38, Mode: 2},
		"š":  Command{HID: 47},
		"Š":  Command{HID: 47, Mode: 2},
		"Ž":  Command{HID: 49, Mode: 2},
		"ž":  Command{HID: 49},
		"5":  Command{HID: 34},
		"9":  Command{HID: 38},
		"˘":  Command{HID: 33, Mode: 64},
		"=":  Command{HID: 39, Mode: 2},
		"A":  Command{HID: 4, Mode: 2},
		"Č":  Command{HID: 51, Mode: 2},
		"č":  Command{HID: 51},
		"E":  Command{HID: 8, Mode: 2},
		"Ć":  Command{HID: 52, Mode: 2},
		"ć":  Command{HID: 52},
		"M":  Command{HID: 16, Mode: 2},
		"Q":  Command{HID: 20, Mode: 2},
		"U":  Command{HID: 24, Mode: 2},
		"Y":  Command{HID: 29, Mode: 2},
		"]":  Command{HID: 10, Mode: 64},
		"Đ":  Command{HID: 48, Mode: 2},
		"đ":  Command{HID: 48},
		"a":  Command{HID: 4},
		"e":  Command{HID: 8},
		"i":  Command{HID: 12},
		"m":  Command{HID: 16},
		"q":  Command{HID: 20},
		"1":  Command{HID: 30},
		"u":  Command{HID: 24},
		"y":  Command{HID: 29},
		"}":  Command{HID: 17, Mode: 64},
	},
	"CA": {
		" ":         Command{HID: 44},
		"$":         Command{HID: 33, Mode: 2},
		"(":         Command{HID: 38, Mode: 2},
		",":         Command{HID: 54},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 49},
		"@":         Command{HID: 31, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"§":         Command{HID: 18, Mode: 64},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 53, Mode: 64},
		"`":         Command{HID: 52},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"£":         Command{HID: 32, Mode: 64},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 53, Mode: 2},
		"¯":         Command{HID: 53, Mode: 64},
		"BACKSPACE": Command{HID: 42},
		"«":         Command{Mode: 2},
		"#":         Command{HID: 53},
		"'":         Command{HID: 54, Mode: 2},
		"+":         Command{HID: 46, Mode: 2},
		"/":         Command{HID: 32, Mode: 2},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 51},
		"?":         Command{HID: 35, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"³":         Command{HID: 38, Mode: 64},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 47, Mode: 64},
		"_":         Command{HID: 45, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 52, Mode: 64},
		"»":         Command{},
		"É":         Command{HID: 56, Mode: 2},
		"é":         Command{HID: 56},
		"\"":        Command{HID: 31, Mode: 2},
		"&":         Command{HID: 36, Mode: 2},
		"*":         Command{HID: 37, Mode: 2},
		".":         Command{HID: 55},
		"2":         Command{HID: 31},
		"6":         Command{HID: 35},
		":":         Command{HID: 51, Mode: 2},
		">":         Command{HID: 49, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 29, Mode: 2},
		"^":         Command{HID: 47},
		"¤":         Command{HID: 34, Mode: 64},
		"¦":         Command{HID: 36, Mode: 64},
		"b":         Command{HID: 5},
		"¢":         Command{HID: 33, Mode: 64},
		"f":         Command{HID: 9},
		"¬":         Command{HID: 35, Mode: 64},
		"­":         Command{HID: 55, Mode: 64},
		"j":         Command{HID: 13},
		"¨":         Command{HID: 48, Mode: 2},
		"n":         Command{HID: 17},
		"´":         Command{HID: 56, Mode: 64},
		"µ":         Command{HID: 16, Mode: 64},
		"¶":         Command{HID: 19, Mode: 64},
		"r":         Command{HID: 21},
		"°":         Command{Mode: 64},
		"±":         Command{HID: 30, Mode: 64},
		"²":         Command{HID: 37, Mode: 64},
		"v":         Command{HID: 25},
		"¼":         Command{HID: 39, Mode: 64},
		"½":         Command{HID: 45, Mode: 64},
		"¾":         Command{HID: 46, Mode: 64},
		"z":         Command{HID: 29},
		"¸":         Command{HID: 48},
		"~":         Command{HID: 51, Mode: 64},
		"!":         Command{HID: 30, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 39, Mode: 2},
		"-":         Command{HID: 45},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 46},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 48, Mode: 64},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 49, Mode: 64},
	},
	"DE": {
		" ":         Command{HID: 44},
		"$":         Command{HID: 33, Mode: 2},
		"(":         Command{HID: 37, Mode: 2},
		",":         Command{HID: 54},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 100},
		"@":         Command{HID: 20, Mode: 64},
		"€":         Command{HID: 8, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"§":         Command{HID: 32, Mode: 2},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 45, Mode: 64},
		"`":         Command{HID: 46, Mode: 2},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 100, Mode: 64},
		"BACKSPACE": Command{HID: 42},
		"#":         Command{HID: 49},
		"'":         Command{HID: 49, Mode: 2},
		"+":         Command{HID: 48},
		"/":         Command{HID: 36, Mode: 2},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 54, Mode: 2},
		"?":         Command{HID: 45, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"³":         Command{HID: 32, Mode: 64},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 37, Mode: 64},
		"_":         Command{HID: 56, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 36, Mode: 64},
		"Ä":         Command{HID: 52, Mode: 2},
		"ß":         Command{HID: 45},
		"Ü":         Command{HID: 47, Mode: 2},
		"ä":         Command{HID: 52},
		"Ö":         Command{HID: 51, Mode: 2},
		"\"":        Command{HID: 31, Mode: 2},
		"&":         Command{HID: 35, Mode: 2},
		"*":         Command{HID: 48, Mode: 2},
		".":         Command{HID: 55},
		"2":         Command{HID: 31},
		"6":         Command{HID: 35},
		":":         Command{HID: 55, Mode: 2},
		"ö":         Command{HID: 51},
		">":         Command{HID: 100, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 28, Mode: 2},
		"^":         Command{HID: 53},
		"¤":         Command{HID: 8, Mode: 64},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"n":         Command{HID: 17},
		"r":         Command{HID: 21},
		"°":         Command{HID: 53, Mode: 2},
		"²":         Command{HID: 31, Mode: 64},
		"v":         Command{HID: 25},
		"z":         Command{HID: 28},
		"~":         Command{HID: 48, Mode: 64},
		"ü":         Command{HID: 47},
		"!":         Command{HID: 30, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 38, Mode: 2},
		"-":         Command{HID: 56},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 39, Mode: 2},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 29, Mode: 2},
		"]":         Command{HID: 38, Mode: 64},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 29},
		"}":         Command{HID: 39, Mode: 64},
	},
	"TR": {
		" ":         Command{HID: 44},
		"$":         Command{HID: 33, Mode: 64},
		"(":         Command{HID: 37, Mode: 2},
		",":         Command{HID: 49},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 54, Mode: 2},
		"@":         Command{HID: 20, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 45, Mode: 64},
		"`":         Command{HID: 49, Mode: 64},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 49, Mode: 2},
		"BACKSPACE": Command{HID: 42},
		"#":         Command{HID: 32, Mode: 64},
		"'":         Command{HID: 31, Mode: 2},
		"+":         Command{HID: 33, Mode: 2},
		"/":         Command{HID: 36, Mode: 2},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 49, Mode: 2},
		"?":         Command{HID: 45, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 37, Mode: 64},
		"_":         Command{HID: 46, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 36, Mode: 64},
		"\"":        Command{HID: 53},
		"&":         Command{HID: 36, Mode: 2},
		"*":         Command{HID: 45},
		".":         Command{HID: 56},
		"2":         Command{HID: 31},
		"6":         Command{HID: 35},
		":":         Command{HID: 56, Mode: 2},
		">":         Command{HID: 55, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 29, Mode: 2},
		"^":         Command{HID: 32, Mode: 2},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"n":         Command{HID: 17},
		"r":         Command{HID: 21},
		"v":         Command{HID: 25},
		"z":         Command{HID: 29},
		"~":         Command{HID: 48, Mode: 64},
		"!":         Command{HID: 30, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 38, Mode: 2},
		"-":         Command{HID: 46},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 39, Mode: 2},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 38, Mode: 64},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 52},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 39, Mode: 64},
	},
	"IT": {
		" ":  Command{HID: 44},
		"$":  Command{HID: 33, Mode: 2},
		"(":  Command{HID: 37, Mode: 2},
		",":  Command{HID: 54},
		"0":  Command{HID: 39},
		"4":  Command{HID: 33},
		"8":  Command{HID: 37},
		"<":  Command{HID: 100},
		"@":  Command{HID: 51, Mode: 64},
		"D":  Command{HID: 7, Mode: 2},
		"H":  Command{HID: 11, Mode: 2},
		"L":  Command{HID: 15, Mode: 2},
		"P":  Command{HID: 19, Mode: 2},
		"T":  Command{HID: 23, Mode: 2},
		"X":  Command{HID: 27, Mode: 2},
		"\\": Command{HID: 53},
		"d":  Command{HID: 7},
		"h":  Command{HID: 11},
		"l":  Command{HID: 15},
		"p":  Command{HID: 19},
		"t":  Command{HID: 23},
		"x":  Command{HID: 27},
		"|":  Command{HID: 53, Mode: 2},
		"#":  Command{HID: 52, Mode: 64},
		"'":  Command{HID: 45},
		"+":  Command{HID: 48},
		"/":  Command{HID: 36, Mode: 2},
		"3":  Command{HID: 32},
		"7":  Command{HID: 36},
		";":  Command{HID: 54, Mode: 2},
		"?":  Command{HID: 45, Mode: 2},
		"C":  Command{HID: 6, Mode: 2},
		"G":  Command{HID: 10, Mode: 2},
		"K":  Command{HID: 14, Mode: 2},
		"O":  Command{HID: 18, Mode: 2},
		"S":  Command{HID: 22, Mode: 2},
		"è":  Command{HID: 47},
		"W":  Command{HID: 26, Mode: 2},
		"[":  Command{HID: 47, Mode: 64},
		"_":  Command{HID: 56, Mode: 2},
		"c":  Command{HID: 6},
		"g":  Command{HID: 10},
		"k":  Command{HID: 14},
		"ì":  Command{HID: 46},
		"o":  Command{HID: 18},
		"s":  Command{HID: 22},
		"w":  Command{HID: 26},
		"{":  Command{HID: 47, Mode: 66},
		"à":  Command{HID: 52},
		"é":  Command{HID: 47, Mode: 2},
		"\"": Command{HID: 31, Mode: 2},
		"&":  Command{HID: 35, Mode: 2},
		"*":  Command{HID: 48, Mode: 2},
		".":  Command{HID: 55},
		"ù":  Command{HID: 49},
		"2":  Command{HID: 31},
		"6":  Command{HID: 35},
		"ò":  Command{HID: 51},
		":":  Command{HID: 55, Mode: 2},
		">":  Command{HID: 100, Mode: 2},
		"B":  Command{HID: 5, Mode: 2},
		"F":  Command{HID: 9, Mode: 2},
		"J":  Command{HID: 13, Mode: 2},
		"N":  Command{HID: 17, Mode: 2},
		"R":  Command{HID: 21, Mode: 2},
		"V":  Command{HID: 25, Mode: 2},
		"Z":  Command{HID: 29, Mode: 2},
		"^":  Command{HID: 46, Mode: 2},
		"b":  Command{HID: 5},
		"f":  Command{HID: 9},
		"j":  Command{HID: 13},
		"n":  Command{HID: 17},
		"r":  Command{HID: 21},
		"v":  Command{HID: 25},
		"z":  Command{HID: 29},
		"!":  Command{HID: 30, Mode: 2},
		"%":  Command{HID: 34, Mode: 2},
		")":  Command{HID: 38, Mode: 2},
		"-":  Command{HID: 56},
		"1":  Command{HID: 30},
		"5":  Command{HID: 34},
		"9":  Command{HID: 38},
		"=":  Command{HID: 39, Mode: 2},
		"A":  Command{HID: 4, Mode: 2},
		"E":  Command{HID: 8, Mode: 2},
		"I":  Command{HID: 12, Mode: 2},
		"M":  Command{HID: 16, Mode: 2},
		"Q":  Command{HID: 20, Mode: 2},
		"U":  Command{HID: 24, Mode: 2},
		"Y":  Command{HID: 28, Mode: 2},
		"]":  Command{HID: 48, Mode: 64},
		"a":  Command{HID: 4},
		"e":  Command{HID: 8},
		"i":  Command{HID: 12},
		"m":  Command{HID: 16},
		"q":  Command{HID: 20},
		"u":  Command{HID: 24},
		"y":  Command{HID: 28},
		"}":  Command{HID: 48, Mode: 66},
	},
	"US": {
		" ":         Command{HID: 44},
		"$":         Command{HID: 33, Mode: 2},
		"(":         Command{HID: 38, Mode: 2},
		",":         Command{HID: 54},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 54, Mode: 2},
		"@":         Command{HID: 31, Mode: 2},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 49},
		"`":         Command{HID: 53},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 49, Mode: 2},
		"BACKSPACE": Command{HID: 42},
		"#":         Command{HID: 32, Mode: 2},
		"'":         Command{HID: 52},
		"+":         Command{HID: 46, Mode: 2},
		"/":         Command{HID: 56},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 51},
		"?":         Command{HID: 56, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 47},
		"_":         Command{HID: 45, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 47, Mode: 2},
		"\"":        Command{HID: 52, Mode: 2},
		"&":         Command{HID: 36, Mode: 2},
		"*":         Command{HID: 37, Mode: 2},
		".":         Command{HID: 55},
		"2":         Command{HID: 31},
		"6":         Command{HID: 35},
		":":         Command{HID: 51, Mode: 2},
		">":         Command{HID: 55, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 29, Mode: 2},
		"^":         Command{HID: 35, Mode: 2},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"n":         Command{HID: 17},
		"r":         Command{HID: 21},
		"v":         Command{HID: 25},
		"z":         Command{HID: 29},
		"~":         Command{HID: 53, Mode: 2},
		"!":         Command{HID: 30, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 39, Mode: 2},
		"-":         Command{HID: 45},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 46},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 48},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 48, Mode: 2},
	},
	"SV": {
		"ð":         Command{HID: 7, Mode: 64},
		" ":         Command{HID: 44},
		"$":         Command{HID: 33, Mode: 64},
		"(":         Command{HID: 37, Mode: 2},
		",":         Command{HID: 54},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 100},
		"@":         Command{HID: 31, Mode: 64},
		"€":         Command{HID: 8, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"§":         Command{HID: 53},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 45, Mode: 64},
		"`":         Command{HID: 46, Mode: 2},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"£":         Command{HID: 32, Mode: 64},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 100, Mode: 64},
		"BACKSPACE": Command{HID: 42},
		"«":         Command{HID: 33},
		"#":         Command{HID: 32, Mode: 2},
		"'":         Command{HID: 49},
		"+":         Command{HID: 45},
		"/":         Command{HID: 36, Mode: 2},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 54, Mode: 2},
		"?":         Command{HID: 45, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 37, Mode: 64},
		"_":         Command{HID: 56, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 36, Mode: 64},
		"Å":         Command{HID: 47, Mode: 2},
		"Ä":         Command{HID: 52, Mode: 2},
		"ß":         Command{HID: 22, Mode: 64},
		"ä":         Command{HID: 52},
		"Ö":         Command{HID: 51, Mode: 2},
		"\"":        Command{HID: 31, Mode: 2},
		"&":         Command{HID: 35, Mode: 2},
		"*":         Command{HID: 49, Mode: 2},
		"å":         Command{HID: 47},
		".":         Command{HID: 55},
		"2":         Command{HID: 31},
		"þ":         Command{HID: 23, Mode: 64},
		"6":         Command{HID: 35},
		":":         Command{HID: 55, Mode: 2},
		"ö":         Command{HID: 51},
		">":         Command{HID: 100, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 29, Mode: 2},
		"^":         Command{HID: 48, Mode: 2},
		"¤":         Command{HID: 33, Mode: 2},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"j":         Command{HID: 13},
		"n":         Command{HID: 17},
		"µ":         Command{HID: 16, Mode: 64},
		"r":         Command{HID: 21},
		"v":         Command{HID: 25},
		"½":         Command{HID: 53, Mode: 2},
		"z":         Command{HID: 29},
		"!":         Command{HID: 30, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 38, Mode: 2},
		"-":         Command{HID: 56},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 39, Mode: 2},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 38, Mode: 64},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 39, Mode: 64},
	},
	"SI": {
		"-":  Command{HID: 56},
		" ":  Command{HID: 44},
		"$":  Command{HID: 33, Mode: 2},
		"(":  Command{HID: 37, Mode: 2},
		",":  Command{HID: 54},
		"0":  Command{HID: 39},
		"4":  Command{HID: 33},
		"8":  Command{HID: 37},
		"<":  Command{HID: 100},
		"@":  Command{HID: 25, Mode: 64},
		"€":  Command{HID: 8, Mode: 64},
		"D":  Command{HID: 7, Mode: 2},
		"H":  Command{HID: 11, Mode: 2},
		"L":  Command{HID: 15, Mode: 2},
		"P":  Command{HID: 19, Mode: 2},
		"§":  Command{HID: 16, Mode: 64},
		"T":  Command{HID: 23, Mode: 2},
		"X":  Command{HID: 27, Mode: 2},
		"\\": Command{HID: 20, Mode: 64},
		"`":  Command{HID: 36, Mode: 64},
		"d":  Command{HID: 7},
		"h":  Command{HID: 11},
		"l":  Command{HID: 15},
		"p":  Command{HID: 19},
		"t":  Command{HID: 23},
		"x":  Command{HID: 27},
		"|":  Command{HID: 26, Mode: 64},
		"#":  Command{HID: 32, Mode: 2},
		"'":  Command{HID: 45},
		"+":  Command{HID: 46},
		"/":  Command{HID: 36, Mode: 2},
		"I":  Command{HID: 12, Mode: 2},
		"3":  Command{HID: 32},
		"7":  Command{HID: 36},
		";":  Command{HID: 54, Mode: 2},
		"?":  Command{HID: 45, Mode: 2},
		"C":  Command{HID: 6, Mode: 2},
		"G":  Command{HID: 10, Mode: 2},
		"K":  Command{HID: 14, Mode: 2},
		"O":  Command{HID: 18, Mode: 2},
		"S":  Command{HID: 22, Mode: 2},
		"W":  Command{HID: 26, Mode: 2},
		"[":  Command{HID: 9, Mode: 64},
		"_":  Command{HID: 56, Mode: 2},
		"c":  Command{HID: 6},
		"g":  Command{HID: 10},
		"k":  Command{HID: 14},
		"o":  Command{HID: 18},
		"s":  Command{HID: 22},
		"w":  Command{HID: 26},
		"{":  Command{HID: 5, Mode: 64},
		"ß":  Command{HID: 52, Mode: 64},
		"×":  Command{HID: 48, Mode: 64},
		"\"": Command{HID: 31, Mode: 2},
		"ˇ":  Command{HID: 31, Mode: 64},
		"&":  Command{HID: 35, Mode: 2},
		"*":  Command{HID: 46, Mode: 2},
		".":  Command{HID: 55},
		"2":  Command{HID: 31},
		"6":  Command{HID: 35},
		"˛":  Command{HID: 35, Mode: 64},
		"˙":  Command{HID: 37, Mode: 64},
		":":  Command{HID: 55, Mode: 2},
		"÷":  Command{HID: 47, Mode: 64},
		"˝":  Command{HID: 39, Mode: 64},
		">":  Command{HID: 100, Mode: 2},
		"B":  Command{HID: 5, Mode: 2},
		"F":  Command{HID: 9, Mode: 2},
		"J":  Command{HID: 13, Mode: 2},
		"N":  Command{HID: 17, Mode: 2},
		"R":  Command{HID: 21, Mode: 2},
		"V":  Command{HID: 25, Mode: 2},
		"Z":  Command{HID: 28, Mode: 2},
		"^":  Command{HID: 32, Mode: 64},
		"¤":  Command{HID: 49, Mode: 64},
		"b":  Command{HID: 5},
		"f":  Command{HID: 9},
		"j":  Command{HID: 13},
		"¨":  Command{HID: 45, Mode: 64},
		"n":  Command{HID: 17},
		"´":  Command{HID: 38, Mode: 64},
		"r":  Command{HID: 21},
		"°":  Command{HID: 34, Mode: 64},
		"v":  Command{HID: 25},
		"z":  Command{HID: 28},
		"¸":  Command{HID: 46, Mode: 64},
		"~":  Command{HID: 30, Mode: 64},
		"Ł":  Command{HID: 15, Mode: 64},
		"ł":  Command{HID: 14, Mode: 64},
		"!":  Command{HID: 30, Mode: 2},
		"%":  Command{HID: 34, Mode: 2},
		")":  Command{HID: 38, Mode: 2},
		"š":  Command{HID: 47},
		"Š":  Command{HID: 47, Mode: 2},
		"Ž":  Command{HID: 49, Mode: 2},
		"ž":  Command{HID: 49},
		"5":  Command{HID: 34},
		"9":  Command{HID: 38},
		"˘":  Command{HID: 33, Mode: 64},
		"=":  Command{HID: 39, Mode: 2},
		"A":  Command{HID: 4, Mode: 2},
		"Č":  Command{HID: 51, Mode: 2},
		"č":  Command{HID: 51},
		"E":  Command{HID: 8, Mode: 2},
		"Ć":  Command{HID: 52, Mode: 2},
		"ć":  Command{HID: 52},
		"M":  Command{HID: 16, Mode: 2},
		"Q":  Command{HID: 20, Mode: 2},
		"U":  Command{HID: 24, Mode: 2},
		"Y":  Command{HID: 29, Mode: 2},
		"]":  Command{HID: 10, Mode: 64},
		"Đ":  Command{HID: 48, Mode: 2},
		"đ":  Command{HID: 48},
		"a":  Command{HID: 4},
		"e":  Command{HID: 8},
		"i":  Command{HID: 12},
		"m":  Command{HID: 16},
		"q":  Command{HID: 20},
		"1":  Command{HID: 30},
		"u":  Command{HID: 24},
		"y":  Command{HID: 29},
		"}":  Command{HID: 17, Mode: 64},
	},
	"GB": {
		" ":         Command{HID: 44},
		"$":         Command{HID: 33, Mode: 2},
		"(":         Command{HID: 38, Mode: 2},
		",":         Command{HID: 54},
		"0":         Command{HID: 39},
		"4":         Command{HID: 33},
		"8":         Command{HID: 37},
		"<":         Command{HID: 54, Mode: 2},
		"@":         Command{HID: 52, Mode: 2},
		"€":         Command{HID: 33, Mode: 64},
		"D":         Command{HID: 7, Mode: 2},
		"H":         Command{HID: 11, Mode: 2},
		"L":         Command{HID: 15, Mode: 2},
		"P":         Command{HID: 19, Mode: 2},
		"T":         Command{HID: 23, Mode: 2},
		"X":         Command{HID: 27, Mode: 2},
		"\\":        Command{HID: 100},
		"`":         Command{HID: 53},
		"d":         Command{HID: 7},
		"h":         Command{HID: 11},
		"£":         Command{HID: 32, Mode: 2},
		"l":         Command{HID: 15},
		"p":         Command{HID: 19},
		"t":         Command{HID: 23},
		"x":         Command{HID: 27},
		"|":         Command{HID: 100, Mode: 2},
		"BACKSPACE": Command{HID: 42},
		"#":         Command{HID: 50},
		"'":         Command{HID: 52},
		"+":         Command{HID: 46, Mode: 2},
		"/":         Command{HID: 56},
		"3":         Command{HID: 32},
		"7":         Command{HID: 36},
		";":         Command{HID: 51},
		"?":         Command{HID: 56, Mode: 2},
		"C":         Command{HID: 6, Mode: 2},
		"G":         Command{HID: 10, Mode: 2},
		"K":         Command{HID: 14, Mode: 2},
		"O":         Command{HID: 18, Mode: 2},
		"S":         Command{HID: 22, Mode: 2},
		"W":         Command{HID: 26, Mode: 2},
		"[":         Command{HID: 47},
		"_":         Command{HID: 45, Mode: 2},
		"c":         Command{HID: 6},
		"g":         Command{HID: 10},
		"k":         Command{HID: 14},
		"o":         Command{HID: 18},
		"s":         Command{HID: 22},
		"w":         Command{HID: 26},
		"{":         Command{HID: 47, Mode: 2},
		"é":         Command{HID: 8, Mode: 64},
		"\"":        Command{HID: 31, Mode: 2},
		"í":         Command{HID: 12, Mode: 64},
		"&":         Command{HID: 36, Mode: 2},
		"*":         Command{HID: 37, Mode: 2},
		".":         Command{HID: 55},
		"ú":         Command{HID: 24, Mode: 64},
		"2":         Command{HID: 31},
		"6":         Command{HID: 35},
		"ó":         Command{HID: 18, Mode: 64},
		":":         Command{HID: 51, Mode: 2},
		">":         Command{HID: 55, Mode: 2},
		"B":         Command{HID: 5, Mode: 2},
		"F":         Command{HID: 9, Mode: 2},
		"J":         Command{HID: 13, Mode: 2},
		"N":         Command{HID: 17, Mode: 2},
		"R":         Command{HID: 21, Mode: 2},
		"V":         Command{HID: 25, Mode: 2},
		"Z":         Command{HID: 29, Mode: 2},
		"^":         Command{HID: 35, Mode: 2},
		"¦":         Command{HID: 53, Mode: 64},
		"b":         Command{HID: 5},
		"f":         Command{HID: 9},
		"¬":         Command{HID: 53, Mode: 2},
		"j":         Command{HID: 13},
		"n":         Command{HID: 17},
		"r":         Command{HID: 21},
		"v":         Command{HID: 25},
		"z":         Command{HID: 29},
		"~":         Command{HID: 50, Mode: 2},
		"!":         Command{HID: 30, Mode: 2},
		"%":         Command{HID: 34, Mode: 2},
		")":         Command{HID: 39, Mode: 2},
		"-":         Command{HID: 45},
		"1":         Command{HID: 30},
		"5":         Command{HID: 34},
		"9":         Command{HID: 38},
		"=":         Command{HID: 46},
		"A":         Command{HID: 4, Mode: 2},
		"E":         Command{HID: 8, Mode: 2},
		"I":         Command{HID: 12, Mode: 2},
		"M":         Command{HID: 16, Mode: 2},
		"Q":         Command{HID: 20, Mode: 2},
		"U":         Command{HID: 24, Mode: 2},
		"Y":         Command{HID: 28, Mode: 2},
		"]":         Command{HID: 48},
		"a":         Command{HID: 4},
		"e":         Command{HID: 8},
		"i":         Command{HID: 12},
		"m":         Command{HID: 16},
		"q":         Command{HID: 20},
		"u":         Command{HID: 24},
		"y":         Command{HID: 28},
		"}":         Command{HID: 48, Mode: 2},
	},
	"BR": {
		" ":  Command{HID: 44},
		"$":  Command{HID: 33, Mode: 2},
		"(":  Command{HID: 38, Mode: 2},
		",":  Command{HID: 54},
		"0":  Command{HID: 39},
		"4":  Command{HID: 33},
		"8":  Command{HID: 37},
		"<":  Command{HID: 54, Mode: 2},
		"@":  Command{HID: 31, Mode: 2},
		"D":  Command{HID: 7, Mode: 2},
		"H":  Command{HID: 11, Mode: 2},
		"L":  Command{HID: 15, Mode: 2},
		"P":  Command{HID: 19, Mode: 2},
		"b":  Command{HID: 5},
		"T":  Command{HID: 23, Mode: 2},
		"X":  Command{HID: 27, Mode: 2},
		"\\": Command{HID: 100},
		"`":  Command{HID: 47, Mode: 2},
		"d":  Command{HID: 7},
		"h":  Command{HID: 11},
		"l":  Command{HID: 15},
		"p":  Command{HID: 19},
		"t":  Command{HID: 23},
		"x":  Command{HID: 27},
		"|":  Command{HID: 100, Mode: 2},
		"#":  Command{HID: 32, Mode: 2},
		"'":  Command{HID: 53},
		"+":  Command{HID: 46, Mode: 2},
		"/":  Command{HID: 20, Mode: 64},
		"3":  Command{HID: 32},
		"7":  Command{HID: 36},
		";":  Command{HID: 56},
		"?":  Command{HID: 26, Mode: 64},
		"C":  Command{HID: 6, Mode: 2},
		"G":  Command{HID: 10, Mode: 2},
		"K":  Command{HID: 14, Mode: 2},
		"O":  Command{HID: 18, Mode: 2},
		"S":  Command{HID: 22, Mode: 2},
		"W":  Command{HID: 26, Mode: 2},
		"[":  Command{HID: 48},
		"_":  Command{HID: 45, Mode: 2},
		"c":  Command{HID: 6},
		"g":  Command{HID: 10},
		"k":  Command{HID: 14},
		"o":  Command{HID: 18},
		"s":  Command{HID: 22},
		"w":  Command{HID: 26},
		"{":  Command{HID: 48, Mode: 2},
		"Ç":  Command{HID: 51, Mode: 2},
		"\"": Command{HID: 53, Mode: 2},
		"&":  Command{HID: 36, Mode: 2},
		"*":  Command{HID: 37, Mode: 2},
		"ç":  Command{HID: 51},
		".":  Command{HID: 55},
		"2":  Command{HID: 31},
		"6":  Command{HID: 35},
		":":  Command{HID: 56, Mode: 2},
		">":  Command{HID: 55, Mode: 2},
		"B":  Command{HID: 5, Mode: 2},
		"F":  Command{HID: 9, Mode: 2},
		"J":  Command{HID: 13, Mode: 2},
		"N":  Command{HID: 17, Mode: 2},
		"R":  Command{HID: 21, Mode: 2},
		"V":  Command{HID: 25, Mode: 2},
		"Z":  Command{HID: 29, Mode: 2},
		"^":  Command{HID: 52, Mode: 2},
		"§":  Command{HID: 46, Mode: 64},
		"f":  Command{HID: 9},
		"j":  Command{HID: 13},
		"n":  Command{HID: 17},
		"´":  Command{HID: 47},
		"r":  Command{HID: 21},
		"°":  Command{HID: 8, Mode: 64},
		"v":  Command{HID: 25},
		"z":  Command{HID: 29},
		"~":  Command{HID: 52},
		"!":  Command{HID: 30, Mode: 2},
		"%":  Command{HID: 34, Mode: 2},
		")":  Command{HID: 39, Mode: 2},
		"-":  Command{HID: 45},
		"1":  Command{HID: 30},
		"5":  Command{HID: 34},
		"9":  Command{HID: 38},
		"=":  Command{HID: 46},
		"A":  Command{HID: 4, Mode: 2},
		"E":  Command{HID: 8, Mode: 2},
		"I":  Command{HID: 12, Mode: 2},
		"M":  Command{HID: 16, Mode: 2},
		"Q":  Command{HID: 20, Mode: 2},
		"U":  Command{HID: 24, Mode: 2},
		"Y":  Command{HID: 28, Mode: 2},
		"]":  Command{HID: 49},
		"a":  Command{HID: 4},
		"e":  Command{HID: 8},
		"i":  Command{HID: 12},
		"m":  Command{HID: 16},
		"q":  Command{HID: 20},
		"u":  Command{HID: 24},
		"y":  Command{HID: 28},
		"}":  Command{HID: 49, Mode: 2},
	},
	"RU": {
		" ":  Command{HID: 44},
		"$":  Command{HID: 33, Mode: 2},
		"(":  Command{HID: 38, Mode: 2},
		",":  Command{HID: 54, Mode: 2},
		"0":  Command{HID: 39},
		"4":  Command{HID: 33},
		"8":  Command{HID: 37},
		"3":  Command{HID: 32},
		";":  Command{HID: 54},
		"?":  Command{HID: 56},
		"ё":  Command{HID: 53},
		"#":  Command{HID: 32, Mode: 2},
		"'":  Command{HID: 36, Mode: 2},
		"/":  Command{HID: 56, Mode: 2},
		"с":  Command{HID: 22},
		"р":  Command{HID: 21},
		"у":  Command{HID: 11},
		"т":  Command{HID: 28},
		"х":  Command{HID: 27},
		"7":  Command{HID: 36},
		"ц":  Command{HID: 6},
		"щ":  Command{HID: 48},
		"ш":  Command{HID: 26},
		"ы":  Command{HID: 24},
		"ъ":  Command{HID: 46, Mode: 2},
		"ь":  Command{HID: 16},
		"я":  Command{HID: 20},
		"ю":  Command{HID: 47},
		"в":  Command{HID: 25},
		"г":  Command{HID: 10},
		"а":  Command{HID: 9},
		"б":  Command{HID: 5},
		"ж":  Command{HID: 52},
		"з":  Command{HID: 29},
		"д":  Command{HID: 7},
		"е":  Command{HID: 8},
		"к":  Command{HID: 14},
		"л":  Command{HID: 15},
		"и":  Command{HID: 18},
		"й":  Command{HID: 13},
		"о":  Command{HID: 19},
		"м":  Command{HID: 16},
		"н":  Command{HID: 17},
		"Т":  Command{HID: 28, Mode: 2},
		"У":  Command{HID: 11, Mode: 2},
		"Р":  Command{HID: 9, Mode: 2},
		"С":  Command{HID: 22, Mode: 2},
		"Ц":  Command{HID: 6, Mode: 2},
		"Х":  Command{HID: 27, Mode: 2},
		"Ъ":  Command{HID: 46},
		"Ы":  Command{HID: 24, Mode: 2},
		"Ш":  Command{HID: 26, Mode: 2},
		"Щ":  Command{HID: 48, Mode: 2},
		"Ю":  Command{HID: 47, Mode: 2},
		"Я":  Command{HID: 20, Mode: 2},
		"Ь":  Command{HID: 16, Mode: 2},
		"В":  Command{HID: 25, Mode: 2},
		"Г":  Command{HID: 10, Mode: 2},
		"А":  Command{HID: 4, Mode: 2},
		"Б":  Command{HID: 5, Mode: 2},
		"Ж":  Command{HID: 52, Mode: 2},
		"З":  Command{HID: 29, Mode: 2},
		"Д":  Command{HID: 7, Mode: 2},
		"Е":  Command{HID: 8, Mode: 2},
		"К":  Command{HID: 14, Mode: 2},
		"Л":  Command{HID: 15, Mode: 2},
		"И":  Command{HID: 18, Mode: 2},
		"Й":  Command{HID: 13, Mode: 2},
		"О":  Command{HID: 19, Mode: 2},
		"М":  Command{HID: 16, Mode: 2},
		"Н":  Command{HID: 17, Mode: 2},
		"№":  Command{HID: 49, Mode: 2},
		"\"": Command{HID: 31, Mode: 2},
		"&":  Command{HID: 35, Mode: 2},
		"*":  Command{HID: 37, Mode: 2},
		".":  Command{HID: 55, Mode: 2},
		"2":  Command{HID: 31},
		"_":  Command{HID: 45, Mode: 2},
		"6":  Command{HID: 35},
		":":  Command{HID: 55},
		"~":  Command{HID: 49},
		"!":  Command{HID: 30, Mode: 2},
		"%":  Command{HID: 34, Mode: 2},
		")":  Command{HID: 39, Mode: 2},
		"-":  Command{HID: 45},
		"1":  Command{HID: 30},
		"Ё":  Command{HID: 53, Mode: 2},
		"5":  Command{HID: 34},
		"9":  Command{HID: 38},
	},
	"FI": {
		" ":  Command{HID: 44},
		"$":  Command{HID: 33, Mode: 64},
		"(":  Command{HID: 37, Mode: 2},
		",":  Command{HID: 54},
		"0":  Command{HID: 39},
		"4":  Command{HID: 33},
		"8":  Command{HID: 37},
		"<":  Command{HID: 100},
		"@":  Command{HID: 31, Mode: 64},
		"€":  Command{HID: 8, Mode: 64},
		"D":  Command{HID: 7, Mode: 2},
		"H":  Command{HID: 11, Mode: 2},
		"L":  Command{HID: 15, Mode: 2},
		"P":  Command{HID: 19, Mode: 2},
		"§":  Command{HID: 53},
		"T":  Command{HID: 23, Mode: 2},
		"X":  Command{HID: 27, Mode: 2},
		"\\": Command{HID: 45, Mode: 64},
		"`":  Command{HID: 46, Mode: 2},
		"d":  Command{HID: 7},
		"h":  Command{HID: 11},
		"l":  Command{HID: 15},
		"p":  Command{HID: 19},
		"t":  Command{HID: 23},
		"x":  Command{HID: 27},
		"|":  Command{HID: 100, Mode: 64},
		"#":  Command{HID: 32, Mode: 2},
		"'":  Command{HID: 49},
		"+":  Command{HID: 45},
		"/":  Command{HID: 36, Mode: 2},
		"3":  Command{HID: 32},
		"7":  Command{HID: 36},
		";":  Command{HID: 54, Mode: 2},
		"?":  Command{HID: 45, Mode: 2},
		"C":  Command{HID: 6, Mode: 2},
		"G":  Command{HID: 10, Mode: 2},
		"K":  Command{HID: 14, Mode: 2},
		"O":  Command{HID: 18, Mode: 2},
		"S":  Command{HID: 22, Mode: 2},
		"W":  Command{HID: 26, Mode: 2},
		"[":  Command{HID: 37, Mode: 64},
		"_":  Command{HID: 56, Mode: 2},
		"c":  Command{HID: 6},
		"g":  Command{HID: 10},
		"k":  Command{HID: 14},
		"o":  Command{HID: 18},
		"s":  Command{HID: 22},
		"w":  Command{HID: 26},
		"{":  Command{HID: 36, Mode: 64},
		"Ä":  Command{HID: 52, Mode: 2},
		".":  Command{HID: 55},
		"Ö":  Command{HID: 51, Mode: 2},
		"\"": Command{HID: 31, Mode: 2},
		"&":  Command{HID: 35, Mode: 2},
		"*":  Command{HID: 49, Mode: 2},
		"ä":  Command{HID: 52},
		"2":  Command{HID: 31},
		"6":  Command{HID: 35},
		":":  Command{HID: 55, Mode: 2},
		"ö":  Command{HID: 51},
		">":  Command{HID: 100, Mode: 2},
		"B":  Command{HID: 5, Mode: 2},
		"F":  Command{HID: 9, Mode: 2},
		"J":  Command{HID: 13, Mode: 2},
		"N":  Command{HID: 17, Mode: 2},
		"R":  Command{HID: 21, Mode: 2},
		"V":  Command{HID: 25, Mode: 2},
		"Z":  Command{HID: 29, Mode: 2},
		"^":  Command{HID: 48, Mode: 2},
		"¤":  Command{HID: 33, Mode: 2},
		"b":  Command{HID: 5},
		"f":  Command{HID: 9},
		"j":  Command{HID: 13},
		"n":  Command{HID: 17},
		"´":  Command{HID: 46},
		"µ":  Command{HID: 16, Mode: 64},
		"r":  Command{HID: 21},
		"v":  Command{HID: 25},
		"z":  Command{HID: 29},
		"~":  Command{HID: 48, Mode: 64},
		"!":  Command{HID: 30, Mode: 2},
		"%":  Command{HID: 34, Mode: 2},
		")":  Command{HID: 38, Mode: 2},
		"-":  Command{HID: 56},
		"1":  Command{HID: 30},
		"5":  Command{HID: 34},
		"9":  Command{HID: 38},
		"=":  Command{HID: 39, Mode: 2},
		"A":  Command{HID: 4, Mode: 2},
		"E":  Command{HID: 8, Mode: 2},
		"I":  Command{HID: 12, Mode: 2},
		"M":  Command{HID: 16, Mode: 2},
		"Q":  Command{HID: 20, Mode: 2},
		"U":  Command{HID: 24, Mode: 2},
		"Y":  Command{HID: 28, Mode: 2},
		"]":  Command{HID: 38, Mode: 64},
		"a":  Command{HID: 4},
		"e":  Command{HID: 8},
		"i":  Command{HID: 12},
		"m":  Command{HID: 16},
		"q":  Command{HID: 20},
		"u":  Command{HID: 24},
		"y":  Command{HID: 28},
		"}":  Command{HID: 39, Mode: 64},
	},
	"ES": {
		" ":  Command{HID: 44},
		"$":  Command{HID: 33, Mode: 2},
		"(":  Command{HID: 37, Mode: 2},
		",":  Command{HID: 54},
		"0":  Command{HID: 39},
		"4":  Command{HID: 33},
		"8":  Command{HID: 37},
		"<":  Command{HID: 100},
		"@":  Command{HID: 31, Mode: 64},
		"D":  Command{HID: 7, Mode: 2},
		"H":  Command{HID: 11, Mode: 2},
		"L":  Command{HID: 15, Mode: 2},
		"P":  Command{HID: 19, Mode: 2},
		"T":  Command{HID: 23, Mode: 2},
		"X":  Command{HID: 27, Mode: 2},
		"\\": Command{HID: 53, Mode: 64},
		"d":  Command{HID: 7},
		"h":  Command{HID: 11},
		"l":  Command{HID: 15},
		"p":  Command{HID: 19},
		"t":  Command{HID: 23},
		"x":  Command{HID: 27},
		"|":  Command{HID: 30, Mode: 64},
		"#":  Command{HID: 32, Mode: 64},
		"'":  Command{HID: 45},
		"+":  Command{HID: 48},
		"/":  Command{HID: 36, Mode: 2},
		"3":  Command{HID: 32},
		"7":  Command{HID: 36},
		";":  Command{HID: 54, Mode: 2},
		"?":  Command{HID: 45, Mode: 2},
		"C":  Command{HID: 6, Mode: 2},
		"G":  Command{HID: 10, Mode: 2},
		"K":  Command{HID: 14, Mode: 2},
		"O":  Command{HID: 18, Mode: 2},
		"S":  Command{HID: 22, Mode: 2},
		"è":  Command{HID: 47},
		"W":  Command{HID: 26, Mode: 2},
		"[":  Command{HID: 47, Mode: 64},
		"_":  Command{HID: 56, Mode: 2},
		"c":  Command{HID: 6},
		"g":  Command{HID: 10},
		"k":  Command{HID: 14},
		"ì":  Command{HID: 46},
		"o":  Command{HID: 18},
		"s":  Command{HID: 22},
		"w":  Command{HID: 26},
		"{":  Command{HID: 47, Mode: 66},
		"à":  Command{HID: 52},
		"é":  Command{HID: 47, Mode: 2},
		"\"": Command{HID: 31, Mode: 2},
		"&":  Command{HID: 35, Mode: 2},
		"*":  Command{HID: 48, Mode: 2},
		".":  Command{HID: 55},
		"ù":  Command{HID: 49},
		"2":  Command{HID: 31},
		"6":  Command{HID: 35},
		"ò":  Command{HID: 51},
		":":  Command{HID: 55, Mode: 2},
		">":  Command{HID: 100, Mode: 2},
		"B":  Command{HID: 5, Mode: 2},
		"F":  Command{HID: 9, Mode: 2},
		"J":  Command{HID: 13, Mode: 2},
		"N":  Command{HID: 17, Mode: 2},
		"R":  Command{HID: 21, Mode: 2},
		"V":  Command{HID: 25, Mode: 2},
		"Z":  Command{HID: 29, Mode: 2},
		"^":  Command{HID: 46, Mode: 2},
		"b":  Command{HID: 5},
		"f":  Command{HID: 9},
		"j":  Command{HID: 13},
		"n":  Command{HID: 17},
		"r":  Command{HID: 21},
		"v":  Command{HID: 25},
		"z":  Command{HID: 29},
		"º":  Command{HID: 53},
		"~":  Command{HID: 33, Mode: 64},
		"!":  Command{HID: 30, Mode: 2},
		"%":  Command{HID: 34, Mode: 2},
		")":  Command{HID: 38, Mode: 2},
		"-":  Command{HID: 56},
		"1":  Command{HID: 30},
		"5":  Command{HID: 34},
		"9":  Command{HID: 38},
		"=":  Command{HID: 39, Mode: 2},
		"A":  Command{HID: 4, Mode: 2},
		"E":  Command{HID: 8, Mode: 2},
		"I":  Command{HID: 12, Mode: 2},
		"M":  Command{HID: 16, Mode: 2},
		"Q":  Command{HID: 20, Mode: 2},
		"U":  Command{HID: 24, Mode: 2},
		"Y":  Command{HID: 28, Mode: 2},
		"]":  Command{HID: 48, Mode: 64},
		"a":  Command{HID: 4},
		"e":  Command{HID: 8},
		"i":  Command{HID: 12},
		"m":  Command{HID: 16},
		"q":  Command{HID: 20},
		"u":  Command{HID: 24},
		"y":  Command{HID: 28},
		"}":  Command{HID: 48, Mode: 66},
	},
}

func KeyMapFor(lang string) KeyMap {
	if m, found := KeyMaps[lang]; found {
		mm := KeyMap{}
		for k, cmd := range BaseMap {
			mm[k] = cmd
		}
		for k, cmd := range m {
			mm[k] = cmd
		}
		return mm
	}
	return nil
}

func SupportedLayouts() []string {
	maps := []string{}
	for lang := range KeyMaps {
		maps = append(maps, lang)
	}
	sort.Strings(maps)
	return maps
}
