//  ************************************************************************************************
//
//  qt-mvvm: Model-view-view-model framework for large GUI applications
//
//! @file      mvvm/model/mvvm/signals/itemlistenerbase.h
//! @brief     Defines class CLASS?
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2020
//! @authors   Gennady Pospelov et al, Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_MVVM_MODEL_MVVM_SIGNALS_ITEMLISTENERBASE_H
#define BORNAGAIN_MVVM_MODEL_MVVM_SIGNALS_ITEMLISTENERBASE_H

#include "mvvm/model_export.h"
#include "mvvm/signals/callback_types.h"

namespace ModelView {

class SessionItem;

//! Provides sets of methods to subscribe to various signals generated by SessionItem.
//! Used to implement user actions on item change.

//! Automatically tracks the time of life of SessionItem. Unsubscribes from the item on
//! own destruction. Can be switched from tracking one item to another of the same type.

class MVVM_MODEL_EXPORT ItemListenerBase {
public:
    explicit ItemListenerBase(SessionItem* item = nullptr);
    virtual ~ItemListenerBase();

    ItemListenerBase& operator=(const ItemListenerBase& other) = delete;
    ItemListenerBase(const ItemListenerBase& other) = delete;

    void setItem(SessionItem* item);

    void setOnItemDestroy(Callbacks::item_t f);
    void setOnDataChange(Callbacks::item_int_t f);
    void setOnPropertyChange(Callbacks::item_str_t f);
    void setOnChildPropertyChange(Callbacks::item_str_t f);
    void setOnItemInserted(Callbacks::item_tagrow_t f);
    void setOnItemRemoved(Callbacks::item_tagrow_t f);
    void setOnAboutToRemoveItem(Callbacks::item_tagrow_t f);

protected:
    virtual void subscribe() {}   //! For necessary manipulations on new item.
    virtual void unsubscribe() {} //! For necessary manipulations on unsubscription.
    SessionItem* item() const;

private:
    void unsubscribe_from_current();
    SessionItem* m_item{nullptr};
};

} // namespace ModelView

#endif // BORNAGAIN_MVVM_MODEL_MVVM_SIGNALS_ITEMLISTENERBASE_H
