//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Device/ResolutionForm.h
//! @brief     A widget for editing the alignment of a detector
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_DEVICE_RESOLUTIONFORM_H
#define BORNAGAIN_GUI_VIEW_DEVICE_RESOLUTIONFORM_H

#include <QGroupBox>

class DetectorItem;
class QFormLayout;

//! Widget for selecting the resolution function of a detector (combo box) and input of the
//! corresponding values

class ResolutionForm : public QGroupBox {
    Q_OBJECT
public:
    enum Unit { Degree, Millimeter };
    ResolutionForm(Unit unit, QWidget* parent, DetectorItem* item);

signals:
    void dataChanged();

private:
    void createResolutionWidgets();

private:
    Unit m_unit;
    DetectorItem* m_item;
    QFormLayout* m_formLayout;
};

#endif // BORNAGAIN_GUI_VIEW_DEVICE_RESOLUTIONFORM_H
