//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      GUI/View/Job/JobListViewDelegate.h
//! @brief     Defines class JobListViewDelegate
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifndef BORNAGAIN_GUI_VIEW_JOB_JOBLISTVIEWDELEGATE_H
#define BORNAGAIN_GUI_VIEW_JOB_JOBLISTVIEWDELEGATE_H

#include <QItemDelegate>
#include <QMap>
#include <QRect>

class JobItem;
enum class JobStatus;

//! ViewDelegate to show progress bar JobQueuListView
class JobListViewDelegate : public QItemDelegate {
    Q_OBJECT
public:
    JobListViewDelegate(QWidget* parent);

    void paint(QPainter* painter, const QStyleOptionViewItem& option,
               const QModelIndex& index) const override;

    bool editorEvent(QEvent* event, QAbstractItemModel* model, const QStyleOptionViewItem& option,
                     const QModelIndex& index) override;

signals:
    void cancelButtonClicked(const QModelIndex& index);

private:
    QStyle::State m_buttonState;
    void drawCustomProjectBar(const JobItem* item, QPainter* painter,
                              const QStyleOptionViewItem& option) const;

    QRect getTextRect(QRect optionRect) const;
    QRect getProgressBarRect(QRect optionRect) const;
    QRect getButtonRect(QRect optionRect) const;

    QMap<JobStatus, QColor> m_status_to_color;
};

#endif // BORNAGAIN_GUI_VIEW_JOB_JOBLISTVIEWDELEGATE_H
