# Configure Python bindings for one component library.
# Called from function MakeLib.

function(SwigLib name lib swigtmpdir)

    # TODO: Why BORNAGAIN_PYTHON is needed for Swig API?
    if(NOT BORNAGAIN_PYTHON)
        message(FATAL_ERROR "Function SwigLib called though BORNAGAIN_PYTHON=false")
    endif()

    message(STATUS "SwigLib ${name}: ${lib} ${swigtmpdir}")

    if(CONFIGURE_BINDINGS)

        file(MAKE_DIRECTORY ${swigtmpdir})

        # static (manually written) input files
        set(swig_dependencies
            ${SWIG_DIR}/lib${lib}.i
            ${SWIG_DIR}/deprecation.i
            ${SWIG_DIR}/warnings.i
            ${SWIG_DIR}/ignoreSample.i
            )
        foreach(FNAM ${swig_dependencies})
            if(NOT EXISTS ${FNAM})
                message(FATAL_ERROR "Could NOT find SWIG input ${FNAM}")
            endif()
        endforeach()

        # Run Swig.
        #     Please keep -Werror, in order not to overlook critical warnings.
        #     Dispensable warnings are disabled in Wrap/Swig/warnings.i.
        #     Joachim, oct20.
        set(SWIG_FLAGS "-c++;-python;-Werror;-o;${AUTO_WRAP_DIR}/lib${lib}_wrap.cpp;-outdir;${swigtmpdir}"
            ";-I${LibHeinz_INCLUDE_DIR}"
            ";-I${CMAKE_SOURCE_DIR};-I${CMAKE_BINARY_DIR}/inc")

        add_custom_command(
            OUTPUT ${AUTO_WRAP_DIR}/lib${lib}.py
            COMMAND ${Python3_EXECUTABLE} ${SWIG_DIR}/tweaks.py
                   ${swigtmpdir}/lib${lib}.py
                   ${AUTO_WRAP_DIR}/lib${lib}.py
            DEPENDS ${swigtmpdir}/lib${lib}.py
            )
        add_custom_command(
            OUTPUT ${swigtmpdir}/lib${lib}.py
                   ${AUTO_WRAP_DIR}/lib${lib}_wrap.h
                   ${AUTO_WRAP_DIR}/lib${lib}_wrap.cpp
            COMMAND ${SWIG_EXECUTABLE} ${SWIG_FLAGS} ${SWIG_DIR}/lib${lib}.i
            DEPENDS ${swig_dependencies} ${include_files}
            )

        string(REPLACE ";" " " SWIG_FLAGS_STR "${SWIG_FLAGS}")
        set(SWIG_FLAGS_STR "${SWIG_FLAGS_STR}" CACHE INTERNAL "")
        set(SWIG_DIR "${SWIG_DIR}" CACHE INTERNAL "")

    endif()

    # include Python and Numpy headers and link to Python shared library
    target_include_directories(${lib} PRIVATE ${Python3_INCLUDE_DIRS} ${Python3_NumPy_INCLUDE_DIRS})
    target_link_libraries(${lib} PRIVATE ${Python3_LIBRARIES})

    # copy SWIG-produced Python wrapper script to the library output directory
    add_custom_target(
        ${lib}_python
        COMMAND ${CMAKE_COMMAND}
            -E copy ${AUTO_WRAP_DIR}/lib${lib}.py ${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${lib}.py
        DEPENDS ${AUTO_WRAP_DIR}/lib${lib}.py
        )

    set_target_properties(${lib} PROPERTIES
        _LIBRARY_PY "${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${lib}.py"
        )

    add_dependencies(${lib} ${lib}_python)

    install(FILES ${CMAKE_LIBRARY_OUTPUT_DIRECTORY}/lib${lib}.py
        DESTINATION ${destination_python} COMPONENT Libraries)

endfunction()
