.TH aespasswd 1 "2004 Feb 8"
." The first line of this file must contain the '"[e][r][t][v] line
." to tell man to run the appropriate filter "t" for table.
."
."	$Id: aespasswd.man 118 2005-08-28 21:08:31Z boote $
."
."######################################################################
."#									#
."#			   Copyright (C)  2004				#
."#	     			Internet2				#
."#			   All Rights Reserved				#
."#									#
."######################################################################
."
."	File:		aespasswd.man
."
."	Author:		Jeff Boote
."			Internet2
."
."	Date:		Sun Feb 08 00:23:56 MST 2004
."
."	Description:	
."
.SH NAME
aespasswd \- Used to create and manage an AES keyfile.
.SH SYNOPSIS
.B aespasswd 
[\fI-n\fR] [\fI-d\fR] \fI-f keyfile identity
.SH OPTIONS
.TP
\fB\-n\fR
Create the keyfile
.TP
\fB\-d\fR
Delete given identity from keyfile
.TP
\fB\-f keyfile\fR
Specifies file that holds identity/key pairs
.SH DESCRIPTION
.B aespasswd
is used to create and manage files that hold identity/key pairs. It is
primarily used to manage the \fIbwctld.keys\fR file for \fBbwctld\fR
and the \fIowampd.keys\fR file for \fBowampd\fR.
.PP
If the \fI\-d\fR option is not specified, then \fBaespasswd\fR prompts
the caller for a passphrase. The passphrase is hashed using an internal
MD5 algorithm to generate a key that is then saved in the \fIkeyfile\fR
associated with the given \fIidentity\fR. If the given \fIidentity\fR
already exists in the \fIkeyfile\fR, the previous key is overwritten with
the new one.
.PP
\fIkeyfiles\fR generated by \fBaespasswd\fR are formatted for use with
\fBBWCTL\fR and \fBOWAMP\fR.
.SH KEYFILE FORMAT
\fBaespasswd\fR generates lines of the format:
.LP
test	54b0c58c7ce9f2a8b551351102ee0938
.PP
An \fIidentity\fR, followed by whitespace, followed by a hex encoded 128\-bit
number, that is suitable to be used as a symmetric AES key.
.PP
No other text is allowed on these lines; however, comment lines may be
added. Comment lines are any line where the first non-white space character
is '\fB#\fR'.
.SH EXAMPLES
\fBaespasswd -f /usr/local/etc/bwctld.keys testuser\fP
.IP
Adds a key for the identity \fItestuser\fR. The user is prompted for
a passphrase. If the file does not exist, an error message will
be printed and no action will be taken.
.LP
\fBaespasswd -f /usr/local/etc/bwctld.keys -n testuser\fP
.IP
Creates the file before doing the same as above. If the file already
exists, an error message will be printed and no action will be taken.
.LP
\fBaespasswd -f /usr/local/etc/bwctld.keys -d testuser\fP
.IP
Deletes the identity \fItestuser\fR from the keyfile.
If the file does not exist, an error message will be printed and no action will be taken.
.LP
.SH SECURITY CONSIDERATIONS
The keys in the \fIkeyfile\fR are not encrypted in any way. The security
of these keys is completely dependent upon the security of the system and the
discretion of the system administrator.
.SH RESTRICTIONS
\fIidentity\fR names are restricted to 16 characters, and passphrases
are limited to 1024 characters.
.SH SEE ALSO
owping(1), owampd(1), bwctl(1), bwctld(1)
and the \%http://e2epi.internet2.edu/owamp and
\%http://e2epi.internet2.edu/bwctl web sites.
.SH ACKNOWLEDGMENTS
This material is based in part on work supported by the National Science
Foundation (NSF) under Grant No. ANI-0314723. Any opinions, findings and
conclusions or recommendations expressed in this material are those of
the author(s) and do not necessarily reflect the views of the NSF.
