/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _HYPERCLAW_F_H_
#define _HYPERCLAW_F_H_

/*
** $Id: HYPERCLAW_F.H,v 1.10 2002/05/16 22:30:07 vince Exp $
*/

#ifdef BL_LANG_FORT
#    define FORT_ESTDT       hcestdt
#    define FORT_AVGDOWN     avgdown
#    define FORT_COPYMULT    copymult
#    define FORT_INCRMULT    incrmult
#    define FORT_VECTMPY     vectmpy
#    define FORT_VECTDIV     vectdiv
#    define FORT_SUMMASS     summass
#else
#  ifdef BL_FORT_USE_UPPERCASE
#    define FORT_ESTDT       HCESTDT
#    define FORT_AVGDOWN     AVGDOWN
#    define FORT_SUMMASS     SUMMASS
#  else
#  ifdef BL_FORT_USE_LOWERCASE
#    define FORT_ESTDT       hcestdt
#    define FORT_AVGDOWN     avgdown
#    define FORT_SUMMASS     summass
#  else
#    define FORT_ESTDT       hcestdt_
#    define FORT_AVGDOWN     avgdown_
#    define FORT_SUMMASS     summass_
#  endif
#  endif

extern "C"
{

     void FORT_ESTDT (const Real* state, ARLIM_P(s), ARLIM_P(s),
                      const Real* c, ARLIM_P(c), ARLIM_P(c),
		      const int* lo, const int* hi,
                      const Real* dx, Real* dt, int* nv );

     void FORT_AVGDOWN (Real* crse, ARLIM_P(c), ARLIM_P(c), const int* nvar,
                        const Real* cvol, ARLIM_P(cvol), ARLIM_P(cvol),
                        const Real* fine, ARLIM_P(f), ARLIM_P(f),
                        const Real* fvol, ARLIM_P(fvol), ARLIM_P(fvol),
                        const int* lo, const int* hi,
                        const int* ratio);

    void FORT_SUMMASS (const Real* dat, ARLIM_P(dat), ARLIM_P(dat),
                       const int* lo, const int* hi,
                       const Real* delta, Real* mass,
                       const Real* radius, const int* irlo, const int* irhi,
                       const int* rz_flag,
		       Real* tmp, const int* tlo, const int* thi);
}

#endif

#endif /*_HYPERCLAW_F_H_*/
