/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

#ifndef _INTERPBNDRY_F_H_
#define _INTERPBNDRY_F_H_

/*
** $Id: INTERPBNDRYDATA_F.H,v 1.3 2002/04/26 22:10:02 lijewski Exp $
*/

#ifdef BL_LANG_FORT
#    define FORT_BDINTERPXLO  bdintrpxlo
#    define FORT_BDINTERPXHI  bdintrpxhi
#  if (BL_SPACEDIM > 1)
#    define FORT_BDINTERPYLO  bdintrpylo
#    define FORT_BDINTERPYHI  bdintrpyhi
#  endif
#  if (BL_SPACEDIM > 2)
#    define FORT_BDINTERPZLO  bdintrpzlo
#    define FORT_BDINTERPZHI  bdintrpzhi
#  endif
#else
#  if  defined(BL_FORT_USE_UPPERCASE)
#    define FORT_BDINTERPXLO  BDINTRPXLO
#    define FORT_BDINTERPXHI  BDINTRPXHI
#    if (BL_SPACEDIM > 1)
#    define FORT_BDINTERPYLO  BDINTRPYLO
#    define FORT_BDINTERPYHI  BDINTRPYHI
#    endif
#    if (BL_SPACEDIM > 2)
#    define FORT_BDINTERPZLO  BDINTRPZLO
#    define FORT_BDINTERPZHI  BDINTRPZHI
#    endif
#  elif defined(BL_FORT_USE_LOWERCASE)
#    define FORT_BDINTERPXLO  bdintrpxlo
#    define FORT_BDINTERPXHI  bdintrpxhi
#    if (BL_SPACEDIM > 1)
#    define FORT_BDINTERPYLO  bdintrpylo
#    define FORT_BDINTERPYHI  bdintrpyhi
#    endif
#    if (BL_SPACEDIM > 2)
#    define FORT_BDINTERPZLO  bdintrpzlo
#    define FORT_BDINTERPZHI  bdintrpzhi
#    endif
#  elif defined(BL_FORT_USE_UNDERSCORE)
#    define FORT_BDINTERPXLO  bdintrpxlo_
#    define FORT_BDINTERPXHI  bdintrpxhi_
#    if (BL_SPACEDIM > 1)
#    define FORT_BDINTERPYLO  bdintrpylo_
#    define FORT_BDINTERPYHI  bdintrpyhi_
#    endif
#    if (BL_SPACEDIM > 2)
#    define FORT_BDINTERPZLO  bdintrpzlo_
#    define FORT_BDINTERPZHI  bdintrpzhi_
#    endif
#endif

#include <ArrayLim.H>

typedef void BDInterpFunc(Real* bndr, ARLIM_P(blo), ARLIM_P(bhi),
                          const int* lo, const int* hi,
                          ARLIM_P(cblo), ARLIM_P(cbhi),
                          const int* nvar, const int* ratio,
                          const int* not_covered,
                          const int* mask,  ARLIM_P(mlo), ARLIM_P(mhi),
                          const Real* crse, ARLIM_P(clo), ARLIM_P(chi),
                          Real* derives);
extern "C"
{
    BDInterpFunc FORT_BDINTERPXLO;
    BDInterpFunc FORT_BDINTERPXHI;

#if (BL_SPACEDIM > 1)    
    BDInterpFunc FORT_BDINTERPYLO;
    BDInterpFunc FORT_BDINTERPYHI;
#endif    

#if (BL_SPACEDIM > 2)    
    BDInterpFunc FORT_BDINTERPZLO;
    BDInterpFunc FORT_BDINTERPZHI;
#endif    

}
#endif

#endif /*_INTERPBNDRY_F_H_*/
