/*
** (c) 1996-2000 The Regents of the University of California (through
** E.O. Lawrence Berkeley National Laboratory), subject to approval by
** the U.S. Department of Energy.  Your use of this software is under
** license -- the license agreement is attached and included in the
** directory as license.txt or you may contact Berkeley Lab's Technology
** Transfer Department at TTD@lbl.gov.  NOTICE OF U.S. GOVERNMENT RIGHTS.
** The Software was developed under funding from the U.S. Government
** which consequently retains certain rights as follows: the
** U.S. Government has been granted for itself and others acting on its
** behalf a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, and perform publicly
** and display publicly.  Beginning five (5) years after the date
** permission to assert copyright is obtained from the U.S. Department of
** Energy, and subject to any subsequent five (5) year renewals, the
** U.S. Government is granted for itself and others acting on its behalf
** a paid-up, nonexclusive, irrevocable, worldwide license in the
** Software to reproduce, prepare derivative works, distribute copies to
** the public, perform publicly and display publicly, and to permit
** others to do so.
*/

// ---------------------------------------------------------------
// PltAppState.H
// ---------------------------------------------------------------
//  state observers:
//    pltapp
//    amrpicture
//    projectionpicture
//    dataset
//    palette
//    lightingwindow
//    xyplots
// ---------------------------------------------------------------
#ifndef _PLTAPPSTATE_H_
#define _PLTAPPSTATE_H_

#include "AmrvisConstants.H"
#include "Array.H"
#include "Box.H"

#include <string>
using std::string;

const int NOTSETYET(-42);
static void Cnsy(int val) { BL_ASSERT(val != NOTSETYET); }

class CMinMax {
  public:
    CMinMax();
    ~CMinMax();
    void SetMinMax(const Real rmin, const Real rmax);
    void GetMinMax(Real &rmin, Real &rmax);
    bool IsSet() const { return bMinMaxSet; }

    // no is_set checking on these
    Real Min() const { return rMin; }
    Real Max() const { return rMax; }

  private:
    Real rMin, rMax;
    bool bMinMaxSet;
};


class AmrPicture;


class PltAppState {
    
private:
  PltAppState();  // disallow

public:
  // created when opening a new file
  PltAppState(int numFrames, int numDerived);
  ~PltAppState();

  PltAppState &operator=(const PltAppState &rhs);
  
  // ------------------------ scale
  int  CurrentScale()  const          { Cnsy(currentScale);  return currentScale; }
  void SetCurrentScale(int newScale)  { currentScale = newScale; }
  int  MaxScale()  const          { Cnsy(maxScale);  return maxScale; }
  void SetMaxScale(int newMaxScale)  { maxScale = newMaxScale; }

  // ------------------------ frame
  void SetCurrentFrame(int newFrame)  { currentFrame = newFrame; }

  // ------------------------ derived
  void SetCurrentDerived(const string &newDerived, int cdnumber);
  const string &CurrentDerived() const { return currentDerived; }
  int CurrentDerivedNumber() const { Cnsy(currentDerivedNumber);
				     return currentDerivedNumber; }

  // ------------------------ boxes
  bool GetShowingBoxes() const        { return showBoxes; }
  void SetShowingBoxes(bool showing)  { showBoxes = showing; }

  // ------------------------ number format
  string GetFormatString() const                 { return formatString;      }
  void SetFormatString(const string &newformat)  { formatString = newformat; }

  // ------------------------ contours
  void SetContourType(ContourType newContourType)
			     { currentContourType = newContourType; }
  ContourType GetContourType() const { return currentContourType; }
  void SetNumContours(int ncontours) { nContours = ncontours; }
  int  GetNumContours() const        { Cnsy(nContours);  return nContours; }

  // ------------------------ mins and maxes
  MinMaxRangeType GetMinMaxRangeType() const { return currentMinMaxType; }
  void SetMinMaxRangeType(MinMaxRangeType newmmrtype)
				       { currentMinMaxType = newmmrtype; }

  void SetMinMax(const MinMaxRangeType mmrangetype,
		 const int framenumber,
		 const int derivednumber,
		 const Real rmin, const Real rmax);
  void GetMinMax(const MinMaxRangeType mmrangetype,
		 const int framenumber,
		 const int derivednumber,
		 Real &rmin, Real &rmax);
  // this one uses the current frame, derived, and range type
  void GetMinMax(Real &rmin, Real &rmax);
  bool IsSet(const MinMaxRangeType mmrangetype, const int framenumber,
	     const int derivednumber);
  void PrintSetMap();

  // ------------------------ levels
  void SetMinAllowableLevel(int newval) { minAllowableLevel = newval; }
  void SetMaxAllowableLevel(int newval) { maxAllowableLevel = newval; }
  void SetMinDrawnLevel(int newval)     { minDrawnLevel = newval; }
  void SetMaxDrawnLevel(int newval)     { maxDrawnLevel = newval; }
  void SetFinestLevel(int newval)       { finestLevel = newval; }

  int MinAllowableLevel() const { Cnsy(minAllowableLevel);
				  return minAllowableLevel; }
  int MaxAllowableLevel() const { Cnsy(maxAllowableLevel);
				  return maxAllowableLevel; }
  int MinDrawnLevel() const { Cnsy(minDrawnLevel);  return minDrawnLevel; }
  int MaxDrawnLevel() const { Cnsy(maxDrawnLevel);  return maxDrawnLevel; }
  int FinestLevel()   const { Cnsy(finestLevel);    return finestLevel; }


  //GraphicsAttributes *GetGAptr() const  { return gaPtr; }

private:

  // state variables
  int currentScale;
  int maxScale;
  int currentFrame;
  string currentDerived;
  int currentDerivedNumber;
  bool showBoxes;
  ContourType currentContourType;
  int nContours;
  MinMaxRangeType currentMinMaxType;
  string formatString;

  // mins and maxes
  Array<Array<Array<CMinMax> > > minMax;   // minMax [frame] [derived] [RangeType]

  Array<Box> subDomains;
  int minDrawnLevel, maxDrawnLevel, minAllowableLevel, maxAllowableLevel;
  int finestLevel;


  //bool datasetShowing, paletteDrawn, writingRGB, interfaceReady;
  //int minDrawnLevel, maxDrawnLevel, minDataLevel, maxDataLevel;
  //int activeView;
  string contourNumString, fileName, palFilename;
  //Array<string> fileNames, derivedStrings;
  //GraphicsAttributes	*gaPtr;



  // observers
  //AmrPicture *amrPicturePtrArray[NPLANES];

  //Palette *pltPaletteptr;
  //Dataset *datasetPtr;
  //Array<DataServices *> dataServicesPtr;

};
#endif
