/*
 * cowbell
 * Copyright (c) 2005 Brad Taylor
 *
 * This file is part of cowbell.
 *
 * cowbell is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * cowbell is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with cowbell; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

using System;
using System.Net;
using System.Web;
using System.Text.RegularExpressions;
using System.IO;
using System.Threading;
using System.Collections;

using Gtk;
using Gdk;

using Cowbell.Base;

namespace Cowbell
{
	/*
	 * Sean Connery: Well, the game is afoot. I'll take anal bum cover for 7,000.
	 *  Alex Trebek: That's An album cover, not anal bum cover.
	 * Sean Connery: I can read, Trebek. That says Anal bum cover. I've
	 *               spent five years of my life trying to invent an anal
	 *               bum cover, failing to do so is my greatest regret. 
	 */
	public class AlbumCoverImage : EventBox
	{
		/* public methods */
		public AlbumCoverImage ()
		{
			pixbuf = null;
			UserPixbuf = false;

			loadingcover = new Gdk.Pixbuf (null, "loading-cover.png");
			defaultcover = new Gdk.Pixbuf (null, "default-cover.png");

			image = new Gtk.Image ();
			image.Pixbuf = defaultcover;

			covers = new Hashtable ();
			covers.Add ("0", defaultcover);
			
			large_covers = new Hashtable ();

			Gtk.Drag.DestSet (this, DestDefaults.All, CoverDragEntries, Gdk.DragAction.Copy);
			DragDataReceived += new DragDataReceivedHandler (DragDataReceivedCb);

			Add (image);
			image.Show ();
		}

		public void Save (string filename)
		{
			if (large_covers.ContainsKey (stamp)) {
				((Pixbuf)large_covers[stamp]).Save (filename, "jpeg");
			}
		}

		public bool CheckFilesystemForAlbumArt (string path)
		{
			if (UserPixbuf) {
				return false;
			}

			foreach (string file in CoverFilenames)
			{
				FileInfo cover = new FileInfo (System.IO.Path.Combine (path, file));
				
				if (cover.Exists) {
					Pixbuf buf = BeautifyPixbuf (new Pixbuf (cover.ToString ()));					
					if (buf != null) {
						UserPixbuf = true;
						original = buf;
						Refresh ();
						return true;
					}
				}	
			}
			return false;
		}

		public void Refresh ()
		{
			image.Pixbuf = original;
		}

		public void Download ()
		{
			stamp = GetStamp (Runtime.Database.GlobalData);
			if (!UserPixbuf) {
				if (covers.ContainsKey (stamp)) {
					original = covers[stamp] as Pixbuf;
					if (original == null) {
						ShowDefaultCover ();
						return;
					}
					Refresh ();
				} else {
					ShowLoadingCover ();
					Runtime.Dispatcher.BackgroundDispatch (new VoidHandler (AmazonDownload));
				}
			}
		}

		public void ShowDefaultCover ()
		{
			original = defaultcover;
			Refresh ();
		}

		public void Clear ()
		{
			ShowDefaultCover ();
			UserPixbuf = false;
		}

		/* private fields */
		Gtk.Image image;

		static Pixbuf defaultcover;
		static Pixbuf loadingcover;
		Pixbuf pixbuf;
		Pixbuf original;
		string stamp;

		Hashtable covers;
		Hashtable large_covers;
		
		bool UserPixbuf;

		static string DevTag = "1G1CFFX6R1ZWFXDMVJG2";

		static TargetEntry[] CoverDragEntries = new TargetEntry[] {
			new TargetEntry ("text/uri-list", 0, (uint)TargetType.UriList),
			new TargetEntry ("x-special/gnome-icon-list", 0, (uint)TargetType.UriList),
			new TargetEntry ("_NETSCAPE_URL", 0, (uint)TargetType.Uri)
		};

		static string[] CoverFilenames = {"cover.jpg",
		                                  "Cover.jpg",
		                                  "cover.jpeg",
		                                  "Cover.jpeg",
		                                  "cover.png",
		                                  "Cover.png",
		                                  "cover.gif",
		                                  "Cover.gif",
		                                  "cover.bmp",
		                                  "Cover.bmp",
		                                  "folder.jpg",
		                                  "Folder.jpg",
		                                  "folder.jpeg",
		                                  "Folder.jpeg",
		                                  ".folder.png",
		                                  "folder.png",
		                                  "Folder.png"};

		enum TargetType {
			UriList,
			Uri
		};

		/* private methods */
		private void ShowLoadingCover ()
		{
			original = loadingcover;
			Refresh ();
		}

		private void AmazonDownload ()
		{
			try {
				pixbuf = GetCoverFromAmazon ();
			} catch (Exception e) {
				pixbuf = null;

				Runtime.Debug (e.Message);
				Runtime.Debug (e.StackTrace);
			}
			GLib.Idle.Add (new GLib.IdleHandler (ProcessAmazonDownload));
		}

		private bool ProcessAmazonDownload ()
		{
			lock (this) {
				if (pixbuf == null) {
					original = null;
					covers[stamp] = null;
					ShowDefaultCover ();
					return false;
				}

				large_covers[stamp] = pixbuf;
				original = BeautifyPixbuf (pixbuf);
				covers[stamp] = original; 
				Refresh ();
			}
			return false;
		}

		private Pixbuf BeautifyPixbuf (Pixbuf cover)
		{
			Pixbuf border;

			/* 1px border, so -2 .. */
			int target_size = 64;

			/* scale the cover image if necessary */
			if (cover.Height > target_size || cover.Width > target_size) {
				int new_width, new_height;

				if (cover.Height > cover.Width) {
					new_width = (int)Math.Round ((double)target_size / (double)cover.Height * cover.Width);
					new_height = target_size;
				} else {
					new_height = (int)Math.Round ((double)target_size / (double)cover.Width * cover.Height);
					new_width = target_size;
				}

				cover = cover.ScaleSimple (new_width, new_height, InterpType.Bilinear);
			}

			/* create the background + black border pixbuf */
			border = new Pixbuf (Colorspace.Rgb, true, 8, cover.Width + 2, cover.Height + 2);
			border.Fill (0x000000ff);
				
			/* put the cover image on the border area */
			cover.CopyArea (0, 0, cover.Width, cover.Height, border, 1, 1);

			/* done */
			return border;
		}

		/*
		 * TODO: Rewrite this code based on AmazonMetadataProxy
		 */
		private Pixbuf GetCoverFromAmazon ()
		{
			Song song = Runtime.Database.GlobalData;

			AmazonSearchService search_service = new AmazonSearchService ();

			string sane_album_title = SanitizeString (song.Album);

			string [] album_title_array = sane_album_title.Split (' ');
			Array.Sort (album_title_array);

			/* This assumes the right artist is always in Artists [0] */
			string sane_artist = SanitizeString (song.Artist);
			
			/* Prepare for handling multi-page results */
			int total_pages = 1;
			int current_page = 1;
			int max_pages = 2; /* check no more than 2 pages */
			
			/* Create Encapsulated Request */
			ArtistRequest asearch = new ArtistRequest ();
			asearch.devtag = DevTag;

			if (!Runtime.Database.MultipleArtists)
				asearch.artist = sane_artist;
			else
				asearch.artist = "Various Artists";

			asearch.keywords = sane_album_title;
			asearch.type = "heavy";
			asearch.mode = "music";
			asearch.tag = "webservices-20";

			/* Use selected Amazon service */
			search_service.Url = "http://soap.amazon.com/onca/soap3";

			double best_match_percent = 0.0;
			Pixbuf best_match = null;

			while (current_page <= total_pages && current_page <= max_pages)
			{
				asearch.page = Convert.ToString (current_page);

				ProductInfo pi;
				
				/* Amazon API requires this .. */
				System.Threading.Thread.Sleep (1000);
			
				/* Web service calls timeout after 30 seconds */
				search_service.Timeout = 30000;
				
				/* This may throw an exception, we catch it in Song.cs in the calling function */
				pi = search_service.ArtistSearchRequest (asearch);

				int num_results = pi.Details.Length;
				total_pages = Convert.ToInt32 (pi.TotalPages);

				/* Work out how many matches are on this page */
				if (num_results < 1)
					return null;

				for (int i = 0; i < num_results; i++)
				{
					/* Ignore bracketed text on the result from Amazon */
					string sane_product_name = SanitizeString (pi.Details[i].ProductName);

					/* Compare the two strings statistically */
					string [] product_name_array = sane_product_name.Split (' ');
					Array.Sort (product_name_array);

					int match_count = 0;
					foreach (string s in album_title_array)
					{
						if (Array.BinarySearch (product_name_array, s) >= 0)
							match_count++;
					} 

					double match_percent;
					match_percent = match_count / (double) album_title_array.Length;

					if (match_percent >= 0.6) {
						string url = pi.Details[i].ImageUrlMedium;

						if (url != null && url.Length > 0) {
							double backward_match_percent = 0.0;
							int backward_match_count = 0;

							foreach (string s in product_name_array)
							{
								if (Array.BinarySearch (album_title_array, s) >= 0)
									backward_match_count++;
							}

							backward_match_percent = backward_match_count / (double) product_name_array.Length;

							double total_match_percent = match_percent + backward_match_percent;

							if (total_match_percent > best_match_percent) {
								Pixbuf pix;
								
								try {
									pix = GetCoverFromUrl (url);
								} catch (WebException e) {
									throw e;
								} catch (Exception e) {
									pix = null;
								}

								if (pix != null) {
									best_match_percent = total_match_percent;
									best_match = pix;

									if (best_match_percent == 2.0)
										return best_match;
								}
							}
							// ELSE keep iterating to find a better match
						}
					}
				}

				current_page++;
			}

			return best_match;
		}

		private Pixbuf GetCoverFromUrl (string url)
		{
			Pixbuf cover;

			/* read the cover image */
			HttpWebRequest req = (HttpWebRequest) WebRequest.Create (url);
			req.UserAgent = "Cowbell";
			req.KeepAlive = false;
			req.Timeout = 30000; /* Timeout after 30 seconds */
				
			WebResponse resp = null;
		
			/*
			 * May throw an exception, but we catch it in the calling
			 * function in Song.cs 
			 */
			resp = req.GetResponse ();

			Stream s = resp.GetResponseStream ();
		
			cover = new Pixbuf (s);

			resp.Close ();

			/* Trap Amazon 1x1 images */
			if (cover.Height == 1 && cover.Width == 1)
				return null;

			return cover;
		}

		private Pixbuf GetCoverLocal (string path)
		{
			Pixbuf cover;

			try {
				cover = new Pixbuf (path);
			} catch (Exception e) {
				return null;
			}

			return cover;
		}

		private string SanitizeString (string s)
		{
			s = s.ToLower ();
			s = Regex.Replace (s, "\\(.*\\)", "");
			s = Regex.Replace (s, "\\[.*\\]", "");
			s = s.Replace ("-", " ");
			s = s.Replace ("_", " ");

			return s;
		}

		/* DnD Callbacks mostly stolen from Jorn Baayen */
		private void DragDataReceivedCb (object o, DragDataReceivedArgs args)
		{
			string selectiondata;
			bool success = false;
			string[] tokens;
			string path;

			selectiondata = System.Text.Encoding.UTF8.GetString (args.SelectionData.Data);

			switch (args.Info) {
			case (uint)TargetType.Uri:
				tokens = Regex.Split (selectiondata, "\n");
				SafeUri uri = new SafeUri (tokens[0]);
				
				if (uri.Scheme != "http")
					break;

				try {
					original = GetCoverFromUrl (SafeUri.UriToFilename (uri));
					UserPixbuf = true;
					success = true;
				} catch (Exception e) {
					success = false;
					break;
				}

				break;
			
			case (uint)TargetType.UriList:
				tokens = Regex.Split (selectiondata, "\r\n");		
				path = SafeUri.UriToFilename (tokens[0]);

				if (path == null)
					break;
			
				try {
					original = GetCoverLocal (path);
					UserPixbuf = true;
					success = true;
				} catch (Exception e) {
					success = false;
					break;
				}

				break;
			}

			if (success) {
				large_covers[stamp] = original;
				original = BeautifyPixbuf (original);
				covers[stamp] = original;
				Refresh ();
			}
	
			Gtk.Drag.Finish (args.Context, success, false, args.Time);
		}

		private string GetStamp (Song s)
		{
			if (s != null) {
				return s.ArtistAlbumStamp;
			}
			return "0";
		}
	}
}
