#
# Finds the gSOAP package installation or build tree
#
# Produces
#   GSOAP_FOUND         - boolean variable to tell if the package was found
#   GSOAP_LIBRARIES     - path of the gsoapssl++ library
#   GSOAP_INCLUDE_DIRS  - include directory of the gSOAP installation
#


find_library(GSOAP_LIBRARY NAMES gsoapssl)
find_path(GSOAP_INCLUDE_DIR stdsoap2.h)

include(FindPackageHandleStandardArgs)
find_package_handle_standard_args(GSOAP DEFAULT_MSG GSOAP_LIBRARY GSOAP_INCLUDE_DIR)

if(GSOAP_FOUND)
    set(GSOAP_LIBRARIES ${GSOAP_LIBRARY})
    set(GSOAP_INCLUDE_DIRS ${GSOAP_INCLUDE_DIR})
endif(GSOAP_FOUND)

