// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.

using System;
using System.Collections.Generic;

static class AdvSimdTests
{

    public static (string templateFileName, Dictionary<string, string> templateData)[] AdvSimdInputs =
    {
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Abs_Vector64_Int16",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "(short)-TestLibrary.Generator.GetInt16()",                                                                                                                                               ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Abs_Vector64_Int32",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Abs_Vector64_SByte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "(sbyte)-TestLibrary.Generator.GetSByte()",                                                                                                                                               ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Abs_Vector64_Single",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "-TestLibrary.Generator.GetSingle()",                                                                                                                                                     ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Abs(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Abs_Vector128_Int16",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(short)-TestLibrary.Generator.GetInt16()",                                                                                                                                               ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Abs_Vector128_Int32",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Abs_Vector128_SByte",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "(sbyte)-TestLibrary.Generator.GetSByte()",                                                                                                                                               ["ValidateIterResult"] = "Helpers.Abs(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Abs_Vector128_Single",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Abs",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "-TestLibrary.Generator.GetSingle()",                                                                                                                                                     ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Abs(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AbsSaturate_Vector64_Int16",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "Int16.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.AbsSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AbsSaturate_Vector64_Int32",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "Int32.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.AbsSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AbsSaturate_Vector64_SByte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "SByte.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.AbsSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AbsSaturate_Vector128_Int16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "Int16.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.AbsSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AbsSaturate_Vector128_Int32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "Int32.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.AbsSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AbsSaturate_Vector128_SByte",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "SByte.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.AbsSaturate(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "AbsScalar_Vector64_Double",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsScalar",                                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "-TestLibrary.Generator.GetDouble()",                                                                                                                                                     ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Abs(firstOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                                 ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "AbsScalar_Vector64_Single",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsScalar",                                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.Abs(firstOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                                 ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteCompareGreaterThan_Vector64_Single",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteCompareGreaterThan",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteCompareGreaterThan(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteCompareGreaterThan_Vector128_Single",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteCompareGreaterThan",                                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteCompareGreaterThan(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteCompareGreaterThanOrEqual_Vector64_Single",                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteCompareGreaterThanOrEqual",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteCompareGreaterThanOrEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteCompareGreaterThanOrEqual_Vector128_Single",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteCompareGreaterThanOrEqual",                                    ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteCompareGreaterThanOrEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteCompareLessThan_Vector64_Single",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteCompareLessThan",                                              ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteCompareLessThan(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteCompareLessThan_Vector128_Single",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteCompareLessThan",                                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteCompareLessThan(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteCompareLessThanOrEqual_Vector64_Single",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteCompareLessThanOrEqual",                                       ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteCompareLessThanOrEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteCompareLessThanOrEqual_Vector128_Single",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteCompareLessThanOrEqual",                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteCompareLessThanOrEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector64_Byte",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector64_Int16",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector64_Int32",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector64_SByte",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector64_Single",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteDifference(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector64_UInt16",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector64_UInt32",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector128_Byte",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector128_Int16",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector128_Int32",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector128_SByte",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector128_Single",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AbsoluteDifference(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector128_UInt16",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifference_Vector128_UInt32",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifference",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AbsoluteDifference(left[i], right[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector64_Byte",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector64_Int16",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector64_Int32",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector64_SByte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector64_UInt16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector64_UInt32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector128_Byte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector128_Int16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector128_Int32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector128_SByte",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector128_UInt16",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceAdd_Vector128_UInt32",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceAdd",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLower_Vector64_Byte",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLower",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLower_Vector64_Int16",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLower",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLower_Vector64_Int32",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLower",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLower_Vector64_SByte",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLower",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLower_Vector64_UInt16",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLower",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLower_Vector64_UInt32",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLower",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWidening(left[i], right[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLowerAndAdd_Vector64_Byte",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLowerAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningAndAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLowerAndAdd_Vector64_Int16",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLowerAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningAndAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLowerAndAdd_Vector64_Int32",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLowerAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningAndAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLowerAndAdd_Vector64_SByte",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLowerAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningAndAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLowerAndAdd_Vector64_UInt16",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLowerAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningAndAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningLowerAndAdd_Vector64_UInt32",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningLowerAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningAndAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpper_Vector128_Byte",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpper",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpper_Vector128_Int16",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpper",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpper_Vector128_Int32",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpper",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpper_Vector128_SByte",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpper",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpper_Vector128_UInt16",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpper",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpper_Vector128_UInt32",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpper",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpper(left, right, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpperAndAdd_Vector128_Byte",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpperAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpperAndAdd_Vector128_Int16",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpperAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpperAndAdd_Vector128_Int32",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpperAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpperAndAdd_Vector128_SByte",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpperAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpperAndAdd_Vector128_UInt16",                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpperAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AbsoluteDifferenceWideningUpperAndAdd_Vector128_UInt32",                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AbsoluteDifferenceWideningUpperAndAdd",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.AbsoluteDifferenceWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector64_Byte",                                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector64_Int16",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector64_Int32",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector64_SByte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector64_Single",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Add(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector64_UInt16",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector64_UInt32",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector128_Byte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector128_Int16",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector128_Int32",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector128_Int64",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector128_SByte",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector128_Single",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Add(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector128_UInt16",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector128_UInt32",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Add_Vector128_UInt64",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Add",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.Add(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingLower_Vector64_Byte",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddHighNarrowing<ushort, byte>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingLower_Vector64_Int16",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddHighNarrowing<int, short>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingLower_Vector64_Int32",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.AddHighNarrowing<long, int>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingLower_Vector64_SByte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddHighNarrowing<short, sbyte>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingLower_Vector64_UInt16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddHighNarrowing<uint, ushort>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingLower_Vector64_UInt32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.AddHighNarrowing<ulong, uint>(left[i], right[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingUpper_Vector128_Byte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.AddHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingUpper_Vector128_Int16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.AddHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingUpper_Vector128_Int32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.AddHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingUpper_Vector128_SByte",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.AddHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingUpper_Vector128_UInt16",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.AddHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddHighNarrowingUpper_Vector128_UInt32",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddHighNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidateIterResult"] = "Helpers.AddHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwise_Vector64_Byte",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwise_Vector64_Int16",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwise_Vector64_Int32",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwise_Vector64_SByte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwise_Vector64_Single",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.AddPairwise(left, right, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwise_Vector64_UInt16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwise_Vector64_UInt32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwise(left, right, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector64_Byte",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector64_Int16",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector64_SByte",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector64_UInt16",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector128_Byte",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector128_Int16",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector128_Int32",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector128_SByte",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector128_UInt16",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWidening_Vector128_UInt32",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWidening",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.AddPairwiseWidening(firstOp, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector64_Byte",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector64_Int16",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector64_SByte",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector64_UInt16",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector128_Byte",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector128_Int16",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector128_Int32",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector128_SByte",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector128_UInt16",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAdd_Vector128_UInt32",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAdd",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, i) != result[i]"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAddScalar_Vector64_Int32",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAddScalar",                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateFirstResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, 0) != result[0]",                                                                                                       ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningAndAddScalar_Vector64_UInt32",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningAndAddScalar",                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateFirstResult"] = "Helpers.AddPairwiseWideningAndAdd(left, right, 0) != result[0]",                                                                                                       ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningScalar_Vector64_Int32",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningScalar",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateFirstResult"] = "Helpers.AddPairwiseWidening(firstOp, 0) != result[0]",                                                                                                                 ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "AddPairwiseWideningScalar_Vector64_UInt32",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddPairwiseWideningScalar",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.AddPairwiseWidening(firstOp, 0) != result[0]",                                                                                                                 ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingLower_Vector64_Byte",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingLower",                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowing<ushort, byte>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingLower_Vector64_Int16",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingLower",                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowing<int, short>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingLower_Vector64_Int32",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingLower",                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowing<long, int>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingLower_Vector64_SByte",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingLower",                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowing<short, sbyte>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingLower_Vector64_UInt16",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingLower",                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowing<uint, ushort>(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingLower_Vector64_UInt32",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingLower",                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowing<ulong, uint>(left[i], right[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingUpper_Vector128_Byte",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingUpper",                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingUpper_Vector128_Int16",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingUpper",                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingUpper_Vector128_Int32",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingUpper",                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingUpper_Vector128_SByte",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingUpper",                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingUpper_Vector128_UInt16",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingUpper",                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "AddRoundedHighNarrowingUpper_Vector128_UInt32",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddRoundedHighNarrowingUpper",                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidateIterResult"] = "Helpers.AddRoundedHighNarrowingUpper(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector64_Byte_Vector64_Byte",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector64_Int16_Vector64_Int16",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector64_Int32_Vector64_Int32",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector64_SByte_Vector64_SByte",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector64_UInt16_Vector64_UInt16",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector64_UInt32_Vector64_UInt32",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector128_Byte_Vector128_Byte",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector128_Int16_Vector128_Int16",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector128_Int32_Vector128_Int32",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector128_Int64_Vector128_Int64",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector128_SByte_Vector128_SByte",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector128_UInt16_Vector128_UInt16",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector128_UInt32_Vector128_UInt32",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddSaturate_Vector128_UInt64_Vector128_UInt64",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturate",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.AddSaturate(left[i], right[i]) != result[i]"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddSaturateScalar_Vector64_Int64_Vector64_Int64",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturateScalar",                                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateFirstResult"] = "Helpers.AddSaturate(left[0], right[0]) != result[0]",                                                                                                                  ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddSaturateScalar_Vector64_UInt64_Vector64_UInt64",                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddSaturateScalar",                                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateFirstResult"] = "Helpers.AddSaturate(left[0], right[0]) != result[0]",                                                                                                                  ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddScalar_Vector64_Double",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddScalar",                                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Add(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                          ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddScalar_Vector64_Int64",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddScalar",                                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateFirstResult"] = "Helpers.Add(left[0], right[0]) != result[0]",                                                                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddScalar_Vector64_Single",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddScalar",                                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.Add(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                          ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "AddScalar_Vector64_UInt64",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddScalar",                                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateFirstResult"] = "Helpers.Add(left[0], right[0]) != result[0]",                                                                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector64_Byte",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector64_Int16",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector64_Int32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector64_SByte",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector64_UInt16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector64_UInt32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector128_Int16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector128_Int32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector128_Int64",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector128_UInt16",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector128_UInt32",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningLower_Vector128_UInt64",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningLower",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_Byte_Vector128_Byte",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_Int16_Vector128_Int16",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_Int16_Vector128_SByte",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_Int32_Vector128_Int16",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_Int32_Vector128_Int32",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_Int64_Vector128_Int32",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_SByte_Vector128_SByte",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_UInt16_Vector128_Byte",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_UInt16_Vector128_UInt16",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_UInt32_Vector128_UInt16",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_UInt32_Vector128_UInt32",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "AddWideningUpper_Vector128_UInt64_Vector128_UInt32",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "AddWideningUpper",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.AddWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_Byte",                                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_Double",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.And(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_Int16",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_Int32",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_Int64",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_SByte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_Single",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.And(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_UInt16",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_UInt32",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector64_UInt64",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_Byte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_Double",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.And(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_Int16",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_Int32",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_Int64",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_SByte",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_Single",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.And(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_UInt16",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_UInt32",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "And_Vector128_UInt64",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "And",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.And(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_Byte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_Double",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.BitwiseClear(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_Int16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_Int32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_Int64",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_SByte",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_Single",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.BitwiseClear(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_UInt16",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_UInt32",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector64_UInt64",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_Byte",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_Double",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.BitwiseClear(left[i], right[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_Int16",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_Int32",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_Int64",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_SByte",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_Single",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.BitwiseClear(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_UInt16",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_UInt32",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "BitwiseClear_Vector128_UInt64",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseClear",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.BitwiseClear(left[i], right[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_Byte",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_Double",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                        ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_Int16",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_Int32",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_Int64",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_SByte",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_Single",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_UInt16",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_UInt32",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector64_UInt64",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_Byte",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_Double",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                        ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_Int16",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_Int32",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_Int64",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_SByte",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_Single",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_UInt16",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_UInt32",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "BitwiseSelect_Vector128_UInt64",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "BitwiseSelect",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidateIterResult"] = "Helpers.BitwiseSelect(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Ceiling_Vector64_Single",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Ceiling",                                                              ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Ceiling(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Ceiling_Vector128_Single",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Ceiling",                                                              ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Ceiling(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "CeilingScalar_Vector64_Double",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CeilingScalar",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Ceiling(firstOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                             ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "CeilingScalar_Vector64_Single",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CeilingScalar",                                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.Ceiling(firstOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector64_Byte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector64_Int16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector64_Int32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector64_SByte",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector64_Single",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector64_UInt16",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector64_UInt32",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector128_Byte",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector128_Int16",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector128_Int32",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector128_SByte",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector128_Single",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector128_UInt16",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareEqual_Vector128_UInt32",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareEqual",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector64_Byte",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector64_Int16",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector64_Int32",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector64_SByte",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector64_Single",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareGreaterThan(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector64_UInt16",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector64_UInt32",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector128_Byte",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector128_Int16",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector128_Int32",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector128_SByte",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector128_Single",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareGreaterThan(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector128_UInt16",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThan_Vector128_UInt32",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThan",                                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareGreaterThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector64_Byte",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector64_Int16",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector64_Int32",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector64_SByte",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector64_Single",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareGreaterThanOrEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector64_UInt16",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector64_UInt32",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector128_Byte",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector128_Int16",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector128_Int32",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector128_SByte",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector128_Single",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareGreaterThanOrEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector128_UInt16",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareGreaterThanOrEqual_Vector128_UInt32",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareGreaterThanOrEqual",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareGreaterThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector64_Byte",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector64_Int16",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector64_Int32",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector64_SByte",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector64_Single",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareLessThan(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector64_UInt16",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector64_UInt32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector128_Byte",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector128_Int16",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector128_Int32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector128_SByte",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector128_Single",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareLessThan(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector128_UInt16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThan_Vector128_UInt32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThan",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareLessThan(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector64_Byte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector64_Int16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector64_Int32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector64_SByte",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector64_Single",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareLessThanOrEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector64_UInt16",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector64_UInt32",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector128_Byte",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector128_Int16",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector128_Int32",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector128_SByte",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector128_Single",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareLessThanOrEqual(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector128_UInt16",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareLessThanOrEqual_Vector128_UInt32",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareLessThanOrEqual",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareLessThanOrEqual(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector64_Byte",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector64_Int16",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector64_Int32",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector64_SByte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector64_Single",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareTest(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector64_UInt16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector64_UInt32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector128_Byte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector128_Int16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector128_Int32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector128_SByte",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector128_Single",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.CompareTest(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector128_UInt16",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "CompareTest_Vector128_UInt32",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "CompareTest",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.CompareTest(left[i], right[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundAwayFromZero_Vector64_Single",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundAwayFromZero",                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundAwayFromZero(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundAwayFromZero_Vector128_Single",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundAwayFromZero",                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundAwayFromZero(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundAwayFromZeroScalar_Vector64_Single",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundAwayFromZeroScalar",                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToInt32RoundAwayFromZero(firstOp[0]) != result[0]",                                                                                                     ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToEven_Vector64_Single",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToEven",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundToEven(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToEven_Vector128_Single",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToEven",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundToEven(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToEvenScalar_Vector64_Single",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToEvenScalar",                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToInt32RoundToEven(firstOp[0]) != result[0]",                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToNegativeInfinity_Vector64_Single",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToNegativeInfinity",                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundToNegativeInfinity(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToNegativeInfinity_Vector128_Single",                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToNegativeInfinity",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundToNegativeInfinity(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToNegativeInfinityScalar_Vector64_Single",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToNegativeInfinityScalar",                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToInt32RoundToNegativeInfinity(firstOp[0]) != result[0]",                                                                                               ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToPositiveInfinity_Vector64_Single",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToPositiveInfinity",                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundToPositiveInfinity(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToPositiveInfinity_Vector128_Single",                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToPositiveInfinity",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundToPositiveInfinity(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToPositiveInfinityScalar_Vector64_Single",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToPositiveInfinityScalar",                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToInt32RoundToPositiveInfinity(firstOp[0]) != result[0]",                                                                                               ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToZero_Vector64_Single",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToZero",                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundToZero(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToZero_Vector128_Single",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToZero",                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToInt32RoundToZero(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToInt32RoundToZeroScalar_Vector64_Single",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToInt32RoundToZeroScalar",                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToInt32RoundToZero(firstOp[0]) != result[0]",                                                                                                           ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToSingle_Vector64_Int32",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToSingle",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.ConvertToSingle(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToSingle_Vector64_UInt32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToSingle",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.ConvertToSingle(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToSingle_Vector128_Int32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToSingle",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.ConvertToSingle(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToSingle_Vector128_UInt32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToSingle",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.ConvertToSingle(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToSingleScalar_Vector64_Int32",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToSingleScalar",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.ConvertToSingle(firstOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToSingleScalar_Vector64_UInt32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToSingleScalar",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.ConvertToSingle(firstOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundAwayFromZero_Vector64_Single",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundAwayFromZero",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundAwayFromZero(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundAwayFromZero_Vector128_Single",                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundAwayFromZero",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundAwayFromZero(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundAwayFromZeroScalar_Vector64_Single",                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundAwayFromZeroScalar",                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToUInt32RoundAwayFromZero(firstOp[0]) != result[0]",                                                                                                    ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToEven_Vector64_Single",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToEven",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundToEven(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToEven_Vector128_Single",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToEven",                                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundToEven(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToEvenScalar_Vector64_Single",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToEvenScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToUInt32RoundToEven(firstOp[0]) != result[0]",                                                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToNegativeInfinity_Vector64_Single",                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToNegativeInfinity",                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundToNegativeInfinity(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToNegativeInfinity_Vector128_Single",                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToNegativeInfinity",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundToNegativeInfinity(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToNegativeInfinityScalar_Vector64_Single",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToNegativeInfinityScalar",                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToUInt32RoundToNegativeInfinity(firstOp[0]) != result[0]",                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToPositiveInfinity_Vector64_Single",                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToPositiveInfinity",                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundToPositiveInfinity(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToPositiveInfinity_Vector128_Single",                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToPositiveInfinity",                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundToPositiveInfinity(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToPositiveInfinityScalar_Vector64_Single",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToPositiveInfinityScalar",                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToUInt32RoundToPositiveInfinity(firstOp[0]) != result[0]",                                                                                              ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToZero_Vector64_Single",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToZero",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundToZero(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToZero_Vector128_Single",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToZero",                                           ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ConvertToUInt32RoundToZero(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "ConvertToUInt32RoundToZeroScalar_Vector64_Single",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ConvertToUInt32RoundToZeroScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "Helpers.ConvertToUInt32RoundToZero(firstOp[0]) != result[0]",                                                                                                          ["ValidateRemainingResults"] = "result[i] != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "DivideScalar_Vector64_Double",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DivideScalar",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Divide(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                       ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "DivideScalar_Vector64_Single",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DivideScalar",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.Divide(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                       ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector64_Byte_1",                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector64_Int16_1",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector64_Int32_1",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector64_SByte_1",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector64_Single_1",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector64_UInt16_1",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector64_UInt32_1",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector128_Byte_8",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["Imm"] = "8",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector128_Int16_4",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "4",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector128_Int32_2",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "2",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector128_SByte_8",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["Imm"] = "8",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector128_Single_2",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["Imm"] = "2",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector128_UInt16_4",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "4",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector64_Vector128_UInt32_2",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector64",                                    ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "2",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector64_Byte_1",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector64_Int16_1",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector64_Int32_1",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector64_SByte_1",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector64_Single_1",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector64_UInt16_1",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector64_UInt32_1",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector128_Byte_8",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["Imm"] = "8",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector128_Int16_4",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "4",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector128_Int32_2",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "2",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector128_SByte_8",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["Imm"] = "8",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector128_Single_2",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["Imm"] = "2",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector128_UInt16_4",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "4",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("VecImmUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "DuplicateSelectedScalarToVector128_Vector128_UInt32_2",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateSelectedScalarToVector128",                                   ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "2",                                                                                                                                ["ValidateIterResult"] = "firstOp[Imm] != result[i]"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_Byte",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_Byte_31",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_Int16",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",                                    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_Int16_31",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",                                    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_Int32",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_Int32_31",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_SByte",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",                                    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_SByte_31",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",                                    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_Single",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",                                   ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_Single_31",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",                                   ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_UInt16",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_UInt16_31",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_UInt32",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector64_UInt32_31",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector64",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_Byte",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_Byte_31",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",                                     ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_Int16",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",                                    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_Int16_31",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",                                    ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_Int32",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_Int32_31",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",                                    ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_SByte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",                                    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_SByte_31",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",                                    ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_Single",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",                                   ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_Single_31",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",                                   ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_UInt16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_UInt16_31",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",                                   ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("DuplicateTest.template",            new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_UInt32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateFirstResult"] = "result[0] != data",                                                                                                                                                    ["ValidateRemainingResults"] = "result[i] != data"}),
        ("ImmOpTest.template",                new Dictionary<string, string> { ["TestName"] = "DuplicateToVector128_UInt32_31",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "DuplicateToVector128",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",                                   ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["Imm"] = "31",                                                                                                                                                                                              ["ValidateFirstResult"] = "result[0] != 31",                                                                                                                                                      ["ValidateRemainingResults"] = "result[i] != 31"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector64_Byte_1",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector64_Int16_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector64_Int32_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector64_SByte_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector64_Single_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "BitConverter.SingleToInt32Bits(firstOp[ElementIndex]) != BitConverter.SingleToInt32Bits(result)"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector64_UInt16_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector64_UInt32_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_Byte_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_Double_1",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "BitConverter.DoubleToInt64Bits(firstOp[ElementIndex]) != BitConverter.DoubleToInt64Bits(result)"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_Int16_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_Int32_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_Int64_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_SByte_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_Single_1",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "BitConverter.SingleToInt32Bits(firstOp[ElementIndex]) != BitConverter.SingleToInt32Bits(result)"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_UInt16_1",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_UInt32_1",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("ExtractTest.template",              new Dictionary<string, string> { ["TestName"] = "Extract_Vector128_UInt64_1",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Extract",                                                                                                                        ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["ElementIndex"] = "1",                                                                                                                       ["ValidateResult"] = "firstOp[ElementIndex] != result"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingLower_Vector64_Byte",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ExtractNarrowing(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingLower_Vector64_Int16",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowing(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingLower_Vector64_Int32",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowing(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingLower_Vector64_SByte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowing(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingLower_Vector64_UInt16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ExtractNarrowing(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingLower_Vector64_UInt32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingLower",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ExtractNarrowing(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateLower_Vector64_Byte",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateLower",                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateLower_Vector64_Int16",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateLower",                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateLower_Vector64_Int32",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateLower",                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateLower_Vector64_SByte",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateLower",                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateLower_Vector64_UInt16",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateLower",                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateLower_Vector64_UInt32",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateLower",                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUnsignedLower_Vector64_Byte",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUnsignedLower",                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUnsigned(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUnsignedLower_Vector64_UInt16",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUnsignedLower",                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUnsigned(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUnsignedLower_Vector64_UInt32",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUnsignedLower",                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUnsigned(firstOp[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUnsignedUpper_Vector128_Byte",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUnsignedUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUnsignedUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUnsignedUpper_Vector128_UInt16",                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUnsignedUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUnsignedUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUnsignedUpper_Vector128_UInt32",                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUnsignedUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUnsignedUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUpper_Vector128_Byte",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUpper",                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUpper_Vector128_Int16",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUpper",                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUpper_Vector128_Int32",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUpper",                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUpper_Vector128_SByte",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUpper",                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUpper_Vector128_UInt16",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUpper",                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingSaturateUpper_Vector128_UInt32",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingSaturateUpper",                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingSaturateUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingUpper_Vector128_Byte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingUpper_Vector128_Int16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractNarrowingUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingUpper_Vector128_Int32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractNarrowingUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingUpper_Vector128_SByte",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.ExtractNarrowingUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingUpper_Vector128_UInt16",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "ExtractNarrowingUpper_Vector128_UInt32",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractNarrowingUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",                                                                                       ["ValidateIterResult"] = "Helpers.ExtractNarrowingUpper(left, right, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector64_Byte_1",                                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector64",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector64_Int16_1",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector64",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector64_Int32_1",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector64",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector64_SByte_1",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector64",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector64_Single_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector64",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector64_UInt16_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector64",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector64_UInt32_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector64",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_Byte_1",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_Double_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i)) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_Int16_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_Int32_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_Int64_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int64",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt64()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_SByte_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_Single_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_UInt16_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_UInt32_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("ExtractVectorTest.template",        new Dictionary<string, string> { ["TestName"] = "ExtractVector128_UInt64_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "ExtractVector128",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt64",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt64()",        ["ElementIndex"] = "1",                                                        ["ValidateIterResult"] = "Helpers.ExtractVector(firstOp, secondOp, ElementIndex, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Floor_Vector64_Single",                                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Floor",                                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Floor(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Floor_Vector128_Single",                                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Floor",                                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Floor(firstOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "FloorScalar_Vector64_Double",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FloorScalar",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Floor(firstOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "FloorScalar_Vector64_Single",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FloorScalar",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.Floor(firstOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector64_Byte",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector64_Int16",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector64_Int32",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector64_SByte",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector64_UInt16",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector64_UInt32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector128_Byte",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector128_Int16",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector128_Int32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector128_SByte",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector128_UInt16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddHalving_Vector128_UInt32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddHalving",                                                      ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedAddHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector64_Byte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector64_Int16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector64_Int32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector64_SByte",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector64_UInt16",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector64_UInt32",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector128_Byte",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector128_Int16",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector128_Int32",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector128_SByte",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector128_UInt16",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedAddRoundedHalving_Vector128_UInt32",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedAddRoundedHalving",                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedAddRoundedHalving(left[i], right[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "FusedMultiplyAdd_Vector64_Single",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplyAdd",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "FusedMultiplyAdd_Vector128_Single",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplyAdd",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplyAdd(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "FusedMultiplyAddScalar_Vector64_Double",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplyAddScalar",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplyAdd(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "FusedMultiplyAddScalar_Vector64_Single",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplyAddScalar",                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplyAdd(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                           ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("SimpleTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "FusedMultiplyAddNegatedScalar_Vector64_Double",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplyAddNegatedScalar",                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplyAddNegated(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "FusedMultiplyAddNegatedScalar_Vector64_Single",                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplyAddNegatedScalar",                                        ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplyAddNegated(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "FusedMultiplySubtract_Vector64_Single",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplySubtract",                                                ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "FusedMultiplySubtract_Vector128_Single",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplySubtract",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplySubtract(firstOp[i], secondOp[i], thirdOp[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "FusedMultiplySubtractScalar_Vector64_Double",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplySubtractScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplySubtract(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",                      ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "FusedMultiplySubtractScalar_Vector64_Single",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplySubtractScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplySubtract(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.SingleToInt32Bits(result[0])",                      ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("SimpleTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "FusedMultiplySubtractNegatedScalar_Vector64_Double",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplySubtractNegatedScalar",                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                        ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.FusedMultiplySubtractNegated(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.DoubleToInt64Bits(result[0])",               ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "FusedMultiplySubtractNegatedScalar_Vector64_Single",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedMultiplySubtractNegatedScalar",                                   ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Single", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.FusedMultiplySubtractNegated(firstOp[0], secondOp[0], thirdOp[0])) != BitConverter.SingleToInt32Bits(result[0])",               ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector64_Byte",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector64_Int16",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector64_Int32",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector64_SByte",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector64_UInt16",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector64_UInt32",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector128_Byte",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector128_Int16",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector128_Int32",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector128_SByte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector128_UInt16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "FusedSubtractHalving_Vector128_UInt32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "FusedSubtractHalving",                                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.FusedSubtractHalving(left[i], right[i]) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector64_Byte_1",                                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector64_Int16_1",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector64_Int32_1",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector64_SByte_1",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector64_Single_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Insert(firstOp, ElementIndex, thirdOp, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector64_UInt16_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector64_UInt32_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_Byte_1",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_Double_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                        ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Insert(firstOp, ElementIndex, thirdOp, i)) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_Int16_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_Int32_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_Int64_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_SByte_1",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_Single_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Insert(firstOp, ElementIndex, thirdOp, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_UInt16_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_UInt32_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertTest.template",               new Dictionary<string, string> { ["TestName"] = "Insert_Vector128_UInt64_1",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Insert",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("InsertScalarTest.template",         new Dictionary<string, string> { ["TestName"] = "InsertScalar_Vector128_Double_1",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "InsertScalar",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                              ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Double", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                        ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Insert(firstOp, ElementIndex, thirdOp[0], i)) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("InsertScalarTest.template",         new Dictionary<string, string> { ["TestName"] = "InsertScalar_Vector128_Int64_1",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "InsertScalar",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                               ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int64",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp[0], i) != result[i]"}),
        ("InsertScalarTest.template",         new Dictionary<string, string> { ["TestName"] = "InsertScalar_Vector128_UInt64_1",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "InsertScalar",                                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                              ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt64", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp[0], i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingSignCount_Vector64_Int16",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingSignBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingSignCount_Vector64_Int32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingSignBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingSignCount_Vector64_SByte",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingSignBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingSignCount_Vector128_Int16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingSignBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingSignCount_Vector128_Int32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingSignBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingSignCount_Vector128_SByte",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingSignCount",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingSignBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector64_Byte",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector64_Int16",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector64_Int32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector64_SByte",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector64_UInt16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector64_UInt32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector128_Byte",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector128_Int16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector128_Int32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector128_SByte",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector128_UInt16",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "LeadingZeroCount_Vector128_UInt32",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LeadingZeroCount",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "Helpers.CountLeadingZeroBits(firstOp[i]) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64_Byte_7",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64_Int16_3",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64_Int32_1",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64_SByte_7",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64_Single_1",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Insert(firstOp, ElementIndex, thirdOp, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64_UInt16_3",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64_UInt32_1",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_Byte_15",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "15",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_Double_1",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetDouble()",                        ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Insert(firstOp, ElementIndex, thirdOp, i)) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_Int16_7",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_Int32_3",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_Int64_1",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt64()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_SByte_15",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "15",                                       ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_Single_3",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Insert(firstOp, ElementIndex, thirdOp, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_UInt16_7",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_UInt32_3",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarTest.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector128_UInt64_1",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt64()",                        ["ValidateIterResult"] = "Helpers.Insert(firstOp, ElementIndex, thirdOp, i) != result[i]"}),
        ("LoadAndInsertScalarx2Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x2_Byte_7",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])"}),
        ("LoadAndInsertScalarx2Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x2_SByte_7",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])"}),
        ("LoadAndInsertScalarx2Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x2_Int16_3",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])"}),
        ("LoadAndInsertScalarx2Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x2_UInt16_3",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])"}),
        ("LoadAndInsertScalarx2Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x2_Int32_1",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])"}),
        ("LoadAndInsertScalarx2Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x2_UInt32_1",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])"}),
        ("LoadAndInsertScalarx2Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x2_Single_1",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "(BitConverter.SingleToInt32Bits(Helpers.Insert(input1, ElementIndex, newData[0], i)) != BitConverter.SingleToInt32Bits(result1[i])) || (BitConverter.SingleToInt32Bits(Helpers.Insert(input2, ElementIndex, newData[1], i)) != BitConverter.SingleToInt32Bits(result2[i]))"}),
        ("LoadAndInsertScalarx3Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x3_Byte_7",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])  || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])"}),
        ("LoadAndInsertScalarx3Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x3_SByte_7",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])  || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])"}),
        ("LoadAndInsertScalarx3Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x3_Int16_3",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])  || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])"}),
        ("LoadAndInsertScalarx3Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x3_UInt16_3",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])  || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])"}),
        ("LoadAndInsertScalarx3Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x3_Int32_1",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])  || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])"}),
        ("LoadAndInsertScalarx3Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x3_UInt32_1",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i])  || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])"}),
        ("LoadAndInsertScalarx3Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x3_Single_1",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "(BitConverter.SingleToInt32Bits(Helpers.Insert(input1, ElementIndex, newData[0], i)) != BitConverter.SingleToInt32Bits(result1[i])) || (BitConverter.SingleToInt32Bits(Helpers.Insert(input2, ElementIndex, newData[1], i)) != BitConverter.SingleToInt32Bits(result2[i])) || (BitConverter.SingleToInt32Bits(Helpers.Insert(input3, ElementIndex, newData[2], i)) != BitConverter.SingleToInt32Bits(result3[i]))"}),
        ("LoadAndInsertScalarx4Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x4_Byte_7",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i]) || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])  || (Helpers.Insert(input4, ElementIndex, newData[3], i) != result4[i])"}),
        ("LoadAndInsertScalarx4Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x4_SByte_7",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["ElementIndex"] = "7",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i]) || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])  || (Helpers.Insert(input4, ElementIndex, newData[3], i) != result4[i])"}),
        ("LoadAndInsertScalarx4Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x4_Int16_3",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i]) || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])  || (Helpers.Insert(input4, ElementIndex, newData[3], i) != result4[i])"}),
        ("LoadAndInsertScalarx4Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x4_UInt16_3",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["ElementIndex"] = "3",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i]) || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])  || (Helpers.Insert(input4, ElementIndex, newData[3], i) != result4[i])"}),
        ("LoadAndInsertScalarx4Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x4_Int32_1",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i]) || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])  || (Helpers.Insert(input4, ElementIndex, newData[3], i) != result4[i])"}),
        ("LoadAndInsertScalarx4Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x4_UInt32_1",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "(Helpers.Insert(input1, ElementIndex, newData[0], i) != result1[i]) || (Helpers.Insert(input2, ElementIndex, newData[1], i) != result2[i]) || (Helpers.Insert(input3, ElementIndex, newData[2], i) != result3[i])  || (Helpers.Insert(input4, ElementIndex, newData[3], i) != result4[i])"}),
        ("LoadAndInsertScalarx4Test.template",  new Dictionary<string, string> { ["TestName"] = "LoadAndInsertScalar_Vector64x4_Single_1",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndInsertScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["ElementIndex"] = "1",                                        ["NextValueOp3"] = "TestLibrary.Generator.GetSingle()",                        ["ValidateIterResult"] = "(BitConverter.SingleToInt32Bits(Helpers.Insert(input1, ElementIndex, newData[0], i)) != BitConverter.SingleToInt32Bits(result1[i])) || (BitConverter.SingleToInt32Bits(Helpers.Insert(input2, ElementIndex, newData[1], i)) != BitConverter.SingleToInt32Bits(result2[i])) || (BitConverter.SingleToInt32Bits(Helpers.Insert(input3, ElementIndex, newData[2], i)) != BitConverter.SingleToInt32Bits(result3[i])) || (BitConverter.SingleToInt32Bits(Helpers.Insert(input4, ElementIndex, newData[3], i)) != BitConverter.SingleToInt32Bits(result4[i]))"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64_Byte",                                                                       ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector64",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64_Int16",                                                                      ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector64",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64_Int32",                                                                      ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector64",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64_SByte",                                                                      ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector64",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64_Single",                                                                     ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector64",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64_UInt16",                                                                     ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector64",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64_UInt32",                                                                     ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector64",                                           ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector128_Byte",                                                                      ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector128",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector128_Int16",                                                                     ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector128",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector128_Int32",                                                                     ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector128",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector128_SByte",                                                                     ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector128",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector128_Single",                                                                    ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector128",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(firstOp[0]) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector128_UInt16",                                                                    ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector128",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector128_UInt32",                                                                    ["Isa"] = "AdvSimd",                                ["Method"] = "LoadAndReplicateToVector128",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[0] != result[i]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x2SByte",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x2",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x2Byte",                                                                      ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x2",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",                                                                                                                              ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x2UShort",                                                                    ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x2",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x2Short",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x2",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x2UInt32",                                                                    ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x2",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x2Int32",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x2",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x2Float",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x2",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "float",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x3SByte",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x3",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x3Byte",                                                                      ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x3",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",                                                                                                                              ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x3UShort",                                                                    ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x3",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x3Short",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x3",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x3UInt32",                                                                    ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x3",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x3Int32",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x3",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x3Float",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x3",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "float",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x4SByte",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x4",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2] || result4[i] != input[3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x4Byte",                                                                      ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x4",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",                                                                                                                              ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2] || result4[i] != input[3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x4UShort",                                                                    ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x4",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2] || result4[i] != input[3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x4Short",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x4",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2] || result4[i] != input[3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x4UInt32",                                                                    ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x4",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2] || result4[i] != input[3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x4Int32",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x4",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2] || result4[i] != input[3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "LoadAndReplicateToVector64x4Float",                                                                     ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd", ["Method"] = "LoadAndReplicateToVector64x4",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "float",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[0] || result2[i] != input[1] || result3[i] != input[2] || result4[i] != input[3]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_Byte",                                                                                     ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_Double",                                                                                   ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_Int16",                                                                                    ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_Int32",                                                                                    ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_Int64",                                                                                    ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_SByte",                                                                                    ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_Single",                                                                                   ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_UInt16",                                                                                   ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_UInt32",                                                                                   ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector64_UInt64",                                                                                   ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector64",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_Byte",                                                                                    ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_Double",                                                                                  ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(firstOp[i]) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_Int16",                                                                                   ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_Int32",                                                                                   ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_Int64",                                                                                   ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_SByte",                                                                                   ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_Single",                                                                                  ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_UInt16",                                                                                  ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_UInt32",                                                                                  ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadUnOpTest.template",             new Dictionary<string, string> { ["TestName"] = "LoadVector128_UInt64",                                                                                  ["Isa"] = "AdvSimd",                                ["Method"] = "LoadVector128",                                                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",                                                                                                                                                      ["ValidateIterResult"] = "firstOp[i] != result[i]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64SByte",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 8]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64Byte",                                                                                    ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",                                                                                                                              ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 8]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64UShort",                                                                                  ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 4]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64Short",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 4]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64UInt32",                                                                                  ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 2]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64Int32",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 2]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64Float",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "float",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64SByte",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 8] || result3[i] != input[i + 8 * 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64Byte",                                                                                    ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",                                                                                                                              ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 8] || result3[i] != input[i + 8 * 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64UShort",                                                                                  ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 4] || result3[i] != input[i + 4 * 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64Short",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 4] || result3[i] != input[i + 4 * 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64UInt32",                                                                                  ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 2] || result3[i] != input[i + 2 * 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64Int32",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 2] || result3[i] != input[i + 2 * 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64Float",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "float",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 2] || result3[i] != input[i + 2 * 2]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64SByte",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 8] || result3[i] != input[i + 8 * 2] || result4[i] != input[i + 8 * 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64Byte",                                                                                    ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",                                                                                                                              ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 8] || result3[i] != input[i + 8 * 2] || result4[i] != input[i + 8 * 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64UShort",                                                                                  ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 4] || result3[i] != input[i + 4 * 2] || result4[i] != input[i + 4 * 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64Short",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 4] || result3[i] != input[i + 4 * 2] || result4[i] != input[i + 4 * 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64UInt32",                                                                                  ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 2] || result3[i] != input[i + 2 * 2] || result4[i] != input[i + 2 * 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64Int32",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 2] || result3[i] != input[i + 2 * 2] || result4[i] != input[i + 2 * 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64Float",                                                                                   ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64",                                                                                                             ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "float",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i] || result2[i] != input[i + 2] || result3[i] != input[i + 2 * 2] || result4[i] != input[i + 2 * 3]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64AndUnzipSByte",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[(i * 2) + 1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64AndUnzipByte",                                                                            ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[(i * 2) + 1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64AndUnzipUShort",                                                                          ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[(i * 2) + 1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64AndUnzipShort",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[(i * 2) + 1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64AndUnzipUInt32",                                                                          ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[(i * 2) + 1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64AndUnzipInt32",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[(i * 2) + 1]"}),
        ("LoadVectorx2Test.template",         new Dictionary<string, string> { ["TestName"] = "Load2xVector64AndUnzipFloat",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load2xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "float",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i * 2] || result2[i] != input[(i * 2) + 1]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64AndUnzipSByte",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[(i * 3) + 1] || result3[i] != input[(i * 3) + 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64AndUnzipByte",                                                                            ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[(i * 3) + 1] || result3[i] != input[(i * 3) + 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64AndUnzipUShort",                                                                          ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[(i * 3) + 1] || result3[i] != input[(i * 3) + 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64AndUnzipShort",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[(i * 3) + 1] || result3[i] != input[(i * 3) + 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64AndUnzipUInt32",                                                                          ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[(i * 3) + 1] || result3[i] != input[(i * 3) + 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64AndUnzipInt32",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[(i * 3) + 1] || result3[i] != input[(i * 3) + 2]"}),
        ("LoadVectorx3Test.template",         new Dictionary<string, string> { ["TestName"] = "Load3xVector64AndUnzipFloat",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load3xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "float",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i * 3] || result2[i] != input[(i * 3) + 1] || result3[i] != input[(i * 3) + 2]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64AndUnzipSByte",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[(i * 4) + 1] || result3[i] != input[(i * 4) + 2] || result4[i] != input[(i * 4) + 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64AndUnzipByte",                                                                            ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[(i * 4) + 1] || result3[i] != input[(i * 4) + 2] || result4[i] != input[(i * 4) + 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64AndUnzipUShort",                                                                          ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt16",                                                                                                                           ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[(i * 4) + 1] || result3[i] != input[(i * 4) + 2] || result4[i] != input[(i * 4) + 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64AndUnzipShort",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[(i * 4) + 1] || result3[i] != input[(i * 4) + 2] || result4[i] != input[(i * 4) + 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64AndUnzipUInt32",                                                                          ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "UInt32",                                                                                                                           ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[(i * 4) + 1] || result3[i] != input[(i * 4) + 2] || result4[i] != input[(i * 4) + 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64AndUnzipInt32",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[(i * 4) + 1] || result3[i] != input[(i * 4) + 2] || result4[i] != input[(i * 4) + 3]"}),
        ("LoadVectorx4Test.template",         new Dictionary<string, string> { ["TestName"] = "Load4xVector64AndUnzipFloat",                                                                           ["Isa"] = "AdvSimd", ["LoadIsa"] = "AdvSimd",       ["Method"] = "Load4xVector64AndUnzip",                                                                                                                    ["Op1VectorType"] = "Vector64", ["Op1BaseType"] = "float",                                                                                                                            ["LargestVectorSize"] = "8",                                                                 ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "result1[i] != input[i * 4] || result2[i] != input[(i * 4) + 1] || result3[i] != input[(i * 4) + 2] || result4[i] != input[(i * 4) + 3]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector64_Byte",                                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector64_Int16",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector64_Int32",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector64_SByte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector64_Single",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Max(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector64_UInt16",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector64_UInt32",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector128_Byte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector128_Int16",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector128_Int32",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector128_SByte",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector128_Single",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Max(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector128_UInt16",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Max_Vector128_UInt32",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Max",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Max(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MaxNumber_Vector64_Single",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxNumber",                                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.MaxNumber(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MaxNumber_Vector128_Single",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxNumber",                                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.MaxNumber(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MaxNumberScalar_Vector64_Double",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxNumberScalar",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.MaxNumber(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MaxNumberScalar_Vector64_Single",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxNumberScalar",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.MaxNumber(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MaxPairwise_Vector64_Byte",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.MaxPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MaxPairwise_Vector64_Int16",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MaxPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MaxPairwise_Vector64_Int32",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MaxPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MaxPairwise_Vector64_SByte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.MaxPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MaxPairwise_Vector64_Single",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.MaxPairwise(left, right, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MaxPairwise_Vector64_UInt16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.MaxPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MaxPairwise_Vector64_UInt32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MaxPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.MaxPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector64_Byte",                                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector64_Int16",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector64_Int32",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector64_SByte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector64_Single",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Min(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector64_UInt16",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector64_UInt32",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector128_Byte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector128_Int16",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector128_Int32",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector128_SByte",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector128_Single",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Min(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector128_UInt16",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Min_Vector128_UInt32",                                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Min",                                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Min(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MinNumber_Vector64_Single",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinNumber",                                                            ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.MinNumber(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MinNumber_Vector128_Single",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinNumber",                                                            ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.MinNumber(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MinNumberScalar_Vector64_Double",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinNumberScalar",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.MinNumber(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                    ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MinNumberScalar_Vector64_Single",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinNumberScalar",                                                      ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.MinNumber(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                    ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MinPairwise_Vector64_Byte",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.MinPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MinPairwise_Vector64_Int16",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MinPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MinPairwise_Vector64_Int32",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MinPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MinPairwise_Vector64_SByte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.MinPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MinPairwise_Vector64_Single",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.MinPairwise(left, right, i)) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MinPairwise_Vector64_UInt16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.MinPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MinPairwise_Vector64_UInt32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MinPairwise",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.MinPairwise(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector64_Byte",                                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector64_Int16",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector64_Int32",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector64_SByte",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector64_Single",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector64_UInt16",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector64_UInt32",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector128_Byte",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector128_Int16",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector128_Int32",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector128_SByte",                                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector128_Single",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(left[i], right[i])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector128_UInt16",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "Multiply_Vector128_UInt32",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Multiply",                                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[i]) != result[i]"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyScalar_Vector64_Double",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyScalar",                                                       ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Double",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",        ["NextValueOp2"] = "TestLibrary.Generator.GetDouble()",                                                                                       ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Multiply(left[0], right[0])) != BitConverter.DoubleToInt64Bits(result[0])",                                                     ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyScalar_Vector64_Single",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyScalar",                                                       ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(left[0], right[0])) != BitConverter.SingleToInt32Bits(result[0])",                                                     ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector64_Byte",                                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector64_Int16",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector64_Int32",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector64_SByte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector64_UInt16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector64_UInt32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector128_Byte",                                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector128_Int16",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector128_Int32",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector128_SByte",                                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector128_UInt16",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAdd_Vector128_UInt32",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAdd",                                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAddByScalar_Vector64_Int16",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddByScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAddByScalar_Vector64_Int32",                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddByScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAddByScalar_Vector64_UInt16",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddByScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAddByScalar_Vector64_UInt32",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddByScalar",                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAddByScalar_Vector128_Int16",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddByScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAddByScalar_Vector128_Int32",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddByScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAddByScalar_Vector128_UInt16",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddByScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyAddByScalar_Vector128_UInt32",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddByScalar",                                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector64_Int16_Vector64_Int16_3",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector64_Int16_Vector128_Int16_7",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector64_Int32_Vector64_Int32_1",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector64_Int32_Vector128_Int32_3",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector64_UInt16_Vector64_UInt16_3",                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector64_UInt16_Vector128_UInt16_7",                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector64_UInt32_Vector64_UInt32_1",                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector64_UInt32_Vector128_UInt32_3",                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector128_Int16_Vector64_Int16_3",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector128_Int16_Vector128_Int16_7",                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector128_Int32_Vector64_Int32_1",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector128_Int32_Vector128_Int32_3",                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector128_UInt16_Vector64_UInt16_3",                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector128_UInt16_Vector128_UInt16_7",                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector128_UInt32_Vector64_UInt32_1",                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyAddBySelectedScalar_Vector128_UInt32_Vector128_UInt32_3",                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyAddBySelectedScalar",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAdd(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector64_Int16",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector64_Int32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector64_Single",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(left[i], right[0])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector64_UInt16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector64_UInt32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector128_Int16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector128_Int32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector128_Single",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                                       ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(left[i], right[0])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector128_UInt16",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyByScalar_Vector128_UInt32",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyByScalar",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.Multiply(left[i], right[0]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_Int16_Vector64_Int16_1",                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_Int16_Vector128_Int16_7",                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_Int32_Vector64_Int32_1",                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_Int32_Vector128_Int32_3",                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_Single_Vector64_Single_1",                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(firstOp[i], secondOp[Imm])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_Single_Vector128_Single_3",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["Imm"] = "3",                                                                 ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(firstOp[i], secondOp[Imm])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_UInt16_Vector64_UInt16_1",                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_UInt16_Vector128_UInt16_7",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_UInt32_Vector64_UInt32_1",                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector64_UInt32_Vector128_UInt32_3",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_Int16_Vector64_Int16_1",                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_Int16_Vector128_Int16_7",                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_Int32_Vector64_Int32_1",                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_Int32_Vector128_Int32_3",                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_Single_Vector64_Single_1",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(firstOp[i], secondOp[Imm])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_Single_Vector128_Single_3",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",        ["Imm"] = "3",                                                                 ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(firstOp[i], secondOp[Imm])) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_UInt16_Vector64_UInt16_1",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_UInt16_Vector128_UInt16_7",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_UInt32_Vector64_UInt32_1",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalar_Vector128_UInt32_Vector128_UInt32_3",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",                                                                 ["ValidateIterResult"] = "Helpers.Multiply(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLower_Vector64_Int16_Vector64_Int16_3",                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyWidening(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLower_Vector64_Int16_Vector128_Int16_7",                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyWidening(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLower_Vector64_Int32_Vector64_Int32_1",                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyWidening(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLower_Vector64_Int32_Vector128_Int32_3",                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyWidening(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLower_Vector64_UInt16_Vector64_UInt16_3",                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                       ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyWidening(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLower_Vector64_UInt16_Vector128_UInt16_7",                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                       ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyWidening(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLower_Vector64_UInt32_Vector64_UInt32_1",                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                       ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyWidening(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLower_Vector64_UInt32_Vector128_UInt32_3",                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                       ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyWidening(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_Int16_Vector64_Int16_3",                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_Int16_Vector128_Int16_7",                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_Int32_Vector64_Int32_1",                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_Int32_Vector128_Int32_3",                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_UInt16_Vector64_UInt16_3",                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_UInt16_Vector128_UInt16_7",                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_UInt32_Vector64_UInt32_1",                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndAdd_Vector64_UInt32_Vector128_UInt32_3",                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_Int16_Vector64_Int16_3",                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_Int16_Vector128_Int16_7",                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_Int32_Vector64_Int32_1",                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_Int32_Vector128_Int32_3",                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_UInt16_Vector64_UInt16_3",                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_UInt16_Vector128_UInt16_7",                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_UInt32_Vector64_UInt32_1",                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningLowerAndSubtract_Vector64_UInt32_Vector128_UInt32_3",                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningLowerAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpper_Vector128_Int16_Vector64_Int16_3",                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpper(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpper_Vector128_Int16_Vector128_Int16_7",                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpper(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpper_Vector128_Int32_Vector64_Int32_1",                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpper(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpper_Vector128_Int32_Vector128_Int32_3",                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpper(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpper_Vector128_UInt16_Vector64_UInt16_3",                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                       ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpper(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpper_Vector128_UInt16_Vector128_UInt16_7",                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                       ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpper(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpper_Vector128_UInt32_Vector64_UInt32_1",                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                       ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpper(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpper_Vector128_UInt32_Vector128_UInt32_3",                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                       ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpper(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_Int16_Vector64_Int16_3",                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndAdd(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_Int16_Vector128_Int16_7",                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndAdd(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_Int32_Vector64_Int32_1",                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndAdd(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_Int32_Vector128_Int32_3",                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndAdd(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_UInt16_Vector64_UInt16_3",                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndAdd(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_UInt16_Vector128_UInt16_7",                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndAdd(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_UInt32_Vector64_UInt32_1",                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndAdd(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndAdd_Vector128_UInt32_Vector128_UInt32_3",                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndAdd",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndAdd(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_Int16_Vector64_Int16_3",                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndSubtract(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_Int16_Vector128_Int16_7",                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndSubtract(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_Int32_Vector64_Int32_1",                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndSubtract(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_Int32_Vector128_Int32_3",                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndSubtract(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_UInt16_Vector64_UInt16_3",                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndSubtract(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_UInt16_Vector128_UInt16_7",                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndSubtract(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_UInt32_Vector64_UInt32_1",                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndSubtract(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyBySelectedScalarWideningUpperAndSubtract_Vector128_UInt32_Vector128_UInt32_3",                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyBySelectedScalarWideningUpperAndSubtract",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyByScalarWideningUpperAndSubtract(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingByScalarSaturateHigh_Vector64_Int16",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingByScalarSaturateHigh",                                 ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingByScalarSaturateHigh_Vector64_Int32",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingByScalarSaturateHigh",                                 ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingByScalarSaturateHigh_Vector128_Int16",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingByScalarSaturateHigh",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingByScalarSaturateHigh_Vector128_Int32",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingByScalarSaturateHigh",                                 ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(left[i], right[0]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingBySelectedScalarSaturateHigh_Vector64_Int16_Vector64_Int16_3",                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingBySelectedScalarSaturateHigh_Vector64_Int16_Vector128_Int16_7",                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingBySelectedScalarSaturateHigh_Vector64_Int32_Vector64_Int32_1",                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingBySelectedScalarSaturateHigh_Vector64_Int32_Vector128_Int32_3",                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingBySelectedScalarSaturateHigh_Vector128_Int16_Vector64_Int16_3",                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingBySelectedScalarSaturateHigh_Vector128_Int16_Vector128_Int16_7",                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingBySelectedScalarSaturateHigh_Vector128_Int32_Vector64_Int32_1",                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingBySelectedScalarSaturateHigh_Vector128_Int32_Vector128_Int32_3",                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingBySelectedScalarSaturateHigh",                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingSaturateHigh_Vector64_Int16",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingSaturateHigh",                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingSaturateHigh_Vector64_Int32",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingSaturateHigh",                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingSaturateHigh_Vector128_Int16",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingSaturateHigh",                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingSaturateHigh_Vector128_Int32",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingSaturateHigh",                                         ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingSaturateHigh(left[i], right[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerAndAddSaturate_Vector64_Int16",                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerAndAddSaturate",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerAndAddSaturate_Vector64_Int32",                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerAndAddSaturate",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerAndSubtractSaturate_Vector64_Int16",                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerAndSubtractSaturate",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerAndSubtractSaturate_Vector64_Int32",                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerAndSubtractSaturate",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerByScalarAndAddSaturate_Vector64_Int16_Vector64_Int16",                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerByScalarAndAddSaturate",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerByScalarAndAddSaturate_Vector64_Int32_Vector64_Int32",                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerByScalarAndAddSaturate",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerByScalarAndSubtractSaturate_Vector64_Int16_Vector64_Int16",                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerByScalarAndSubtractSaturate",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerByScalarAndSubtractSaturate_Vector64_Int32_Vector64_Int32",                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerByScalarAndSubtractSaturate",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate_Vector64_Int16_Vector64_Int16_3",           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate_Vector64_Int16_Vector128_Int16_7",          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate_Vector64_Int32_Vector64_Int32_1",           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate_Vector64_Int32_Vector128_Int32_3",          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerBySelectedScalarAndAddSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndAddSaturate(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate_Vector64_Int16_Vector64_Int16_3",      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate_Vector64_Int16_Vector128_Int16_7",     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate_Vector64_Int32_Vector64_Int32_1",      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate_Vector64_Int32_Vector128_Int32_3",     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningLowerBySelectedScalarAndSubtractSaturate",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningAndSubtractSaturate(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateLower_Vector64_Int16",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateLower_Vector64_Int32",                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateLower",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateLowerByScalar_Vector64_Int16",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateLowerByScalar",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateLowerByScalar_Vector64_Int32",                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateLowerByScalar",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(left[i], right[0]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateLowerBySelectedScalar_Vector64_Int16_Vector64_Int16_3",                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateLowerBySelectedScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateLowerBySelectedScalar_Vector64_Int16_Vector128_Int16_7",                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateLowerBySelectedScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateLowerBySelectedScalar_Vector64_Int32_Vector64_Int32_1",                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateLowerBySelectedScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateLowerBySelectedScalar_Vector64_Int32_Vector128_Int32_3",                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateLowerBySelectedScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturate(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateUpper_Vector128_Int16",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturateUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateUpper_Vector128_Int32",                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateUpper",                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturateUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateUpperByScalar_Vector128_Int16",                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateUpperByScalar",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturateUpperByScalar(left, right[0], i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateUpperByScalar_Vector128_Int32",                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateUpperByScalar",                        ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturateUpperByScalar(left, right[0], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateUpperBySelectedScalar_Vector128_Int16_Vector64_Int16_3",                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateUpperBySelectedScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturateUpperByScalar(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateUpperBySelectedScalar_Vector128_Int16_Vector128_Int16_7",               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateUpperBySelectedScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturateUpperByScalar(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateUpperBySelectedScalar_Vector128_Int32_Vector64_Int32_1",                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateUpperBySelectedScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturateUpperByScalar(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningSaturateUpperBySelectedScalar_Vector128_Int32_Vector128_Int32_3",               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningSaturateUpperBySelectedScalar",                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningSaturateUpperByScalar(firstOp, secondOp[Imm], i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperAndAddSaturate_Vector128_Int16",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperAndAddSaturate",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperAndAddSaturate(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperAndAddSaturate_Vector128_Int32",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperAndAddSaturate",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperAndAddSaturate(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperAndSubtractSaturate_Vector128_Int16",                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperAndSubtractSaturate",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperAndSubtractSaturate(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperAndSubtractSaturate_Vector128_Int32",                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperAndSubtractSaturate",                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperAndSubtractSaturate(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperByScalarAndAddSaturate_Vector128_Int16_Vector64_Int16",                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperByScalarAndAddSaturate",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndAddSaturate(firstOp, secondOp, thirdOp[0], i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperByScalarAndAddSaturate_Vector128_Int32_Vector64_Int32",                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperByScalarAndAddSaturate",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndAddSaturate(firstOp, secondOp, thirdOp[0], i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperByScalarAndSubtractSaturate_Vector128_Int16_Vector64_Int16",               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperByScalarAndSubtractSaturate",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndSubtractSaturate(firstOp, secondOp, thirdOp[0], i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperByScalarAndSubtractSaturate_Vector128_Int32_Vector64_Int32",               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperByScalarAndSubtractSaturate",             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndSubtractSaturate(firstOp, secondOp, thirdOp[0], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate_Vector128_Int16_Vector64_Int16_3",          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndAddSaturate(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate_Vector128_Int16_Vector128_Int16_7",         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndAddSaturate(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate_Vector128_Int32_Vector64_Int32_1",          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndAddSaturate(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate_Vector128_Int32_Vector128_Int32_3",         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperBySelectedScalarAndAddSaturate",          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndAddSaturate(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate_Vector128_Int16_Vector64_Int16_3",     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndSubtractSaturate(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate_Vector128_Int16_Vector128_Int16_7",    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndSubtractSaturate(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate_Vector128_Int32_Vector64_Int32_1",     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndSubtractSaturate(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate_Vector128_Int32_Vector128_Int32_3",    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyDoublingWideningUpperBySelectedScalarAndSubtractSaturate",     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyDoublingWideningUpperByScalarAndSubtractSaturate(firstOp, secondOp, thirdOp[Imm], i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingByScalarSaturateHigh_Vector64_Int16",                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingByScalarSaturateHigh",                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingByScalarSaturateHigh_Vector64_Int32",                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingByScalarSaturateHigh",                          ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingByScalarSaturateHigh_Vector128_Int16",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingByScalarSaturateHigh",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingByScalarSaturateHigh_Vector128_Int32",                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingByScalarSaturateHigh",                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[0]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector64_Int16_Vector64_Int16_3",                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector64_Int16_Vector128_Int16_7",                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector64_Int32_Vector64_Int32_1",                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector64_Int32_Vector128_Int32_3",                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector128_Int16_Vector64_Int16_2",                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector128_Int16_Vector128_Int16_7",                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector128_Int32_Vector64_Int32_1",                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecImmBinOpTest.template",          new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh_Vector128_Int32_Vector128_Int32_3",                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingBySelectedScalarSaturateHigh",                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(firstOp[i], secondOp[Imm]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingSaturateHigh_Vector64_Int16",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingSaturateHigh_Vector64_Int32",                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingSaturateHigh_Vector128_Int16",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyRoundedDoublingSaturateHigh_Vector128_Int32",                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyRoundedDoublingSaturateHigh",                                  ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyRoundedDoublingSaturateHigh(left[i], right[i]) != result[i]"}),
        ("ImmBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyScalarBySelectedScalar_Vector64_Single_Vector64_Single_1",                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyScalarBySelectedScalar",                                       ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                       ["Imm"] = "1",  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(firstOp[0], secondOp[Imm])) != BitConverter.SingleToInt32Bits(result[0])",                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("ImmBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyScalarBySelectedScalar_Vector64_Single_Vector128_Single_3",                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyScalarBySelectedScalar",                                       ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Single",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",        ["NextValueOp2"] = "TestLibrary.Generator.GetSingle()",                                                                       ["Imm"] = "3",  ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(Helpers.Multiply(firstOp[0], secondOp[Imm])) != BitConverter.SingleToInt32Bits(result[0])",                                             ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector64_Byte",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector64_Int16",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector64_Int32",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector64_SByte",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector64_UInt16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector64_UInt32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector128_Byte",                                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector128_Int16",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector128_Int32",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector128_SByte",                                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector128_UInt16",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtract_Vector128_UInt32",                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtract",                                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector64_Int16_Vector64_Int16_3",                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector64_Int16_Vector128_Int16_7",                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector64_Int32_Vector64_Int32_1",                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector64_Int32_Vector128_Int32_3",                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector64_UInt16_Vector64_UInt16_3",                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector64_UInt16_Vector128_UInt16_7",                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector64_UInt32_Vector64_UInt32_1",                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector64_UInt32_Vector128_UInt32_3",                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector128_Int16_Vector64_Int16_3",                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector128_Int16_Vector128_Int16_7",                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",         ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector128_Int32_Vector64_Int32_1",                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector128_Int32_Vector128_Int32_3",                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",         ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector128_UInt16_Vector64_UInt16_3",                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector128_UInt16_Vector128_UInt16_7",                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",        ["Imm"] = "7",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector128_UInt32_Vector64_UInt32_1",                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "1",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecImmTernOpTest.template",         new Dictionary<string, string> { ["TestName"] = "MultiplySubtractBySelectedScalar_Vector128_UInt32_Vector128_UInt32_3",                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractBySelectedScalar",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",        ["Imm"] = "3",  ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[Imm]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtractByScalar_Vector64_Int16",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractByScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtractByScalar_Vector64_Int32",                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractByScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtractByScalar_Vector64_UInt16",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractByScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtractByScalar_Vector64_UInt32",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractByScalar",                                             ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtractByScalar_Vector128_Int16",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractByScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtractByScalar_Vector128_Int32",                                                              ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractByScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtractByScalar_Vector128_UInt16",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractByScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplySubtractByScalar_Vector128_UInt32",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplySubtractByScalar",                                             ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplySubtract(firstOp[i], secondOp[i], thirdOp[0]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLower_Vector64_Byte",                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLower",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.MultiplyWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLower_Vector64_Int16",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLower",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLower_Vector64_Int32",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLower",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLower_Vector64_SByte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLower",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLower_Vector64_UInt16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLower",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.MultiplyWidening(left[i], right[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLower_Vector64_UInt32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLower",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.MultiplyWidening(left[i], right[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndAdd_Vector64_Byte",                                                             ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndAdd_Vector64_Int16",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndAdd_Vector64_Int32",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndAdd_Vector64_SByte",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndAdd_Vector64_UInt16",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndAdd_Vector64_UInt32",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplyAddWidening(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndSubtract_Vector64_Byte",                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndSubtract_Vector64_Int16",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndSubtract_Vector64_Int32",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndSubtract_Vector64_SByte",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndSubtract_Vector64_UInt16",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningLowerAndSubtract_Vector64_UInt32",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningLowerAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector64",  ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector64",  ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplyWideningAndSubtract(firstOp[i], secondOp[i], thirdOp[i]) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpper_Vector128_Byte",                                                                  ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Byte",   ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",                                                                ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",                                                                                         ["ValidateIterResult"] = "Helpers.MultiplyWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpper_Vector128_Int16",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpper_Vector128_Int32",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpper_Vector128_SByte",                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",                                                               ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",                                                                                        ["ValidateIterResult"] = "Helpers.MultiplyWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpper_Vector128_UInt16",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",                                                                                       ["ValidateIterResult"] = "Helpers.MultiplyWideningUpper(left, right, i) != result[i]"}),
        ("VecBinOpTest.template",             new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpper_Vector128_UInt32",                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpper",                                                ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32",                                                              ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",                                                                                       ["ValidateIterResult"] = "Helpers.MultiplyWideningUpper(left, right, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndAdd_Vector128_Byte",                                                            ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndAdd_Vector128_Int16",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndAdd_Vector128_Int32",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndAdd_Vector128_SByte",                                                           ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndAdd_Vector128_UInt16",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndAdd_Vector128_UInt32",                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndAdd",                                          ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndAdd(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndSubtract_Vector128_Byte",                                                       ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt16",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt16", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Byte",   ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Byte",   ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp2"] = "TestLibrary.Generator.GetByte()",          ["NextValueOp3"] = "TestLibrary.Generator.GetByte()",                          ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndSubtract(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndSubtract_Vector128_Int16",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int16",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int16",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt16()",                         ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndSubtract(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndSubtract_Vector128_Int32",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int64",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "Int32",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "Int32",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",         ["NextValueOp2"] = "TestLibrary.Generator.GetInt32()",         ["NextValueOp3"] = "TestLibrary.Generator.GetInt32()",                         ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndSubtract(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndSubtract_Vector128_SByte",                                                      ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",  ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "SByte",  ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "SByte",  ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",         ["NextValueOp2"] = "TestLibrary.Generator.GetSByte()",         ["NextValueOp3"] = "TestLibrary.Generator.GetSByte()",                         ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndSubtract(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndSubtract_Vector128_UInt16",                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt32",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt32", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt16", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt16", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt16()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt16()",                        ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndSubtract(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("VecTernOpTest.template",            new Dictionary<string, string> { ["TestName"] = "MultiplyWideningUpperAndSubtract_Vector128_UInt32",                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "MultiplyWideningUpperAndSubtract",                                     ["RetVectorType"] = "Vector128", ["RetBaseType"] = "UInt64",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "UInt64", ["Op2VectorType"] = "Vector128", ["Op2BaseType"] = "UInt32", ["Op3VectorType"] = "Vector128", ["Op3BaseType"] = "UInt32", ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetUInt64()",        ["NextValueOp2"] = "TestLibrary.Generator.GetUInt32()",        ["NextValueOp3"] = "TestLibrary.Generator.GetUInt32()",                        ["ValidateIterResult"] = "Helpers.MultiplyWideningUpperAndSubtract(firstOp, secondOp, thirdOp, i) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Negate_Vector64_Int16",                                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Negate",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "-firstOp[i] != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Negate_Vector64_Int32",                                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Negate",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "-firstOp[i] != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Negate_Vector64_SByte",                                                                                 ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Negate",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "-firstOp[i] != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Negate_Vector64_Single",                                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Negate",                                                               ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(-firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Negate_Vector128_Int16",                                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Negate",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "-firstOp[i] != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Negate_Vector128_Int32",                                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Negate",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "-firstOp[i] != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Negate_Vector128_SByte",                                                                                ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Negate",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "-firstOp[i] != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Negate_Vector128_Single",                                                                               ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Negate",                                                               ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "16", ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.SingleToInt32Bits(-firstOp[i]) != BitConverter.SingleToInt32Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "NegateSaturate_Vector64_Int16",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "Int16.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.NegateSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "NegateSaturate_Vector64_Int32",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "Int32.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.NegateSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "NegateSaturate_Vector64_SByte",                                                                         ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "SByte.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.NegateSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "NegateSaturate_Vector128_Int16",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "Int16.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.NegateSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "NegateSaturate_Vector128_Int32",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "Int32.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.NegateSaturate(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "NegateSaturate_Vector128_SByte",                                                                        ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "NegateSaturate",                                                       ["RetVectorType"] = "Vector128", ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector128", ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "16", ["NextValueOp1"] = "SByte.MinValue",                                                                                                                                                                         ["ValidateIterResult"] = "Helpers.NegateSaturate(firstOp[i]) != result[i]"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "NegateScalar_Vector64_Double",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "NegateScalar",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateFirstResult"] = "BitConverter.DoubleToInt64Bits(-firstOp[0]) != BitConverter.DoubleToInt64Bits(result[0])",                                                              ["ValidateRemainingResults"] = "BitConverter.DoubleToInt64Bits(result[i]) != 0"}),
        ("SimpleUnOpTest.template",           new Dictionary<string, string> { ["TestName"] = "NegateScalar_Vector64_Single",                                                                          ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "NegateScalar",                                                         ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Single",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Single",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSingle()",                                                                                                                                                      ["ValidateFirstResult"] = "BitConverter.SingleToInt32Bits(-firstOp[0]) != BitConverter.SingleToInt32Bits(result[0])",                                                              ["ValidateRemainingResults"] = "BitConverter.SingleToInt32Bits(result[i]) != 0"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Not_Vector64_Byte",                                                                                     ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Not",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Byte",    ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Byte",                                                                                                                             ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetByte()",                                                                                                                                                        ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Not_Vector64_Double",                                                                                   ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Not",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Double",  ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Double",                                                                                                                           ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetDouble()",                                                                                                                                                      ["ValidateIterResult"] = "BitConverter.DoubleToInt64Bits(Helpers.Not(firstOp[i])) != BitConverter.DoubleToInt64Bits(result[i])"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Not_Vector64_Int16",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Not",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int16",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int16",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt16()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Not_Vector64_Int32",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Not",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int32",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int32",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt32()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Not_Vector64_Int64",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Not",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "Int64",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "Int64",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetInt64()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Not(firstOp[i]) != result[i]"}),
        ("SimpleVecOpTest.template",          new Dictionary<string, string> { ["TestName"] = "Not_Vector64_SByte",                                                                                    ["Isa"] = "AdvSimd",       ["LoadIsa"] = "AdvSimd", ["Method"] = "Not",                                                                  ["RetVectorType"] = "Vector64",  ["RetBaseType"] = "SByte",   ["Op1VectorType"] = "Vector64",  ["Op1BaseType"] = "SByte",                                                                                                                            ["LargestVectorSize"] = "8",  ["NextValueOp1"] = "TestLibrary.Generator.GetSByte()",                                                                                                                                                       ["ValidateIterResult"] = "Helpers.Not(firs