/*
 * Decompiled with CFR 0.152.
 */
package jalview.appletgui;

import jalview.appletgui.APopupMenu;
import jalview.appletgui.AlignViewport;
import jalview.appletgui.AlignmentPanel;
import jalview.appletgui.IdCanvas;
import jalview.appletgui.PaintRefresher;
import jalview.appletgui.Tooltip;
import jalview.datamodel.Sequence;
import jalview.datamodel.SequenceGroup;
import jalview.datamodel.SequenceI;
import jalview.util.UrlLink;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Panel;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class IdPanel
extends Panel
implements MouseListener,
MouseMotionListener {
    protected IdCanvas idCanvas;
    protected AlignViewport av;
    protected AlignmentPanel alignPanel;
    ScrollThread scrollThread = null;
    int offy;
    int width;
    int lastid = -1;
    boolean mouseDragging = false;
    Vector links = new Vector();
    Tooltip tooltip;

    public IdPanel(AlignViewport av, AlignmentPanel parent) {
        this.av = av;
        this.alignPanel = parent;
        this.idCanvas = new IdCanvas(av);
        this.setLayout(new BorderLayout());
        this.add((Component)this.idCanvas, "Center");
        this.idCanvas.addMouseListener(this);
        this.idCanvas.addMouseMotionListener(this);
        if (av.applet != null) {
            for (int i = 1; i < 10; ++i) {
                String label = av.applet.getParameter("linkLabel_" + i);
                String url = av.applet.getParameter("linkURL_" + i);
                if (label == null || url == null) continue;
                this.links.addElement(label + "|" + url);
            }
        }
        if (this.links.size() < 1) {
            this.links = new Vector();
            this.links.addElement("SRS|http://srs.ebi.ac.uk/srsbin/cgi-bin/wgetz?-newId+(([uniprot-all:$SEQUENCE_ID$]))+-view+SwissEntry");
        }
    }

    public void mouseMoved(MouseEvent e) {
        int seq = this.alignPanel.seqPanel.findSeq(e);
        SequenceI sequence = this.av.getAlignment().getSequenceAt(seq);
        if (sequence.getDescription() == null) {
            if (this.tooltip != null) {
                this.tooltip.setVisible(false);
            }
            this.tooltip = null;
            return;
        }
        if (this.tooltip == null) {
            this.tooltip = new Tooltip(sequence.getDisplayId(true) + "\n" + sequence.getDescription(), this.idCanvas);
        } else {
            this.tooltip.setTip(sequence.getDisplayId(true) + "\n" + sequence.getDescription());
        }
    }

    public void mouseDragged(MouseEvent e) {
        this.mouseDragging = true;
        int seq = Math.max(0, this.alignPanel.seqPanel.findSeq(e));
        if (seq < this.lastid) {
            this.selectSeqs(this.lastid - 1, seq);
        } else if (seq > this.lastid) {
            this.selectSeqs(this.lastid + 1, seq);
        }
        this.lastid = seq;
        this.alignPanel.paintAlignment(false);
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getClickCount() < 2) {
            return;
        }
        int seq = this.alignPanel.seqPanel.findSeq(e);
        String id = this.av.getAlignment().getSequenceAt(seq).getName();
        String target = null;
        String url = null;
        int i = 0;
        while (url == null && i < this.links.size()) {
            url = this.links.elementAt(i++).toString();
            UrlLink urlLink = null;
            try {
                urlLink = new UrlLink(url);
                target = urlLink.getTarget();
            }
            catch (Exception foo) {
                System.err.println("Exception for URLLink '" + url + "'");
                foo.printStackTrace();
                url = null;
                continue;
            }
            if (!urlLink.isValid()) {
                System.err.println(urlLink.getInvalidMessage());
                url = null;
                continue;
            }
            String[] urls = urlLink.makeUrls(id, true);
            if (urls == null || urls[0] == null || urls[0].length() < 1) {
                url = null;
                continue;
            }
            url = urls[1];
        }
        try {
            this.alignPanel.alignFrame.showURL(url, target);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void mouseEntered(MouseEvent e) {
        if (this.scrollThread != null) {
            this.scrollThread.running = false;
        }
    }

    public void mouseExited(MouseEvent e) {
        if (this.av.getWrapAlignment()) {
            return;
        }
        if (this.mouseDragging && e.getY() < 0 && this.av.getStartSeq() > 0) {
            this.scrollThread = new ScrollThread(true);
        }
        if (this.mouseDragging && e.getY() >= this.getSize().height && this.av.alignment.getHeight() > this.av.getEndSeq()) {
            this.scrollThread = new ScrollThread(false);
        }
    }

    public void mousePressed(MouseEvent e) {
        if (e.getClickCount() > 1) {
            return;
        }
        int y = e.getY();
        if (this.av.getWrapAlignment()) {
            y -= 2 * this.av.charHeight;
        }
        int seq = this.alignPanel.seqPanel.findSeq(e);
        if ((e.getModifiers() & 4) == 4) {
            APopupMenu popup = new APopupMenu(this.alignPanel, (Sequence)this.av.getAlignment().getSequenceAt(seq), this.links);
            this.add(popup);
            popup.show(this, e.getX(), e.getY());
            return;
        }
        if (this.av.getSelectionGroup() == null || !e.isControlDown() && !e.isShiftDown() && this.av.getSelectionGroup() != null) {
            this.av.setSelectionGroup(new SequenceGroup());
            this.av.getSelectionGroup().setStartRes(0);
            this.av.getSelectionGroup().setEndRes(this.av.alignment.getWidth() - 1);
        }
        if (e.isShiftDown() && this.lastid != -1) {
            this.selectSeqs(this.lastid, seq);
        } else {
            this.selectSeq(seq);
        }
        this.alignPanel.paintAlignment(false);
    }

    void selectSeq(int seq) {
        this.lastid = seq;
        SequenceI pickedSeq = this.av.getAlignment().getSequenceAt(seq);
        this.av.getSelectionGroup().addOrRemove(pickedSeq, false);
    }

    void selectSeqs(int start, int end) {
        this.lastid = start;
        if (end >= this.av.getAlignment().getHeight()) {
            end = this.av.getAlignment().getHeight() - 1;
        }
        if (end < start) {
            int tmp = start;
            start = end;
            this.lastid = end = tmp;
        }
        for (int i = start; i <= end; ++i) {
            this.av.getSelectionGroup().addSequence(this.av.getAlignment().getSequenceAt(i), false);
        }
    }

    public void mouseReleased(MouseEvent e) {
        if (this.scrollThread != null) {
            this.scrollThread.running = false;
        }
        if (this.av.getSelectionGroup() != null) {
            this.av.getSelectionGroup().recalcConservation();
        }
        this.mouseDragging = false;
        PaintRefresher.Refresh(this, this.av.getSequenceSetId());
    }

    public void highlightSearchResults(Vector found) {
        this.idCanvas.setHighlighted(found);
        if (found == null) {
            return;
        }
        int index = this.av.alignment.findIndex((SequenceI)found.elementAt(0));
        if (this.av.getStartSeq() > index || this.av.getEndSeq() < index) {
            this.alignPanel.setScrollValues(this.av.getStartRes(), index);
        }
    }

    class ScrollThread
    extends Thread {
        boolean running = false;
        boolean up = true;

        public ScrollThread(boolean up) {
            this.up = up;
            this.start();
        }

        public void stopScrolling() {
            this.running = false;
        }

        public void run() {
            this.running = true;
            while (this.running) {
                if (IdPanel.this.alignPanel.scrollUp(this.up)) {
                    int seq = IdPanel.this.av.getStartSeq();
                    if (!this.up) {
                        seq = IdPanel.this.av.getEndSeq();
                    }
                    if (seq < IdPanel.this.lastid) {
                        IdPanel.this.selectSeqs(IdPanel.this.lastid - 1, seq);
                    } else if (seq > IdPanel.this.lastid && seq < IdPanel.this.av.alignment.getHeight()) {
                        IdPanel.this.selectSeqs(IdPanel.this.lastid + 1, seq);
                    }
                    IdPanel.this.lastid = seq;
                } else {
                    this.running = false;
                }
                IdPanel.this.alignPanel.paintAlignment(true);
                try {
                    Thread.sleep(100L);
                }
                catch (Exception exception) {}
            }
        }
    }
}

