/*
 * Decompiled with CFR 0.152.
 */
package jalview.schemes;

import jalview.schemes.ColourSchemeProperty;
import jalview.schemes.ResidueColourScheme;
import jalview.schemes.ResidueProperties;
import java.awt.Color;
import java.util.StringTokenizer;

public class UserColourScheme
extends ResidueColourScheme {
    Color[] lowerCaseColours;
    protected String schemeName;

    public UserColourScheme() {
    }

    public UserColourScheme(Color[] newColors) {
        this.colors = newColors;
    }

    public UserColourScheme(String colour) {
        Color col = this.getColourFromString(colour);
        if (col == null) {
            System.out.println("Unknown colour!! " + colour);
            col = this.createColourFromName(colour);
        }
        this.colors = new Color[24];
        for (int i = 0; i < 24; ++i) {
            this.colors[i] = col;
        }
        this.schemeName = colour;
    }

    public Color[] getColours() {
        return this.colors;
    }

    public Color[] getLowerCaseColours() {
        return this.lowerCaseColours;
    }

    public void setName(String name) {
        this.schemeName = name;
    }

    public String getName() {
        return this.schemeName;
    }

    public Color getColourFromString(String colour) {
        colour = colour.trim();
        Color col = null;
        try {
            int value = Integer.parseInt(colour, 16);
            col = new Color(value);
        }
        catch (NumberFormatException ex) {
            // empty catch block
        }
        if (col == null) {
            col = ColourSchemeProperty.getAWTColorFromName(colour);
        }
        if (col == null) {
            try {
                StringTokenizer st = new StringTokenizer(colour, ",");
                int r = Integer.parseInt(st.nextToken());
                int g = Integer.parseInt(st.nextToken());
                int b = Integer.parseInt(st.nextToken());
                col = new Color(r, g, b);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return col;
    }

    public Color createColourFromName(String name) {
        int lsize = name.length();
        int start = 0;
        int end = lsize / 3;
        int rgbOffset = Math.abs(name.hashCode() % 10) * 15;
        int r = Math.abs(name.substring(start, end).hashCode() + rgbOffset) % 210 + 20;
        start = end;
        if ((end += lsize / 3) > lsize) {
            end = lsize;
        }
        int g = Math.abs(name.substring(start, end).hashCode() + rgbOffset) % 210 + 20;
        int b = Math.abs(name.substring(end).hashCode() + rgbOffset) % 210 + 20;
        Color color = new Color(r, g, b);
        return color;
    }

    public void parseAppletParameter(String paramValue) {
        StringTokenizer st = new StringTokenizer(paramValue, ";");
        String token = null;
        try {
            while (st.hasMoreElements()) {
                token = st.nextToken().trim();
                String residues = token.substring(0, token.indexOf("="));
                String colour = token.substring(token.indexOf("=") + 1);
                StringTokenizer st2 = new StringTokenizer(residues, " ,");
                while (st2.hasMoreTokens()) {
                    token = st2.nextToken();
                    if (ResidueProperties.aaIndex[token.charAt(0)] == -1) continue;
                    int colIndex = ResidueProperties.aaIndex[token.charAt(0)];
                    if (token.equalsIgnoreCase("lowerCase")) {
                        if (this.lowerCaseColours == null) {
                            this.lowerCaseColours = new Color[23];
                        }
                        for (int i = 0; i < 23; ++i) {
                            if (this.lowerCaseColours[i] != null) continue;
                            this.lowerCaseColours[i] = this.getColourFromString(colour);
                        }
                        continue;
                    }
                    if (token.equals(token.toLowerCase())) {
                        if (this.lowerCaseColours == null) {
                            this.lowerCaseColours = new Color[23];
                        }
                        this.lowerCaseColours[colIndex] = this.getColourFromString(colour);
                        continue;
                    }
                    this.colors[colIndex] = this.getColourFromString(colour);
                }
            }
        }
        catch (Exception ex) {
            System.out.println("Error parsing userDefinedColours:\n" + token + "\n" + ex);
        }
    }

    public Color findColour(char c, int j) {
        int index = ResidueProperties.aaIndex[c];
        Color currentColour = this.threshold == 0 || this.aboveThreshold(c, j) ? (this.lowerCaseColours != null && 'a' <= c && c <= 'z' ? this.lowerCaseColours[index] : this.colors[index]) : Color.white;
        if (this.conservationColouring) {
            currentColour = this.applyConservation(currentColour, j);
        }
        return currentColour;
    }

    public void setLowerCaseColours(Color[] lcolours) {
        this.lowerCaseColours = lcolours;
    }
}

