/* $Id: cim_serial.c,v 1.7 2009-01-27 17:06:39 potyra Exp $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#include "compiler.h"

#include <assert.h>
#include <stdio.h>

#include "cim_serial.h"

static void
cim_serial_recv(void *_css, uint8_t c)
{
	struct cim_serial *css = (struct cim_serial *) _css;
	struct umser_msg_raw msg;

	msg.len = 1;
	msg.data[0] = c;

	cim_send(&css->bridge, &msg, sizeof(msg));
}

void
cim_serial_interrupt(void *_css, void *_buf, unsigned int bufsize)
{
	struct cim_serial *css = (struct cim_serial *) _css;
	struct umser_msg_raw *buf = (struct umser_msg_raw *) _buf;
	unsigned int i;

	assert(bufsize == sizeof(*buf));

	for (i = 0; i < buf->len; i++) {
		sig_serial_send(css->sig_serial, css, buf->data[i]);
	}
}

void
cim_serial_init(struct cim_serial *css, struct sig_serial *sig_serial)
{
	static const struct sig_serial_funcs funcs = {
		.recv = cim_serial_recv,
	};

	cim_connect(&css->bridge, cim_serial_interrupt, css);

	css->sig_serial = sig_serial;
	sig_serial_connect(sig_serial, css, &funcs);
}

void
cim_serial_create(struct cim_serial *css)
{
	cim_create(&css->bridge);
}

void
cim_serial_destroy(struct cim_serial *css)
{
	cim_destroy(&css->bridge);
}
