#!/usr/bin/env python3
# -*- coding: utf-8 -*-

# Fenrir TTY screen reader
# By Chrys, Storm Dragon, and contributors.

import time

from fenrirscreenreader.core.i18n import _


class command:
    def __init__(self):
        pass

    def initialize(self, environment):
        self.env = environment
        self.env["runtime"]["MemoryManager"].add_index_list(
            "clipboardHistory",
            self.env["runtime"]["SettingsManager"].get_setting_as_int(
                "general", "numberOfClipboards"
            ),
        )

    def shutdown(self):
        pass

    def get_description(self):
        return _("pastes the text from the currently selected clipboard")

    def run(self):
        if self.env["runtime"]["MemoryManager"].is_index_list_empty(
            "clipboardHistory"
        ):
            self.env["runtime"]["OutputManager"].present_text(
                _("clipboard empty"), interrupt=True
            )
            return
        self.env["runtime"]["OutputManager"].present_text(
            "paste clipboard",
            sound_icon="PasteClipboardOnScreen",
            interrupt=True,
        )
        clipboard = self.env["runtime"][
            "MemoryManager"
        ].get_index_list_element("clipboardHistory")
        self.env["runtime"]["ScreenManager"].inject_text_to_screen(clipboard)

    def set_callback(self, callback):
        pass
