/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.awt.image.BufferedImage;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.ImageTools;
import loci.formats.MetadataStore;
import loci.formats.RandomAccessStream;

public abstract class ImageIOReader
extends FormatReader {
    public ImageIOReader(String name, String suffix) {
        super(name, suffix);
    }

    public ImageIOReader(String name, String[] suffixes) {
        super(name, suffixes);
    }

    public boolean isThisType(byte[] block) {
        return false;
    }

    public byte[] openBytes(int no, byte[] buf) throws FormatException, IOException {
        int bytesPerChannel;
        buf = ImageTools.getBytes(this.openImage(no), false, no);
        if (buf.length > (bytesPerChannel = this.core.sizeX[0] * this.core.sizeY[0])) {
            byte[] tmp = buf;
            buf = new byte[bytesPerChannel * 3];
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(tmp, i * bytesPerChannel, buf, i * bytesPerChannel, bytesPerChannel);
            }
        }
        return buf;
    }

    public BufferedImage openImage(int no) throws FormatException, IOException {
        FormatTools.assertId(this.currentId, true, 1);
        FormatTools.checkPlaneNumber(this, no);
        RandomAccessStream ras = new RandomAccessStream(this.currentId);
        DataInputStream dis = new DataInputStream(new BufferedInputStream(ras, 4096));
        BufferedImage b = ImageIO.read(dis);
        ras.close();
        dis.close();
        return b;
    }

    public void close(boolean fileOnly) throws IOException {
    }

    public void close() throws IOException {
        this.currentId = null;
    }

    protected void initFile(String id) throws FormatException, IOException {
        if (debug) {
            this.debug("ImageIOReader.initFile(" + id + ")");
        }
        super.initFile(id);
        this.status("Populating metadata");
        this.core.imageCount[0] = 1;
        BufferedImage img = this.openImage(0);
        this.core.sizeX[0] = img.getWidth();
        this.core.sizeY[0] = img.getHeight();
        this.core.rgb[0] = img.getRaster().getNumBands() > 1;
        this.core.sizeZ[0] = 1;
        this.core.sizeC[0] = this.core.rgb[0] ? 3 : 1;
        this.core.sizeT[0] = 1;
        this.core.currentOrder[0] = "XYCZT";
        this.core.pixelType[0] = ImageTools.getPixelType(img);
        this.core.interleaved[0] = false;
        this.core.littleEndian[0] = false;
        this.core.metadataComplete[0] = true;
        this.core.indexed[0] = false;
        this.core.falseColor[0] = false;
        MetadataStore store = this.getMetadataStore();
        store.setImage(this.currentId, null, null, null);
        FormatTools.populatePixels(store, this);
        for (int i = 0; i < this.core.sizeC[0]; ++i) {
            store.setLogicalChannel(i, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null);
        }
    }
}

