/*---------------------------------------------------------------------------*\
  =========                 |
  \\      /  F ield         | OpenFOAM: The Open Source CFD Toolbox
   \\    /   O peration     |
    \\  /    A nd           | Copyright (C) 1991-2010 OpenCFD Ltd.
     \\/     M anipulation  |
-------------------------------------------------------------------------------
License
    This file is part of OpenFOAM.

    OpenFOAM is free software: you can redistribute it and/or modify it
    under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    OpenFOAM is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
    for more details.

    You should have received a copy of the GNU General Public License
    along with OpenFOAM.  If not, see <http://www.gnu.org/licenses/>.

Class
    Foam::cpuTimeImpl

Description
    Starts timing CPU usage and return elapsed time from start.

    This is the platform specific opaque implementation for class cpuTime.

SeeAlso
    clockTime

SourceFiles
    cpuTimeImpl.C

\*---------------------------------------------------------------------------*/

#ifndef cpuTimeImpl_H
#define cpuTimeImpl_H

#include <time.h>
#include <sys/times.h>

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

namespace Foam
{

/*---------------------------------------------------------------------------*\
                           Class cpuTimeImpl Declaration
\*---------------------------------------------------------------------------*/

class cpuTimeImpl
{
    // Private data

        static long Hz_;

        struct tms startTime_;
        mutable struct tms lastTime_;
        mutable struct tms newTime_;

        static void getTime(struct tms& t);

        static double timeDifference
        (
            const struct tms& start,
            const struct tms& end
        );


public:

    // Constructors

        //- Construct from components
        cpuTimeImpl();


    // Member Functions

        // Access

            //- Returns CPU time from start of run
            double elapsedCpuTime() const;

            //- Returns CPU time from last call of cpuTimeIncrement()
            double cpuTimeIncrement() const;
};


// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

} // End namespace Foam

// * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * //

#endif

// ************************ vim: set sw=4 sts=4 et: ************************ //
